/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class TurnUndead
extends SpellRay {
    public TurnUndead() {
        super("ancientspellcraft", "turn_undead", SpellActions.POINT_UP, false);
        this.addProperties(new String[]{"effect_duration", "effect_strength"});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        EntityLivingBase livingTarget = (EntityLivingBase)target;
        if (ASUtils.isEntityConsideredUndead((Entity)livingTarget) && livingTarget.func_184222_aU() && !(target instanceof INpc)) {
            EntityLivingBase targetEntity = (EntityLivingBase)target;
            int bonusAmplifier = SpellBuff.getStandardBonusAmplifier((float)modifiers.get("potency"));
            NBTTagCompound entityNBT = targetEntity.getEntityData();
            if (entityNBT != null) {
                entityNBT.func_186854_a("fearedEntity", caster.func_110124_au());
            }
            targetEntity.func_70690_d(new PotionEffect(WizardryPotions.fear, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), this.getProperty("effect_strength").intValue() + bonusAmplifier));
            origin = targetEntity.func_174824_e(1.0f);
            for (int i = 0; i < 30; ++i) {
                double x = origin.field_72450_a - 1.0 + world.field_73012_v.nextDouble() * 2.0;
                double y = origin.field_72448_b - 0.25 + world.field_73012_v.nextDouble() * 0.5;
                double z = origin.field_72449_c - 1.0 + world.field_73012_v.nextDouble() * 2.0;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).clr(1.0f, 1.0f, 0.3f).spawn(world);
            }
            return true;
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    protected void spawnParticleRay(World world, Vec3d origin, Vec3d direction, @Nullable EntityLivingBase caster, double distance) {
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

