/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.block.ITemporaryBlock;
import com.windanesz.ancientspellcraft.entity.living.EntityEvilClassWizard;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.entity.construct.EntityBlizzard;
import electroblob.wizardry.entity.construct.EntityStormcloud;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellConstructRanged;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TernaryStorm
extends SpellConstructRanged<EntityStormcloud>
implements IClassSpell {
    public TernaryStorm() {
        super("ancientspellcraft", "ternary_storm", EntityStormcloud::new, false);
        this.addProperties(new String[]{"damage", "effect_radius"});
        this.floor(true);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        boolean f = super.cast(world, caster, hand, ticksInUse, modifiers);
        Vec3d look = caster.func_70040_Z();
        double range = this.getProperty("range").doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade);
        double x = caster.field_70165_t + look.field_72450_a * range;
        double y = caster.field_70163_u + (double)caster.func_70047_e() + look.field_72448_b * range + 2.0;
        double z = caster.field_70161_v + look.field_72449_c * range;
        if (f && world.field_72995_K) {
            double speed;
            float r;
            int i;
            for (i = 0; i < 100; ++i) {
                r = world.field_73012_v.nextFloat();
                speed = 0.02 / (double)r * (1.0 + world.field_73012_v.nextDouble());
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).pos(x, y + world.field_73012_v.nextDouble() * 3.0, z).vel(0.0, 0.0, 0.0).scale(2.0f).time(40 + world.field_73012_v.nextInt(10)).spin(world.field_73012_v.nextDouble() * 3.5 + 0.5, speed).spawn(world);
            }
            for (i = 0; i < 60; ++i) {
                r = world.field_73012_v.nextFloat();
                speed = 0.02 / (double)r * (1.0 + world.field_73012_v.nextDouble());
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.CLOUD).pos(x, y + world.field_73012_v.nextDouble() * 2.5, z).clr(DrawingUtils.mix((int)DrawingUtils.mix((int)16760320, (int)16725504, (float)(r / 0.6f)), (int)0x222222, (float)((r - 0.6f) / 0.4f))).spin((double)(r * 3.0f) + 0.5, speed).spawn(world);
            }
        }
        return f;
    }

    protected void addConstructExtras(EntityStormcloud construct, EnumFacing side, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        EntityBlizzard blizzard = new EntityBlizzard(construct.field_70170_p);
        if (caster != null) {
            blizzard.setCaster(caster);
        }
        blizzard.func_70107_b(construct.field_70165_t, construct.field_70163_u, construct.field_70161_v);
        blizzard.lifetime = 40;
        blizzard.setSizeMultiplier(modifiers.get(WizardryItems.blast_upgrade));
        construct.field_70170_p.func_72838_d((Entity)blizzard);
        BlockPos pos = construct.func_180425_c();
        World world = construct.field_70170_p;
        BlockPos finalPos = pos.func_177977_b();
        List list = BlockUtils.getBlockSphere((BlockPos)pos, (double)(modifiers.get(WizardryItems.blast_upgrade) * (float)this.getProperty("effect_radius").intValue())).stream().filter(i -> !world.func_175623_d(i)).filter(i -> i.func_177956_o() == finalPos.func_177956_o()).collect(Collectors.toList());
        int blockLifetime = this.getProperty("duration").intValue();
        for (BlockPos currPos : list) {
            boolean magma = world.field_73012_v.nextBoolean();
            if (magma) {
                if (world.field_73012_v.nextBoolean() && world.func_175623_d(currPos.func_177984_a())) {
                    world.func_180501_a(currPos.func_177984_a(), Blocks.field_150480_ab.func_176223_P(), 11);
                }
                ITemporaryBlock.placeTemporaryBlock(caster, world, ASBlocks.CONJURED_MAGMA, currPos, blockLifetime);
                continue;
            }
            if (!world.func_180495_p((currPos = currPos.func_177984_a()).func_177977_b()).isSideSolid((IBlockAccess)world, currPos.func_177977_b(), EnumFacing.UP) || !BlockUtils.canBlockBeReplaced((World)world, (BlockPos)currPos) || !BlockUtils.canPlaceBlock((Entity)caster, (World)world, (BlockPos)currPos)) continue;
            world.func_175656_a(currPos, WizardryBlocks.permafrost.func_176223_P());
            world.func_175684_a(currPos.func_185334_h(), WizardryBlocks.permafrost, blockLifetime);
        }
        construct.field_70163_u += 5.0;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return npc instanceof EntityEvilClassWizard && ((EntityEvilClassWizard)npc).getArmourClass() == ItemWizardArmour.ArmourClass.SAGE;
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.SAGE;
    }

    @Override
    public boolean applicableForItem(Item item) {
        return item == ASItems.mystic_spell_book;
    }
}

