/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.projectile.EntityAOEProjectile;
import com.windanesz.ancientspellcraft.integration.artemislib.ASArtemisLibIntegration;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.entity.projectile.EntityMagicProjectile;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellProjectile;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class SpellProjectileAOEPotion<T extends EntityMagicProjectile>
extends SpellProjectile<T> {
    protected final float r;
    protected final float g;
    protected final float b;
    protected final Supplier<Potion>[] effects;
    private Set<Potion> potionSet;
    private MagicDamage.DamageType damageType = MagicDamage.DamageType.MAGIC;
    private ResourceLocation particle = ParticleBuilder.Type.SPARKLE;
    private int maxLevel;

    public SpellProjectileAOEPotion(String name, Function<World, T> projectileFactory, float r, float g, float b, Supplier<Potion> ... effects) {
        super("ancientspellcraft", name, projectileFactory);
        this.effects = effects;
        this.r = r;
        this.g = g;
        this.b = b;
        this.addProperties(new String[]{"effect_radius"});
        if (!ASArtemisLibIntegration.enabled()) {
            this.setEnabled(false);
        }
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (ASArtemisLibIntegration.enabled()) {
            return super.cast(world, caster, hand, ticksInUse, modifiers);
        }
        if (!world.field_72995_K) {
            caster.func_146105_b((ITextComponent)new TextComponentTranslation("tooltip.ancientspellcraft:missing_artemislib.disabled_spell", new Object[0]), false);
        }
        return false;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return ASArtemisLibIntegration.enabled() && super.cast(world, caster, hand, ticksInUse, target, modifiers);
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        return ASArtemisLibIntegration.enabled() && super.cast(world, x, y, z, direction, ticksInUse, duration, modifiers);
    }

    public void init() {
        this.potionSet = Arrays.stream(this.effects).map(Supplier::get).collect(Collectors.toSet());
        for (Potion potion : this.potionSet) {
            this.addProperties(new String[]{SpellProjectileAOEPotion.getStrengthKey(potion)});
            if (potion.func_76403_b()) continue;
            this.addProperties(new String[]{SpellProjectileAOEPotion.getDurationKey(potion)});
        }
    }

    public MagicDamage.DamageType getDamageType() {
        return this.damageType;
    }

    public ResourceLocation getParticle() {
        return this.particle;
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    protected static String getDurationKey(Potion potion) {
        return potion.getRegistryName().func_110623_a() + "_duration";
    }

    protected static String getStrengthKey(Potion potion) {
        return potion.getRegistryName().func_110623_a() + "_strength";
    }

    public boolean applyPotionEffects(EntityLivingBase caster, SpellModifiers modifiers) {
        int bonusAmplifier = this.getBonusAmplifier(modifiers.get("potency"));
        for (Potion potion : this.potionSet) {
            caster.func_70690_d(new PotionEffect(potion, potion.func_76403_b() ? 1 : (int)(this.getProperty(SpellProjectileAOEPotion.getDurationKey(potion)).floatValue() * modifiers.get(WizardryItems.duration_upgrade)), Math.min(this.maxLevel + 1, (int)this.getProperty(SpellProjectileAOEPotion.getStrengthKey(potion)).floatValue() + bonusAmplifier + 1), false, true));
        }
        return true;
    }

    protected int getBonusAmplifier(float potencyModifier) {
        return SpellProjectileAOEPotion.getStandardBonusAmplifier(potencyModifier);
    }

    public static int getStandardBonusAmplifier(float potencyModifier) {
        return (int)((double)(potencyModifier - 1.0f) / 0.4);
    }

    protected void addProjectileExtras(T projectile, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        ((EntityAOEProjectile)((Object)projectile)).setRelatedSpell(this);
        super.addProjectileExtras(projectile, caster, modifiers);
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

