/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityTimer;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpectralFloor
extends Spell
implements IClassSpell {
    private static final String BLOCK_LIFETIME = "block_lifetime";

    public SpectralFloor() {
        super("ancientspellcraft", "spectral_floor", SpellActions.POINT, false);
        this.addProperties(new String[]{BLOCK_LIFETIME, "effect_radius"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        BlockPos pos = caster.func_180425_c();
        pos = pos.func_177972_a(EnumFacing.DOWN);
        if (caster.field_70181_x < 0.0) {
            pos = pos.func_177972_a(EnumFacing.DOWN);
        }
        if (world.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5).scale(3.0f).clr(0.75f, 1.0f, 0.85f).spawn(world);
        } else {
            if (BlockUtils.canBlockBeReplaced((World)world, (BlockPos)pos) && !world.field_72995_K) {
                world.func_175656_a(pos, WizardryBlocks.spectral_block.func_176223_P());
                if (world.func_175625_s(pos) instanceof TileEntityTimer) {
                    ((TileEntityTimer)world.func_175625_s(pos)).setLifetime((int)(this.getProperty(BLOCK_LIFETIME).floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                }
            }
            BlockPos finalPos = pos;
            int blastUpgradeCount = (int)((modifiers.get(WizardryItems.blast_upgrade) - 1.0f) / 0.25f + 0.5f);
            List list = BlockUtils.getBlockSphere((BlockPos)pos, (double)(this.getProperty("effect_radius").intValue() - 1 + blastUpgradeCount)).stream().filter(arg_0 -> ((World)world).func_175623_d(arg_0)).filter(i -> i.func_177956_o() == finalPos.func_177956_o()).collect(Collectors.toList());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                BlockPos currPos = (BlockPos)list.get(i2);
                if (!BlockUtils.canBlockBeReplaced((World)world, (BlockPos)currPos) || world.field_72995_K) continue;
                world.func_175656_a(currPos, WizardryBlocks.spectral_block.func_176223_P());
                if (!(world.func_175625_s(currPos) instanceof TileEntityTimer)) continue;
                ((TileEntityTimer)world.func_175625_s(currPos)).setLifetime((int)(this.getProperty(BLOCK_LIFETIME).floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
            }
        }
        return true;
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.SAGE;
    }

    @Override
    public boolean applicableForItem(Item item) {
        return item == ASItems.mystic_spell_book;
    }
}

