/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.construct.EntityBuilder;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class ShockZone
extends SpellRay {
    public ShockZone() {
        super("ancientspellcraft", "shock_zone", SpellActions.POINT_DOWN, false);
        this.ignoreLivingEntities(true);
        this.addProperties(new String[]{"effect_duration", "effect_radius", "damage"});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        pos = pos.func_177984_a();
        return ShockZone.makeZone(world, caster, pos, modifiers);
    }

    public static boolean makeZone(World world, @Nullable EntityLivingBase caster, BlockPos pos, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            BlockPos finalPos = pos;
            List<BlockPos> listb = BlockUtils.getBlockSphere((BlockPos)pos, (double)((float)ASSpells.shock_zone.getProperty("effect_radius").intValue() * modifiers.get(WizardryItems.blast_upgrade))).stream().filter(arg_0 -> ((World)world).func_175623_d(arg_0)).filter(i -> i.func_177956_o() == finalPos.func_177956_o()).collect(Collectors.toList());
            EntityBuilder builder = new EntityBuilder(world);
            builder.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            builder.setCaster(caster);
            builder.blockLifetime = (int)(ASSpells.shock_zone.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
            builder.buildTickRate = 1;
            builder.batchSize = (int)(2.0f * modifiers.get("potency")) + (int)(3.0f * modifiers.get(WizardryItems.blast_upgrade));
            listb.sort(Comparator.comparingInt(Vec3i::func_177956_o));
            builder.setBuildList(listb);
            builder.setBlockToBuild(ASBlocks.lightning_block.func_176223_P());
            builder.damageMultiplier = ASSpells.shock_zone.getProperty("damage").floatValue() * modifiers.get("potency");
            world.func_72838_d((Entity)builder);
        }
        return true;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

