/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.item.ItemBattlemageSword;
import com.windanesz.ancientspellcraft.spell.Runeword;
import electroblob.wizardry.util.SpellModifiers;
import java.util.HashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class RunewordFury
extends Runeword {
    public static final String CHARGES_TAG = "charges";
    public static final String MAX_CHARGE_STACKS = "max_charge_stacks";
    public static final String DMG_PERCENT_INCREASE_PER_HIT = "dmg_percent_increase_per_hit";

    public RunewordFury() {
        super("runeword_fury", EnumAction.NONE, false);
        this.addProperties(new String[]{DMG_PERCENT_INCREASE_PER_HIT, MAX_CHARGE_STACKS});
        this.setPassive();
        this.affectsAttributes();
        this.enableTickEffect();
    }

    @Override
    public void tick(EntityLivingBase wielder, ItemStack sword) {
        if (wielder.field_70173_aa % 40 == 0) {
            this.decrementFury(sword);
        }
    }

    @Override
    public boolean onAboutToHitEntity(World world, EntityLivingBase caster, EntityLivingBase target, EnumHand hand, ItemStack sword, SpellModifiers modifiers, boolean charged) {
        if (!caster.field_70170_p.field_72995_K) {
            this.incrementFury(sword);
        }
        return true;
    }

    public void incrementFury(ItemStack sword) {
        HashMap<Runeword, NBTTagCompound> data = ItemBattlemageSword.getTemporaryRunewordData(sword);
        if (data.containsKey(this)) {
            int charges;
            NBTTagCompound fury = data.get(this);
            if (fury.func_74764_b(CHARGES_TAG) && (charges = fury.func_74762_e(CHARGES_TAG)) < this.getProperty(MAX_CHARGE_STACKS).intValue()) {
                fury.func_74768_a(CHARGES_TAG, ++charges);
                ItemBattlemageSword.setTemporaryRuneWordData(sword, this, fury);
            }
        } else {
            NBTTagCompound fury = new NBTTagCompound();
            fury.func_74768_a(CHARGES_TAG, 1);
            ItemBattlemageSword.setTemporaryRuneWordData(sword, this, fury);
        }
    }

    public void decrementFury(ItemStack sword) {
        NBTTagCompound fury;
        HashMap<Runeword, NBTTagCompound> data = ItemBattlemageSword.getTemporaryRunewordData(sword);
        if (data.containsKey(this) && (fury = data.get(this)).func_74764_b(CHARGES_TAG)) {
            int charges = fury.func_74762_e(CHARGES_TAG);
            if (charges > 0) {
                fury.func_74768_a(CHARGES_TAG, --charges);
                ItemBattlemageSword.setTemporaryRuneWordData(sword, this, fury);
            } else {
                ItemBattlemageSword.setTemporaryRuneWordData(sword, this, null);
            }
        }
    }
}

