/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.spell.SpellBuffAS;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Regrowth
extends SpellBuffAS {
    protected boolean ignoreLivingEntities = false;
    protected static final double Y_OFFSET = 0.25;
    protected double particleSpacing = 0.85;
    protected double particleJitter = 0.1;
    protected double particleVelocity = 0.0;

    public Regrowth() {
        super("regrowth", 201.0f, 90.0f, 168.0f, () -> MobEffects.field_76428_l);
        this.addProperties(new String[]{"range"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (caster.func_70093_af()) {
            Vec3d look = caster.func_70040_Z();
            Vec3d origin = new Vec3d(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e() - 0.25, caster.field_70161_v);
            if (!this.isContinuous && world.field_72995_K && !Wizardry.proxy.isFirstPerson((Entity)caster)) {
                origin = origin.func_178787_e(look.func_186678_a(1.2));
            }
            if (!this.shootSpell(world, origin, look, (EntityLivingBase)caster, ticksInUse, modifiers)) {
                return false;
            }
            caster.func_184609_a(hand);
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return super.cast(world, caster, hand, ticksInUse, modifiers);
    }

    protected boolean shootSpell(World world, Vec3d origin, Vec3d direction, @Nullable EntityLivingBase caster, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getProperty("range").doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade);
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a(range));
        RayTraceResult rayTrace = RayTracer.rayTrace((World)world, (Vec3d)origin, (Vec3d)endpoint, (float)0.0f, (boolean)false, (boolean)true, (boolean)false, Entity.class, (Predicate)(this.ignoreLivingEntities ? EntityUtils::isLiving : RayTracer.ignoreEntityFilter((Entity)caster)));
        boolean flag = false;
        if (rayTrace != null) {
            if (rayTrace.field_72313_a == RayTraceResult.Type.ENTITY) {
                flag = this.onEntityHit(world, rayTrace.field_72308_g, rayTrace.field_72307_f, caster, origin, ticksInUse, modifiers);
                if (flag) {
                    range = origin.func_72438_d(rayTrace.field_72307_f);
                }
            } else {
                return false;
            }
        }
        if (!flag) {
            return false;
        }
        if (world.field_72995_K) {
            this.spawnParticleRay(world, origin, direction, caster, range);
        }
        return true;
    }

    private boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityLivingBase) {
            return this.applyEffects((EntityLivingBase)target, modifiers);
        }
        return false;
    }

    protected void spawnParticleRay(World world, Vec3d origin, Vec3d direction, @Nullable EntityLivingBase caster, double distance) {
        Vec3d velocity = direction.func_186678_a(this.particleVelocity);
        for (double d = this.particleSpacing; d <= distance; d += this.particleSpacing) {
            double x = origin.field_72450_a + d * direction.field_72450_a + this.particleJitter * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
            double y = origin.field_72448_b + d * direction.field_72448_b + this.particleJitter * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
            double z = origin.field_72449_c + d * direction.field_72449_c + this.particleJitter * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
            this.spawnParticle(world, x, y, z, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(201, 90, 168).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(80, 187, 114).spawn(world);
    }
}

