/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PuppetMaster
extends SpellRay {
    public PuppetMaster() {
        super("ancientspellcraft", "puppet_master", SpellActions.POINT, false);
        this.soundValues(1.0f, 1.2f, 0.2f);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityLivingBase) {
            boolean commanded = false;
            if (target instanceof EntityPlayer && AllyDesignationSystem.isAllied((EntityLivingBase)caster, (EntityLivingBase)((EntityPlayer)target))) {
                return false;
            }
            List<EntityLiving> minions = this.getAllMinionsInRadius(caster, caster.func_180425_c(), world, modifiers);
            for (EntityLivingBase entityLivingBase : minions) {
                if (entityLivingBase == target) continue;
                if (!world.field_72995_K) {
                    ((EntityLiving)entityLivingBase).func_70624_b((EntityLivingBase)target);
                }
                commanded = true;
            }
            return commanded;
        }
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        boolean commanded = false;
        List<EntityLiving> minions = this.getAllMinionsInRadius(caster, caster.func_180425_c(), world, modifiers);
        boolean negativeOffset = false;
        int index = 0;
        for (EntityLivingBase entityLivingBase : minions) {
            if (!world.field_72995_K) {
                if (caster.func_70093_af()) {
                    pos = pos.func_177967_a(caster.func_174811_aO().func_176746_e(), negativeOffset ? -1 * index : index);
                    ((EntityLiving)entityLivingBase).field_70144_Y = 1.0f;
                }
                ((EntityLiving)entityLivingBase).func_70624_b(null);
                ((EntityLiving)entityLivingBase).func_70661_as().func_75499_g();
                ((EntityLiving)entityLivingBase).func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0);
                negativeOffset = !negativeOffset;
                ++index;
            }
            commanded = true;
        }
        return commanded;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        if (caster != null && caster.func_70093_af()) {
            boolean commanded = false;
            List<EntityLiving> minions = this.getAllMinionsInRadius(caster, caster.func_180425_c(), world, modifiers);
            for (EntityLivingBase entityLivingBase : minions) {
                if (!world.field_72995_K) {
                    ((EntityLiving)entityLivingBase).func_70624_b(null);
                    ((EntityLiving)entityLivingBase).func_70661_as().func_75497_a((Entity)caster, 1.1);
                }
                commanded = true;
            }
            return commanded;
        }
        return false;
    }

    private List<EntityLiving> getAllMinionsInRadius(EntityLivingBase owner, BlockPos pos, World world, SpellModifiers modifiers) {
        double radius = this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        List entities = EntityUtils.getEntitiesWithinRadius((double)radius, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (World)world, EntityLiving.class);
        ArrayList<EntityLiving> minions = new ArrayList<EntityLiving>();
        for (EntityLiving entity : entities) {
            if (!(entity instanceof ISummonedCreature) || ((ISummonedCreature)entity).func_184753_b() != owner.func_110124_au()) continue;
            minions.add(entity);
        }
        return minions;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

