/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASDimensions;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.util.SpellTeleporter;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class PocketDimension
extends Spell {
    public static final IStoredVariable<NBTTagCompound> POCKET_DIM_LOCATION = IStoredVariable.StoredVariable.ofNBT((String)"pocket_dim_location", (Persistence)Persistence.ALWAYS).setSynced();
    public static final IStoredVariable<NBTTagCompound> POCKET_DIM_PREVIOUS_LOCATION = IStoredVariable.StoredVariable.ofNBT((String)"pocket_dim_previous_location", (Persistence)Persistence.ALWAYS).setSynced();

    public PocketDimension() {
        super("ancientspellcraft", "pocket_dimension", EnumAction.BLOCK, true);
        this.soundValues(0.8f, 1.2f, 0.2f);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{POCKET_DIM_LOCATION, POCKET_DIM_PREVIOUS_LOCATION});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (ticksInUse == 0) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            if (!world.field_72995_K) {
                WorldServer destinationWorld = caster.func_184102_h().func_71218_a(ASDimensions.POCKET_DIM_ID);
                PocketDimension.checkOrInitPocketData(caster, (World)destinationWorld);
                return true;
            }
        }
        if (world.field_72995_K) {
            this.spawnParticles(world, (EntityLivingBase)caster, modifiers);
        }
        if (ticksInUse == 60 && !world.field_72995_K) {
            return PocketDimension.teleportPlayer((EntityLivingBase)caster);
        }
        return true;
    }

    public static boolean teleportPlayer(EntityLivingBase caster) {
        EntityPlayer player;
        WizardData data;
        if (caster instanceof EntityPlayer && !caster.field_70170_p.field_72995_K && (data = WizardData.get((EntityPlayer)(player = (EntityPlayer)caster))) != null) {
            if (((EntityPlayer)caster).field_71093_bK == ASDimensions.POCKET_DIM_ID && data.getVariable(POCKET_DIM_PREVIOUS_LOCATION) != null) {
                Location previousPos = Location.fromNBT((NBTTagCompound)((NBTTagCompound)data.getVariable(POCKET_DIM_PREVIOUS_LOCATION)));
                SpellTeleporter.teleportEntity(previousPos.dimension, previousPos.pos.func_177958_n(), previousPos.pos.func_177956_o() + 1, previousPos.pos.func_177952_p(), true, player);
                return true;
            }
            data.setVariable(POCKET_DIM_PREVIOUS_LOCATION, (Object)new Location(player.func_180425_c(), player.field_71093_bK).toNBT());
            data.sync();
            NBTTagCompound location = (NBTTagCompound)data.getVariable(POCKET_DIM_LOCATION);
            if (location != null) {
                BlockPos pocketPos = NBTUtil.func_186861_c((NBTTagCompound)location);
                SpellTeleporter.teleportEntity(ASDimensions.POCKET_DIM_ID, pocketPos.func_177958_n(), pocketPos.func_177956_o(), pocketPos.func_177952_p(), true, player);
                return true;
            }
        }
        return false;
    }

    protected void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        for (int i = 0; i < 10; ++i) {
            double dx = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
            double dy = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
            double dz = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).entity((Entity)caster).clr(50, 168, 72).pos(0.0, (double)(caster.field_70131_O / 2.0f), 0.0).vel(dx, dy, dz).spawn(world);
        }
    }

    public static void checkOrInitPocketData(EntityPlayer player, World pocketWorld) {
        NBTTagCompound compound;
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null && (compound = (NBTTagCompound)data.getVariable(POCKET_DIM_LOCATION)) == null) {
            BlockPos pocketLocation = PocketDimension.findSuitablePocketPos(pocketWorld);
            PocketDimension.createPocket(pocketLocation, pocketWorld);
            PocketDimension.setPocketDimLocation(data, pocketLocation);
        }
    }

    public static void setPocketDimLocation(WizardData data, BlockPos pocketLocation) {
        NBTTagCompound nbt = NBTUtil.func_186859_a((BlockPos)pocketLocation.func_177972_a(EnumFacing.UP));
        data.setVariable(POCKET_DIM_LOCATION, (Object)nbt);
        data.sync();
    }

    public static void createPocket(BlockPos pos, World pocketWorld) {
        int pocketSize = 6;
        int pocketHeight = 11;
        PocketDimension.createPlatform(pos, pocketWorld, pocketHeight);
        PocketDimension.createWalls(pos, pocketWorld, pocketSize, pocketHeight);
        PocketDimension.createPlatform(pos.func_177967_a(EnumFacing.UP, pocketHeight + 1), pocketWorld, pocketSize);
        pocketWorld.func_175656_a(pos, ASBlocks.DIMENSION_FOCUS.func_176223_P());
    }

    public static BlockPos findSuitablePocketPos(World pocketWorld) {
        BlockPos currPos = new BlockPos(0, 1, 0);
        while (!PocketDimension.isSuitablePosition(currPos, pocketWorld)) {
            currPos = PocketDimension.getRandomLocationWithOffset(currPos);
        }
        return currPos;
    }

    private static boolean isSuitablePosition(BlockPos pos, World pocketWorld) {
        boolean isFree = true;
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)pos.func_177967_a(EnumFacing.WEST, 250).func_177967_a(EnumFacing.SOUTH, 250).func_177972_a(EnumFacing.DOWN), (BlockPos)pos.func_177967_a(EnumFacing.EAST, 250).func_177967_a(EnumFacing.NORTH, 250).func_177972_a(EnumFacing.UP))) {
            if (pocketWorld.func_175623_d(currPos)) continue;
            isFree = false;
            break;
        }
        return isFree;
    }

    private static BlockPos getRandomLocationWithOffset(BlockPos origPos) {
        int i;
        Random rand = new Random();
        int n = i = rand.nextBoolean() ? 1 : -1;
        EnumFacing facing = rand.nextBoolean() ? EnumFacing.NORTH : (rand.nextBoolean() ? EnumFacing.SOUTH : (rand.nextBoolean() ? EnumFacing.EAST : EnumFacing.WEST));
        return origPos.func_177967_a(facing, 300 * i);
    }

    private static void createPlatform(BlockPos pos, World pocketWorld, int size) {
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)pos.func_177967_a(EnumFacing.SOUTH, size).func_177967_a(EnumFacing.WEST, size), (BlockPos)pos.func_177967_a(EnumFacing.NORTH, size).func_177967_a(EnumFacing.EAST, size))) {
            pocketWorld.func_175656_a(currPos, ASBlocks.DIMENSION_BOUNDARY.func_176223_P());
        }
    }

    private static void createWalls(BlockPos center, World pocketWorld, int width, int height) {
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)center.func_177967_a(EnumFacing.SOUTH, width).func_177967_a(EnumFacing.WEST, width), (BlockPos)center.func_177967_a(EnumFacing.NORTH, width).func_177967_a(EnumFacing.WEST, width).func_177967_a(EnumFacing.UP, height))) {
            pocketWorld.func_175656_a(currPos, ASBlocks.DIMENSION_BOUNDARY.func_176223_P());
        }
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)center.func_177967_a(EnumFacing.SOUTH, width).func_177967_a(EnumFacing.EAST, width), (BlockPos)center.func_177967_a(EnumFacing.NORTH, width).func_177967_a(EnumFacing.EAST, width).func_177967_a(EnumFacing.UP, height))) {
            pocketWorld.func_175656_a(currPos, ASBlocks.DIMENSION_BOUNDARY.func_176223_P());
        }
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)center.func_177967_a(EnumFacing.SOUTH, width).func_177967_a(EnumFacing.EAST, -width), (BlockPos)center.func_177967_a(EnumFacing.SOUTH, width).func_177967_a(EnumFacing.EAST, width).func_177967_a(EnumFacing.UP, height))) {
            pocketWorld.func_175656_a(currPos, ASBlocks.DIMENSION_BOUNDARY.func_176223_P());
        }
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)center.func_177967_a(EnumFacing.NORTH, width).func_177967_a(EnumFacing.WEST, -width), (BlockPos)center.func_177967_a(EnumFacing.NORTH, width).func_177967_a(EnumFacing.WEST, width).func_177967_a(EnumFacing.UP, height))) {
            pocketWorld.func_175656_a(currPos, ASBlocks.DIMENSION_BOUNDARY.func_176223_P());
        }
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

