/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Banish;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class PhaseJump
extends Spell
implements IClassSpell {
    public static final String MINIMUM_TELEPORT_DISTANCE = "minimum_teleport_distance";
    public static final String MAXIMUM_TELEPORT_DISTANCE = "maximum_teleport_distance";
    public static final String EXTRA_DISTANCE_PER_SECOND = "extra_distance_per_second";

    public PhaseJump() {
        super("ancientspellcraft", "phase_jump", SpellActions.POINT_UP, true);
        this.addProperties(new String[]{MINIMUM_TELEPORT_DISTANCE, MAXIMUM_TELEPORT_DISTANCE, EXTRA_DISTANCE_PER_SECOND});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    public void finishCasting(World world, @Nullable EntityLivingBase caster, double x, double y, double z, @Nullable EnumFacing direction, int duration, SpellModifiers modifiers) {
        if (caster != null) {
            double minRadius = this.getProperty(MINIMUM_TELEPORT_DISTANCE).doubleValue();
            double maxRadius = this.getProperty(MAXIMUM_TELEPORT_DISTANCE).doubleValue();
            double bonus = (double)((float)duration / 20.0f) * this.getProperty(EXTRA_DISTANCE_PER_SECOND).doubleValue();
            double radius = (minRadius + world.field_73012_v.nextDouble() * (maxRadius - minRadius)) * (double)modifiers.get(WizardryItems.blast_upgrade) + bonus;
            ((Banish)Spells.banish).teleport(caster, world, radius);
        }
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return super.cast(world, caster, hand, ticksInUse, target, modifiers);
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.SAGE;
    }

    @Override
    public boolean applicableForItem(Item item) {
        return item == ASItems.mystic_spell_book;
    }
}

