/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class MasterBolt
extends Spell {
    public static final IStoredVariable<List<Location>> MASTER_BOLT_LOCATIONS_KEY = new IStoredVariable.StoredVariable("masterBoltLocationsKey", s -> NBTExtras.listToNBT((Collection)s, Location::toNBT), t -> new ArrayList(NBTExtras.NBTToList((NBTTagList)t, Location::fromNBT)), Persistence.RESPAWN).setSynced();

    public MasterBolt() {
        super("ancientspellcraft", "master_bolt", SpellActions.POINT_UP, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{MASTER_BOLT_LOCATIONS_KEY});
        this.addProperties(new String[]{"damage"});
    }

    public static void storeLocation(World world, EntityPlayer player, BlockPos pos) {
        WizardData data = WizardData.get((EntityPlayer)player);
        Location here = new Location(pos, player.field_71093_bK);
        ArrayList<Location> locations = (ArrayList<Location>)data.getVariable(MASTER_BOLT_LOCATIONS_KEY);
        if (locations == null) {
            locations = new ArrayList<Location>(3);
            data.setVariable(MASTER_BOLT_LOCATIONS_KEY, locations);
        }
        if (!locations.contains(here)) {
            locations.add(here);
            if (!world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:master_bolt.remember", new Object[0]), true);
            }
            if (locations.size() > 3) {
                Location removed = (Location)locations.remove(0);
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:master_bolt.forget", new Object[0]), true);
                }
            }
        } else {
            if (locations.isEmpty()) {
                locations.add(here);
            } else {
                locations.remove(here);
                if (locations.isEmpty()) {
                    locations.add(here);
                } else {
                    locations.set(Math.max(locations.size() - 1, 0), here);
                }
            }
            if (!world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:master_bolt.confirm", new Object[0]), true);
            }
        }
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData data;
        if (caster != null && (data = WizardData.get((EntityPlayer)caster)) != null) {
            List locations = (List)data.getVariable(MASTER_BOLT_LOCATIONS_KEY);
            if (locations == null || locations.isEmpty()) {
                if (InventoryUtils.doesPlayerHaveItem((EntityPlayer)caster, (Item)ASItems.master_bolt)) {
                    return false;
                }
                ASUtils.giveStackToPlayer(caster, new ItemStack(ASItems.master_bolt));
                return true;
            }
            Location destination = (Location)locations.get(locations.size() - 1);
            if (destination.dimension == caster.field_71093_bK) {
                if (world.func_180495_p(destination.pos).func_177230_c() == ASBlocks.master_bolt) {
                    if (!world.field_72995_K) {
                        world.func_175698_g(destination.pos);
                    }
                    caster.func_70634_a((double)destination.pos.func_177958_n() + 0.5, (double)destination.pos.func_177956_o(), (double)destination.pos.func_177952_p() + 0.5);
                }
                locations.remove(destination);
                data.setVariable(MASTER_BOLT_LOCATIONS_KEY, (Object)locations);
                data.sync();
                return true;
            }
        }
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

