/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class IceWorkbench
extends SpellRay {
    public IceWorkbench(String modID, String name, EnumAction action, boolean isContinuous) {
        super(modID, name, SpellActions.POINT, false);
        this.soundValues(0.5f, 1.1f, 0.2f);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        pos = pos.func_177972_a(side);
        Random rand = new Random();
        if (world.field_72995_K) {
            for (int i = 1; i < 4; ++i) {
                double speed = (double)(rand.nextBoolean() ? 1 : -1) * 0.1;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.ICE).pos((double)pos.func_177958_n() + 0.8, (double)pos.func_177956_o() + rand.nextDouble() + 0.2, (double)pos.func_177952_p() + 0.8).vel(0.0, 0.0, 0.0).time(30).scale(1.0f).spin(rand.nextDouble() * 1.5, speed).spawn(world);
            }
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).clr(1.0f, 1.0f, 1.0f).pos((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5).time(30).scale(1.5f).spawn(world);
        }
        if (BlockUtils.canBlockBeReplaced((World)world, (BlockPos)pos)) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, ASBlocks.ICE_CRAFTING_TABLE.func_176223_P());
            }
            return true;
        }
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

