/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Forcefend
extends Spell {
    public Forcefend() {
        super("ancientspellcraft", "forcefend", SpellActions.SUMMON, true);
        this.addProperties(new String[]{"effect_radius"});
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        this.performEffect(world, caster.func_174824_e(0.0f).func_178786_a(0.0, 0.1, 0.0), (EntityLivingBase)caster, modifiers, ticksInUse);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        this.performEffect(world, caster.func_174824_e(0.0f).func_178786_a(0.0, 0.1, 0.0), (EntityLivingBase)caster, modifiers, ticksInUse);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        this.performEffect(world, new Vec3d(x, y, z), null, modifiers, ticksInUse);
        this.playSound(world, x - (double)direction.func_82601_c(), y - (double)direction.func_96559_d(), z - (double)direction.func_82599_e(), ticksInUse, duration, modifiers, new String[0]);
        return true;
    }

    private void performEffect(World world, Vec3d centre, @Nullable EntityLivingBase caster, SpellModifiers modifiers, int ticksInUse) {
        if (caster != null) {
            List projectiles = EntityUtils.getEntitiesWithinRadius((double)3.0, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)caster.field_70170_p, Entity.class);
            for (Entity projectile : projectiles) {
                if (this.isProjectileOnGround(projectile) || !(projectile instanceof IProjectile)) continue;
                List entites = EntityUtils.getEntitiesWithinRadius((double)15.0, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world, EntityLivingBase.class);
                if (entites.isEmpty()) {
                    this.deflectProjectile(caster, projectile);
                    continue;
                }
                for (EntityLivingBase entity : entites) {
                    if (entity == caster || AllyDesignationSystem.isAllied((EntityLivingBase)((EntityPlayer)caster), (EntityLivingBase)entity)) continue;
                    this.aimArrow(entity, projectile, (IProjectile)projectile);
                    return;
                }
            }
            if (world.field_72995_K) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).clr(255, 255, 247).fade(0, 0, 0).spin((double)0.8f, (double)0.07f).time(20).entity((Entity)caster).scale(1.2f).spawn(world);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).clr(255, 255, 247).vel(0.0, 0.1, 0.0).fade(0, 0, 0).spin((double)0.8f, (double)0.07f).time(20).entity((Entity)caster).scale(1.2f).spawn(world);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayNameWithFormatting() {
        return TextFormatting.GOLD + I18n.func_135052_a((String)this.getTranslationKey(), (Object[])new Object[0]);
    }

    public void aimArrow(EntityLivingBase target, Entity entity, IProjectile projectile) {
        double d0 = target.field_70165_t - entity.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entity.field_70163_u;
        double d2 = target.field_70161_v - entity.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        projectile.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.3f, (float)(14 - target.field_70170_p.func_175659_aa().func_151525_a() * 4));
    }

    private boolean isProjectileOnGround(Entity projectile) {
        return projectile.field_70170_p.func_184143_b(projectile.func_174813_aQ().func_186662_g(0.05));
    }

    private void deflectProjectile(EntityLivingBase entity, Entity projectile) {
        Vec3d centre = entity.func_174824_e(0.0f).func_178786_a(0.0, 0.1, 0.0);
        Vec3d vec = projectile.func_174791_d().func_178788_d(centre).func_72432_b().func_186678_a(0.6);
        projectile.func_70024_g(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

