/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ForceShove
extends SpellRay {
    public static final String REPULSION_VELOCITY = "repulsion_velocity";

    public ForceShove() {
        super("ancientspellcraft", "force_shove", SpellActions.POINT, false);
        this.soundValues(0.8f, 0.7f, 0.2f);
        this.addProperties(new String[]{REPULSION_VELOCITY, "damage"});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityPlayer && (caster instanceof EntityPlayer && !Wizardry.settings.playersMoveEachOther || ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)target), (Item)WizardryItems.amulet_anchoring))) {
            if (!world.field_72995_K && caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
            }
            return false;
        }
        if (target instanceof EntityLivingBase && !AllyDesignationSystem.isAllied((EntityLivingBase)caster, (EntityLivingBase)((EntityLivingBase)target))) {
            Vec3d vec = target.func_174824_e(1.0f).func_178788_d(origin).func_72432_b();
            if (!world.field_72995_K) {
                float velocity = this.getProperty(REPULSION_VELOCITY).floatValue() * modifiers.get("potency");
                target.field_70159_w = vec.field_72450_a * (double)velocity;
                target.field_70181_x = vec.field_72448_b * (double)velocity + 0.4;
                target.field_70179_y = vec.field_72449_c * (double)velocity;
                if (target instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(target));
                }
                double motionX = target.field_70159_w;
                double motionY = target.field_70181_x;
                double motionZ = target.field_70179_y;
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FORCE), this.getProperty("damage").floatValue() * modifiers.get("potency"));
                target.field_70159_w = motionX;
                target.field_70181_x = motionY;
                target.field_70179_y = motionZ;
            }
            if (world.field_72995_K) {
                double distance = target.func_70011_f(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c);
                int[] colours = (int[])BlockReceptacle.PARTICLE_COLOURS.get(Element.SORCERY);
                for (int i = 0; i < 25; ++i) {
                    double x = origin.field_72450_a + world.field_73012_v.nextDouble() - 0.3 + vec.field_72450_a * distance * 0.3;
                    double y = origin.field_72448_b + world.field_73012_v.nextDouble() - 0.3 + vec.field_72448_b * distance * 0.3;
                    double z = origin.field_72449_c + world.field_73012_v.nextDouble() - 0.3 + vec.field_72449_c * distance * 0.3;
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST, (Random)world.field_73012_v, (double)x, (double)y, (double)z, (double)1.0, (boolean)false).scale(world.field_73012_v.nextFloat() * 4.0f).clr(colours[1]).fade(colours[2]).time(10).vel(vec.field_72450_a * 0.8, vec.field_72448_b * 0.8, vec.field_72449_c * 0.8).spawn(world);
                }
            }
            this.playSound(world, (EntityLivingBase)target, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

