/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Drought
extends SpellRay {
    static Random rand = new Random();

    public Drought(String modID, String name, EnumAction action, boolean isContinuous) {
        super(modID, name, SpellActions.POINT, false);
        this.soundValues(1.0f, 1.0f, 0.4f);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            if (caster.func_184614_ca().func_77973_b() instanceof ISpellCastingItem) {
                caster.func_184609_a(EnumHand.MAIN_HAND);
            } else if (caster.func_184592_cb().func_77973_b() instanceof ISpellCastingItem) {
                caster.func_184609_a(EnumHand.OFF_HAND);
            }
        }
        if (BlockUtils.isBlockUnbreakable((World)world, (BlockPos)pos)) {
            return false;
        }
        if (!(caster instanceof EntityPlayer) && !EntityUtils.canDamageBlocks((Entity)caster, (World)world)) {
            return false;
        }
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos).getTileData().func_186855_b("arcaneLockOwner")) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        boolean flag = false;
        int blastUpgradeCount = (int)((modifiers.get(WizardryItems.blast_upgrade) - 1.0f) / 0.25f + 0.5f);
        float radius = 0.5f + 0.73f * (float)blastUpgradeCount;
        List sphere = BlockUtils.getBlockSphere((BlockPos)pos, (double)radius);
        if (radius <= 1.0f) {
            sphere.add(pos.func_177984_a());
        }
        for (BlockPos pos1 : sphere) {
            if (BlockUtils.isBlockUnbreakable((World)world, (BlockPos)pos1)) continue;
            Block block = world.func_180495_p(pos1).func_177230_c();
            if (world.field_72995_K && !world.func_175623_d(pos1) && world.func_175623_d(pos1.func_177984_a())) {
                Drought.spawnCloudParticles(world, pos1.func_177984_a(), 4);
            }
            if (world.field_72995_K || !(caster instanceof EntityPlayerMP)) continue;
            if (block instanceof BlockBush && !(block instanceof BlockDeadBush) && !(block instanceof BlockSapling)) {
                world.func_175698_g(pos1);
            }
            if (block instanceof BlockSapling) {
                world.func_175656_a(pos1, Blocks.field_150330_I.func_176223_P());
            }
            if (block instanceof BlockGrass) {
                world.func_175656_a(pos1, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
            }
            if (block instanceof BlockGrass) {
                world.func_175656_a(pos1, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
            }
            if (block instanceof BlockDirt) {
                world.func_175656_a(pos1, Blocks.field_150354_m.func_176223_P());
            }
            if (block instanceof BlockLiquid && world.func_180495_p(pos1).func_185904_a() == Material.field_151586_h) {
                world.func_175698_g(pos1);
            }
            if (!(block instanceof BlockLeaves)) continue;
            world.func_175698_g(pos1);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnCloudParticles(World worldIn, BlockPos pos, int amount) {
        IBlockState iblockstate;
        if (amount == 0) {
            amount = 15;
        }
        if ((iblockstate = worldIn.func_180495_p(pos)).func_185904_a() != Material.field_151579_a) {
            for (int i = 0; i < amount; ++i) {
                double d0 = rand.nextGaussian() * 0.02;
                double d1 = rand.nextGaussian() * 0.02;
                double d2 = rand.nextGaussian() * 0.02;
                worldIn.func_175688_a(EnumParticleTypes.CLOUD, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)pos.func_177956_o() + (double)rand.nextFloat() * iblockstate.func_185900_c((IBlockAccess)worldIn, (BlockPos)pos).field_72337_e, (double)((float)pos.func_177952_p() + rand.nextFloat()), d0, d1, d2, new int[0]);
            }
        } else {
            for (int i1 = 0; i1 < amount; ++i1) {
                double d0 = rand.nextGaussian() * 0.02;
                double d1 = rand.nextGaussian() * 0.02;
                double d2 = rand.nextGaussian() * 0.02;
                worldIn.func_175688_a(EnumParticleTypes.CLOUD, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)pos.func_177956_o() + (double)rand.nextFloat() * 1.0, (double)((float)pos.func_177952_p() + rand.nextFloat()), d0, d1, d2, new int[0]);
            }
        }
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

