/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class DispelItemCurse
extends SpellBuff {
    public DispelItemCurse(String modID, String name) {
        super(modID, name, 1.0f, 1.0f, 0.3f, new Supplier[0]);
        this.addProperties(new String[]{"effect_radius"});
        this.soundValues(1.0f, 1.2f, 0.2f);
    }

    protected boolean applyEffects(EntityLivingBase caster, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)caster;
            if (!player.func_184592_cb().func_190926_b()) {
                ItemStack offHandItemStack = player.func_184592_cb();
                return DispelItemCurse.attemptRemoveCurseFromItemStack(offHandItemStack);
            }
            ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
            for (ItemStack stack : player.func_184193_aE()) {
                if (stack.func_190926_b()) continue;
                itemStackList.add(stack);
            }
            if (!itemStackList.isEmpty()) {
                ItemStack stackToDispel = ASUtils.pickRandomStackFromItemStackList(itemStackList);
                return DispelItemCurse.attemptRemoveCurseFromItemStack(stackToDispel);
            }
        }
        return false;
    }

    private static boolean attemptRemoveCurseFromItemStack(ItemStack stack) {
        if (EnchantmentHelper.func_190938_b((ItemStack)stack)) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
            enchantments.remove(Enchantments.field_190941_k);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
            return true;
        }
        if (EnchantmentHelper.func_190939_c((ItemStack)stack)) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
            enchantments.remove(Enchantments.field_190940_C);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
            return true;
        }
        return false;
    }

    protected void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        super.spawnParticles(world, caster, modifiers);
        int i = 0;
        while ((float)i < this.particleCount * 2.0f) {
            double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            double y = caster.func_174813_aQ().field_72338_b + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
            double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.14, 0.0).clr(983067).time(20 + world.field_73012_v.nextInt(12)).spawn(world);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(983067).spawn(world);
            ++i;
        }
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

