/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.construct.EntityBuilder;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class DirtWall
extends SpellRay {
    private static final String BLOCK_LIFETIME = "block_lifetime";

    public DirtWall() {
        super("ancientspellcraft", "wall_of_dirt", SpellActions.SUMMON, false);
        this.ignoreLivingEntities(true);
        this.addProperties(new String[]{BLOCK_LIFETIME});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster.func_70093_af() && world.func_180495_p(pos).func_177230_c() == WizardryBlocks.spectral_block) {
            if (!world.field_72995_K) {
                world.func_175698_g(pos);
            } else {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5).scale(3.0f).clr(222, 92, 0).spawn(world);
            }
            return true;
        }
        pos = pos.func_177972_a(side);
        if (world.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5).scale(3.0f).clr(222, 92, 0).spawn(world);
        }
        if (!world.field_72995_K) {
            EnumFacing direction = caster.func_174811_aO().func_176746_e();
            ArrayList<BlockPos> wall = new ArrayList<BlockPos>();
            wall.add(pos);
            int blastUpgradeCount = (int)((modifiers.get(WizardryItems.blast_upgrade) - 1.0f) / 0.25f + 0.5f);
            for (int i = 0; i < 2 + blastUpgradeCount; ++i) {
                wall.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).func_177967_a(direction, i));
                wall.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).func_177967_a(direction, i).func_177972_a(EnumFacing.UP));
                wall.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).func_177967_a(direction, i).func_177967_a(EnumFacing.UP, 2));
                wall.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).func_177967_a(direction.func_176734_d(), i));
                wall.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).func_177967_a(direction.func_176734_d(), i).func_177972_a(EnumFacing.UP));
                wall.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).func_177967_a(direction.func_176734_d(), i).func_177967_a(EnumFacing.UP, 2));
            }
            EntityBuilder builder = new EntityBuilder(world);
            builder.func_70107_b(caster.func_180425_c().func_177958_n(), caster.func_180425_c().func_177956_o(), caster.func_180425_c().func_177952_p());
            builder.setCaster(caster);
            builder.lifetime = this.getProperty(BLOCK_LIFETIME).intValue();
            builder.blockLifetime = this.getProperty(BLOCK_LIFETIME).intValue();
            builder.buildTickRate = 1;
            builder.batchSize = (int)(2.0f * modifiers.get("potency")) + (int)(3.0f * modifiers.get(WizardryItems.blast_upgrade));
            wall.sort(Comparator.comparingInt(Vec3i::func_177956_o));
            builder.setBuildList(wall);
            builder.setBlockToBuild(ASBlocks.CONJURED_DIRT.func_176223_P());
            builder.setIgnoreClaims(false);
            world.func_72838_d((Entity)builder);
            return true;
        }
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

