/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IOverrideSpell;
import com.windanesz.ancientspellcraft.tileentity.TileEntityLightningBlock;
import electroblob.wizardry.data.IVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ChargeAS
extends Spell
implements IOverrideSpell {
    public static final IVariable<Integer> CHARGE_TIME = new IVariable.Variable(Persistence.NEVER).withTicker(ChargeAS::update);
    public static final IVariable<SpellModifiers> CHARGE_MODIFIERS = new IVariable.Variable(Persistence.NEVER);
    public static final String CHARGE_SPEED = "charge_speed";
    public static final String KNOCKBACK_STRENGTH = "knockback_strength";
    private static final double EXTRA_HIT_MARGIN = 1.0;

    public ChargeAS() {
        super("ebwizardry", "charge", SpellActions.POINT, false);
        this.addProperties(new String[]{CHARGE_SPEED, "duration", "damage", KNOCKBACK_STRENGTH});
        this.soundValues(0.6f, 1.0f, 0.0f);
        this.handleNetworkIDChange(this, Settings.spellCompatSettings.chargeSpellNetworkID);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData.get((EntityPlayer)caster).setVariable(CHARGE_TIME, (Object)((int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade))));
        WizardData.get((EntityPlayer)caster).setVariable(CHARGE_MODIFIERS, (Object)modifiers);
        if (world.field_72995_K) {
            world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, caster.field_70165_t, caster.field_70163_u + (double)(caster.field_70131_O / 2.0f), caster.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    private static int update(EntityPlayer player, Integer chargeTime) {
        if (chargeTime == null) {
            chargeTime = 0;
        }
        if (chargeTime > 0) {
            SpellModifiers modifiers;
            if (!player.field_70170_p.field_72995_K && ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.ring_charge) && player.field_70170_p.func_175623_d(player.func_180425_c())) {
                player.field_70170_p.func_175656_a(player.func_180425_c(), ASBlocks.lightning_block.func_176223_P());
                TileEntity tile = player.field_70170_p.func_175625_s(player.func_180425_c());
                if (tile instanceof TileEntityLightningBlock) {
                    ((TileEntityLightningBlock)tile).setLifetime(120);
                    ((TileEntityLightningBlock)tile).setCaster((EntityLivingBase)player);
                }
            }
            if ((modifiers = (SpellModifiers)WizardData.get((EntityPlayer)player).getVariable(CHARGE_MODIFIERS)) == null) {
                modifiers = new SpellModifiers();
            }
            Vec3d look = player.func_70040_Z();
            float speed = Spells.charge.getProperty(CHARGE_SPEED).floatValue() * modifiers.get(WizardryItems.range_upgrade);
            player.field_70159_w = look.field_72450_a * (double)speed;
            player.field_70179_y = look.field_72449_c * (double)speed;
            if (player.field_70170_p.field_72995_K) {
                for (int i = 0; i < 5; ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARK, (Entity)player).spawn(player.field_70170_p);
                }
            }
            List collided = player.field_70170_p.func_72872_a(EntityLivingBase.class, player.func_174813_aQ().func_186662_g(1.0));
            collided.remove(player);
            float damage = Spells.charge.getProperty("damage").floatValue() * modifiers.get("potency");
            float knockback = Spells.charge.getProperty(KNOCKBACK_STRENGTH).floatValue();
            collided.forEach(e -> e.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)player, (MagicDamage.DamageType)MagicDamage.DamageType.SHOCK), damage));
            collided.forEach(e -> e.func_70024_g(player.field_70159_w * (double)knockback, player.field_70181_x * (double)knockback + (double)0.3f, player.field_70179_y * (double)knockback));
            if (player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, player.field_70165_t + player.field_70159_w, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v + player.field_70179_y, 0.0, 0.0, 0.0, new int[0]);
            }
            if (collided.isEmpty()) {
                Integer n = chargeTime;
                Integer n2 = chargeTime = Integer.valueOf(chargeTime - 1);
            } else {
                EntityUtils.playSoundAtPlayer((EntityPlayer)player, (SoundEvent)SoundEvents.field_187543_bD, (float)1.0f, (float)1.0f);
                chargeTime = 0;
            }
        }
        return chargeTime;
    }
}

