/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class Cauterize
extends Spell {
    public static String BURN_DURATION = "burn_duration";
    public static String REGENERATION_DURATION = "regeneration_duration";

    public Cauterize() {
        super("ancientspellcraft", "cauterize", SpellActions.IMBUE, false);
        this.addProperties(new String[]{"health", "damage", REGENERATION_DURATION, BURN_DURATION});
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        world.func_184133_a(null, caster.func_180425_c(), SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
        int burn = this.getProperty(BURN_DURATION).intValue() / 20;
        boolean fireImmune = MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FIRE, (Entity)caster) || caster.func_70644_a(MobEffects.field_76426_n);
        float efficiencyRatio = 1.0f;
        for (ItemStack slot : caster.func_184193_aE()) {
            int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77329_d, (ItemStack)slot);
            efficiencyRatio = (float)Math.max(0.1, (double)efficiencyRatio - (double)level * 0.1);
        }
        caster.func_70015_d(burn);
        if (!fireImmune) {
            if (!world.field_72995_K) {
                EntityUtils.attackEntityWithoutKnockback((Entity)caster, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FIRE), (float)(this.getProperty("damage").floatValue() * modifiers.get("potency")));
                caster.func_70690_d(new PotionEffect(MobEffects.field_76428_l, (int)(efficiencyRatio * (float)this.getProperty(REGENERATION_DURATION).intValue()), 0));
                caster.func_70691_i(efficiencyRatio * (float)this.getProperty("health").intValue() * modifiers.get("potency"));
            } else {
                caster.func_70691_i((float)(0.3 * (double)((float)this.getProperty("health").intValue() * modifiers.get("potency"))));
            }
        }
        return true;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return false;
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

