/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.registry;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.loot.ArtefactCondition;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ASLoot {
    private static LootTable UNCOMMON_ARTEFACTS;
    private static LootTable RARE_ARTEFACTS;
    private static LootTable EPIC_ARTEFACTS;
    private static LootTable ANCIENTSPELLCRAFT_BOOKS_AND_SCROLLS;
    private static LootTable LIBRARY_RUINS_BOOKSHELF;
    private static LootTable OBELISK;
    private static LootTable SHRINE;
    private static LootTable SHRINE_EXTRAS;
    private static LootTable WIZARD_TOWER;
    private static LootTable ANCIENT_VAULT;
    private static LootTable WAND_UPGRADES;
    private static LootTable RARE_SCROLLS;

    private ASLoot() {
    }

    public static void preInit() {
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ArtefactCondition.Serializer());
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "chests/dungeon_additions"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "chests/ancient_vault"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "subsets/uncommon_artefacts"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "subsets/rare_artefacts"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "subsets/epic_artefacts"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "subsets/ritual_books"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "subsets/wand_upgrades"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "subsets/rare_scrolls"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "subsets/ancientspellcraft_books_and_scrolls"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "inject/as_library_ruins_bookshelf"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "inject/as_obelisk"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "inject/as_shrine"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "inject/as_wizard_tower"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "inject/shrine_extras"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "entities/void_creeper"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "entities/evil_battlemage"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "entities/stone_guardian"));
    }

    @SubscribeEvent
    public static void onLootTableLoadEvent(LootTableLoadEvent event) {
        LootPool sourcePool;
        LootPool targetPool;
        if (Arrays.asList(AncientSpellcraft.settings.lootInjectionLocations).contains(event.getName())) {
            event.getTable().addPool(ASLoot.getAdditive("ancientspellcraft:chests/dungeon_additions", "ancientspellcraft_ancientspellcraft_dungeon_additions"));
        }
        if (event.getName().toString().equals("ancientspellcraft:subsets/uncommon_artefacts")) {
            UNCOMMON_ARTEFACTS = event.getTable();
        } else if (event.getName().toString().equals("ancientspellcraft:subsets/rare_artefacts")) {
            RARE_ARTEFACTS = event.getTable();
        } else if (event.getName().toString().equals("ancientspellcraft:subsets/epic_artefacts")) {
            EPIC_ARTEFACTS = event.getTable();
        } else if (event.getName().toString().equals("ancientspellcraft:inject/as_library_ruins_bookshelf")) {
            LIBRARY_RUINS_BOOKSHELF = event.getTable();
        } else if (event.getName().toString().equals("ancientspellcraft:inject/as_obelisk")) {
            OBELISK = event.getTable();
        } else if (event.getName().toString().equals("ancientspellcraft:inject/as_wizard_tower")) {
            WIZARD_TOWER = event.getTable();
        } else if (event.getName().toString().equals("ancientspellcraft:inject/as_shrine")) {
            SHRINE = event.getTable();
        } else if (event.getName().toString().equals("ancientspellcraft:inject/shrine_extras")) {
            SHRINE_EXTRAS = event.getTable();
        }
        if (event.getName().toString().equals("ebwizardry:chests/library_ruins_bookshelf") && LIBRARY_RUINS_BOOKSHELF != null) {
            targetPool = event.getTable().getPool("wizardry");
            sourcePool = LIBRARY_RUINS_BOOKSHELF.getPool("ancientspellcraft");
            ASLoot.injectEntries(sourcePool, targetPool);
        } else if (event.getName().toString().equals("ebwizardry:chests/obelisk") && OBELISK != null) {
            targetPool = event.getTable().getPool("high_value");
            sourcePool = OBELISK.getPool("ancientspellcraft");
            ASLoot.injectEntries(sourcePool, targetPool);
        } else if (event.getName().toString().equals("ebwizardry:chests/shrine") && SHRINE_EXTRAS != null) {
            event.getTable().addPool(SHRINE_EXTRAS.getPool("shrine_extras"));
        } else if (event.getName().toString().equals("ebwizardry:chests/wizard_tower") && WIZARD_TOWER != null) {
            targetPool = event.getTable().getPool("wizardry");
            sourcePool = WIZARD_TOWER.getPool("ancientspellcraft");
            ASLoot.injectEntries(sourcePool, targetPool);
        } else if (event.getName().toString().equals("ebwizardry:subsets/wand_upgrades") && WAND_UPGRADES != null) {
            targetPool = event.getTable().getPool("upgrades");
            sourcePool = WAND_UPGRADES.getPool("ancientspellcraft");
            ASLoot.injectEntries(sourcePool, targetPool);
        }
        if (event.getName().toString().equals("ebwizardry:chests/shrine") && SHRINE != null) {
            targetPool = event.getTable().getPool("high_value");
            sourcePool = SHRINE.getPool("ancientspellcraft");
            ASLoot.injectEntries(sourcePool, targetPool);
        }
        if (Arrays.asList(AncientSpellcraft.settings.artefactInjectionLocations).contains(event.getName())) {
            if (event.getName().toString().equals("ebwizardry:subsets/uncommon_artefacts") && UNCOMMON_ARTEFACTS != null) {
                targetPool = event.getTable().getPool("uncommon_artefacts");
                sourcePool = UNCOMMON_ARTEFACTS.getPool("main");
                ASLoot.injectEntries(sourcePool, targetPool);
            }
            if (event.getName().toString().equals("ebwizardry:subsets/rare_artefacts") && RARE_ARTEFACTS != null) {
                targetPool = event.getTable().getPool("rare_artefacts");
                sourcePool = RARE_ARTEFACTS.getPool("main");
                ASLoot.injectEntries(sourcePool, targetPool);
            }
            if (event.getName().toString().equals("ebwizardry:subsets/epic_artefacts") && EPIC_ARTEFACTS != null) {
                targetPool = event.getTable().getPool("epic_artefacts");
                sourcePool = EPIC_ARTEFACTS.getPool("main");
                ASLoot.injectEntries(sourcePool, targetPool);
            }
        }
    }

    private static void injectEntries(LootPool sourcePool, LootPool targetPool) {
        if (sourcePool != null && targetPool != null) {
            List lootEntries = (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)sourcePool, (String)"field_186453_a");
            for (LootEntry entry : lootEntries) {
                targetPool.addEntry(entry);
            }
        } else {
            AncientSpellcraft.logger.warn("Attempted to inject to null pool source or target.");
        }
    }

    private static LootPool getAdditive(String entryName, String poolName) {
        return new LootPool(new LootEntry[]{ASLoot.getAdditiveEntry(entryName, 1)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "ancientspellcraft_" + poolName);
    }

    private static LootEntryTable getAdditiveEntry(String name, int weight) {
        return new LootEntryTable(new ResourceLocation(name), weight, 0, new LootCondition[0], "ancientspellcraft_additive_entry");
    }
}

