/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.registry;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.entity.EntityMageLight;
import com.windanesz.ancientspellcraft.entity.EntityWisp;
import com.windanesz.ancientspellcraft.entity.construct.EntityAntiMagicField;
import com.windanesz.ancientspellcraft.entity.construct.EntityArcaneBarrier;
import com.windanesz.ancientspellcraft.entity.construct.EntityBarterConstruct;
import com.windanesz.ancientspellcraft.entity.construct.EntityBuilder;
import com.windanesz.ancientspellcraft.entity.construct.EntityHealingSigil;
import com.windanesz.ancientspellcraft.entity.construct.EntityMoltenBoulder;
import com.windanesz.ancientspellcraft.entity.construct.EntitySentinel;
import com.windanesz.ancientspellcraft.entity.construct.EntitySilencingSigil;
import com.windanesz.ancientspellcraft.entity.construct.EntitySpellTicker;
import com.windanesz.ancientspellcraft.entity.construct.EntitySpiritWard;
import com.windanesz.ancientspellcraft.entity.construct.EntityTransportationPortal;
import com.windanesz.ancientspellcraft.entity.construct.EntityVenusFlyTrap;
import com.windanesz.ancientspellcraft.entity.living.EntityAnimatedItem;
import com.windanesz.ancientspellcraft.entity.living.EntityCreeperMinion;
import com.windanesz.ancientspellcraft.entity.living.EntityEvilClassWizard;
import com.windanesz.ancientspellcraft.entity.living.EntityFireAnt;
import com.windanesz.ancientspellcraft.entity.living.EntityOrdinarySpiderMinion;
import com.windanesz.ancientspellcraft.entity.living.EntityPigZombieMinion;
import com.windanesz.ancientspellcraft.entity.living.EntitySkeletonHorseMinion;
import com.windanesz.ancientspellcraft.entity.living.EntitySkeletonMageMinion;
import com.windanesz.ancientspellcraft.entity.living.EntitySpellCaster;
import com.windanesz.ancientspellcraft.entity.living.EntitySpiritBear;
import com.windanesz.ancientspellcraft.entity.living.EntityStoneGuardian;
import com.windanesz.ancientspellcraft.entity.living.EntityVoidCreeper;
import com.windanesz.ancientspellcraft.entity.living.EntityVolcano;
import com.windanesz.ancientspellcraft.entity.living.EntityWizardMerchant;
import com.windanesz.ancientspellcraft.entity.living.EntityWolfMinion;
import com.windanesz.ancientspellcraft.entity.projectile.EntityAOEProjectile;
import com.windanesz.ancientspellcraft.entity.projectile.EntityContingencyProjectile;
import com.windanesz.ancientspellcraft.entity.projectile.EntityDevoritiumArrow;
import com.windanesz.ancientspellcraft.entity.projectile.EntityDevoritiumBomb;
import com.windanesz.ancientspellcraft.entity.projectile.EntityDispelGreaterMagic;
import com.windanesz.ancientspellcraft.entity.projectile.EntityDispelMagic;
import com.windanesz.ancientspellcraft.entity.projectile.EntityFlint;
import com.windanesz.ancientspellcraft.entity.projectile.EntityHeart;
import com.windanesz.ancientspellcraft.entity.projectile.EntityManaVortex;
import com.windanesz.ancientspellcraft.entity.projectile.EntityMasterBolt;
import com.windanesz.ancientspellcraft.entity.projectile.EntityMetamagicProjectile;
import com.windanesz.ancientspellcraft.entity.projectile.EntitySafeIceShard;
import com.windanesz.ancientspellcraft.entity.projectile.EntityStoneGuardianShard;
import electroblob.wizardry.Wizardry;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ASEntities {
    private static final int VOID_CREEPER_SPAWN_RATE = 30;
    private static int id = 0;

    private ASEntities() {
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityWisp.class, "will_o_wisp", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityMageLight.class, "mage_light_entity", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityHeart.class, "healing_heart", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityDispelMagic.class, "dispel_magic", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityDispelGreaterMagic.class, "dispel_greater_magic", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityManaVortex.class, "wizard_blast").tracker(160, 3, false).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityDevoritiumBomb.class, "devoritium_bomb", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityDevoritiumArrow.class, "devoritium_arrow", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityFlint.class, "flint_projectile", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntitySafeIceShard.class, "safe_ice_shard", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityVoidCreeper.class, "void_creeper", TrackingType.LIVING).egg(2562875, 8336891).spawn(EnumCreatureType.MONSTER, Settings.generalSettings.void_creeper_spawn_rate, 1, 1, (Iterable)ForgeRegistries.BIOMES.getValuesCollection().stream().filter(b -> !Arrays.asList(AncientSpellcraft.settings.voidCreeperBiomeBlacklist).contains(b.getRegistryName())).collect(Collectors.toSet())).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntitySkeletonMageMinion.class, "skeleton_mage_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityWolfMinion.class, "wolf_minion", TrackingType.LIVING).egg(13397831, 0x676767).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntitySpiritBear.class, "spirit_bear", TrackingType.LIVING).egg(12370664, 0xFFFFFF).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityVenusFlyTrap.class, "venus_fly_trap", TrackingType.LIVING).egg(12370664, 0xFFFFFF).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityFireAnt.class, "fire_ant", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntitySkeletonHorseMinion.class, "skeleton_horse_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityOrdinarySpiderMinion.class, "ordinary_spider_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityTransportationPortal.class, "transportation_portal", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntitySpiritWard.class, "spirit_ward", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntitySilencingSigil.class, "silencing_sigil", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityHealingSigil.class, "healing_sigil", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityVolcano.class, "entity_volcano", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityAntiMagicField.class, "anti_magic_field", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityMetamagicProjectile.class, "contingency_projectile", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityContingencyProjectile.class, "metamagic_projectile", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntitySentinel.class, "sentinel", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntitySpellCaster.class, "spellcaster_entity", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntitySpellTicker.class, "mushroom_forest", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityBuilder.class, "builder_entity", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityAnimatedItem.class, "animated_item", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityMasterBolt.class, "master_bolt", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityMoltenBoulder.class, "molten_boulder").tracker(160, 1, true).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityCreeperMinion.class, "creeper_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityPigZombieMinion.class, "pig_zombie_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityStoneGuardian.class, "stone_guardian", TrackingType.LIVING).egg(8815756, 10551526).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityStoneGuardianShard.class, "stone_guardian_shard", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityWizardMerchant.class, "wizardmerchant", "ancientspellcraft", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityEvilClassWizard.class, "evil_class_wizard", "ancientspellcraft", TrackingType.LIVING).egg(2688004, 15635218).spawn(EnumCreatureType.MONSTER, Settings.generalSettings.evil_class_wizard_spawn_rate, 1, 1, (Iterable)ForgeRegistries.BIOMES.getValuesCollection().stream().filter(b -> !Arrays.asList(Wizardry.settings.mobSpawnBiomeBlacklist).contains(b.getRegistryName())).collect(Collectors.toSet())).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityBarterConstruct.class, "barter_entity", "ancientspellcraft", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityArcaneBarrier.class, "arcane_barrier", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)ASEntities.createEntry(EntityAOEProjectile.class, "aoe_projectile_entity", TrackingType.PROJECTILE).build());
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name, TrackingType tracking) {
        return ASEntities.createEntry(entityClass, name).tracker(tracking.range, tracking.interval, tracking.trackVelocity);
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name) {
        ResourceLocation registryName = new ResourceLocation("ancientspellcraft", name);
        return EntityEntryBuilder.create().entity(entityClass).id(registryName, id++).name(registryName.toString());
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name, String modid, TrackingType tracking) {
        return ASEntities.createEntry(entityClass, name, modid).tracker(tracking.range, tracking.interval, tracking.trackVelocity);
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name, String modid) {
        ResourceLocation registryName = new ResourceLocation(modid, name);
        return EntityEntryBuilder.create().entity(entityClass).id(registryName, id++).name(registryName.toString());
    }

    static enum TrackingType {
        LIVING(80, 3, true),
        PROJECTILE(64, 1, true),
        CONSTRUCT(160, 10, false);

        int range;
        int interval;
        boolean trackVelocity;

        private TrackingType(int range, int interval, boolean trackVelocity) {
            this.range = range;
            this.interval = interval;
            this.trackVelocity = trackVelocity;
        }
    }
}

