/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class WeightedRandom<T> {
    private List<Entry> entries = new ArrayList<Entry>();
    private double accumulatedWeight;
    private Random rand = new Random();

    public WeightedRandom(Random rand) {
        this.rand = rand;
    }

    public void addEntry(T object, double weight) {
        this.accumulatedWeight += weight;
        Entry e = new Entry();
        e.object = object;
        e.accumulatedWeight = this.accumulatedWeight;
        this.entries.add(e);
    }

    public T getRandom() {
        double r = this.rand.nextDouble() * this.accumulatedWeight;
        for (Entry entry : this.entries) {
            if (!(entry.accumulatedWeight >= r)) continue;
            return entry.object;
        }
        return null;
    }

    private class Entry {
        double accumulatedWeight;
        T object;

        private Entry() {
        }
    }
}

