/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.IWizardClassWeapon;
import com.windanesz.ancientspellcraft.item.ItemWandUpgradeAS;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemSoulboundWandUpgrade
extends ItemWandUpgradeAS {
    private static final IStoredVariable<NBTTagCompound> STORED_WANDS = IStoredVariable.StoredVariable.ofNBT((String)"soulbound_wands", (Persistence)Persistence.ALWAYS);

    public static void restoreStoredWandsToInventory(EntityPlayer player) {
        WizardData data;
        HashMap<Integer, ItemStack> wandMap = ItemSoulboundWandUpgrade.getStoredWands(player);
        if (!wandMap.isEmpty()) {
            for (ItemStack wand : wandMap.values()) {
                if (player.func_191521_c(wand)) continue;
                player.func_71019_a(wand, false);
            }
        }
        if ((data = WizardData.get((EntityPlayer)player)) != null) {
            data.setVariable(STORED_WANDS, (Object)new NBTTagCompound());
        }
    }

    private static HashMap<Integer, ItemStack> getStoredWands(EntityPlayer player) {
        NBTTagCompound compound;
        HashMap<Integer, ItemStack> wandMap = new HashMap<Integer, ItemStack>();
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null && (compound = (NBTTagCompound)data.getVariable(STORED_WANDS)) != null) {
            for (String key : compound.func_150296_c()) {
                if (!ItemSoulboundWandUpgrade.isNumeric(key) || !compound.func_74764_b(key)) continue;
                ItemStack currWand = new ItemStack(compound.func_74775_l(key));
                wandMap.put(Integer.valueOf(key), currWand.func_77946_l());
            }
        }
        return wandMap;
    }

    public static void storeSoulboundWands(EntityPlayer player) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null) {
            boolean hasUpgrade;
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (!(stack.func_77973_b() instanceof ItemWand) && !(stack.func_77973_b() instanceof IWizardClassWeapon) || !(hasUpgrade = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)ASItems.soulbound_upgrade) != 0)) continue;
                itemList.add(stack.func_77946_l());
                stack.func_190920_e(0);
            }
            for (ItemStack stack : player.field_71071_by.field_184439_c) {
                if (!(stack.func_77973_b() instanceof ItemWand) && !(stack.func_77973_b() instanceof IWizardClassWeapon) || !(hasUpgrade = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)ASItems.soulbound_upgrade) != 0)) continue;
                itemList.add(stack.func_77946_l());
                stack.func_190920_e(0);
            }
        }
        if (!itemList.isEmpty()) {
            NBTTagCompound newStoredWandData = new NBTTagCompound();
            for (int i = 0; i < itemList.size(); ++i) {
                ItemStack currentWand = (ItemStack)itemList.get(i);
                NBTTagCompound currentWandCompound = new NBTTagCompound();
                currentWand.func_77955_b(currentWandCompound);
                newStoredWandData.func_74782_a(String.valueOf(i), (NBTBase)currentWandCompound);
            }
            data.setVariable(STORED_WANDS, (Object)newStoredWandData);
            data.sync();
        }
    }

    private static boolean isNumeric(String string) {
        return string.matches("\\d+");
    }
}

