/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.google.common.collect.Lists;
import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.data.SpellComponentList;
import com.windanesz.ancientspellcraft.registry.ASPotions;
import com.windanesz.ancientspellcraft.registry.ASSounds;
import com.windanesz.ancientspellcraft.registry.ASTabs;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRelic
extends Item {
    private static final String SPELL = "spell";
    private static final String INCANTATION = "incantation";
    private static final String ENCHANTMENT = "enchantment";
    private static final String POWER = "power";
    private final EnumRarity rarity;
    private static List<Potion> ALL_POTIONS = new ArrayList<Potion>();
    private static List<Potion> ALL_POWERS = new ArrayList<Potion>();

    public static void initEffects() {
        ALL_POTIONS.add(MobEffects.field_76424_c);
        ALL_POTIONS.add(MobEffects.field_76421_d);
        ALL_POTIONS.add(MobEffects.field_76422_e);
        ALL_POTIONS.add(MobEffects.field_76419_f);
        ALL_POTIONS.add(MobEffects.field_76420_g);
        ALL_POTIONS.add(MobEffects.field_76430_j);
        ALL_POTIONS.add(MobEffects.field_76431_k);
        ALL_POTIONS.add(MobEffects.field_76428_l);
        ALL_POTIONS.add(MobEffects.field_76429_m);
        ALL_POTIONS.add(MobEffects.field_76426_n);
        ALL_POTIONS.add(MobEffects.field_76427_o);
        ALL_POTIONS.add(MobEffects.field_76441_p);
        ALL_POTIONS.add(MobEffects.field_76440_q);
        ALL_POTIONS.add(MobEffects.field_76439_r);
        ALL_POTIONS.add(MobEffects.field_76438_s);
        ALL_POTIONS.add(MobEffects.field_76437_t);
        ALL_POTIONS.add(MobEffects.field_76436_u);
        ALL_POTIONS.add(MobEffects.field_82731_v);
        ALL_POTIONS.add(MobEffects.field_180152_w);
        ALL_POTIONS.add(MobEffects.field_76444_x);
        ALL_POTIONS.add(MobEffects.field_188423_x);
        ALL_POTIONS.add(MobEffects.field_188424_y);
        ALL_POTIONS.add(ASPotions.candlelight);
        ALL_POTIONS.add(ASPotions.curse_ward);
        ALL_POTIONS.add(ASPotions.magelight);
        ALL_POTIONS.add(ASPotions.arcane_aegis);
        ALL_POTIONS.add(ASPotions.bubble_head);
        ALL_POTIONS.add(ASPotions.bulwark);
        ALL_POTIONS.add(ASPotions.water_walking);
        ALL_POTIONS.add(ASPotions.fortified_archery);
        ALL_POTIONS.add(ASPotions.lava_vision);
        ALL_POTIONS.add(ASPotions.feather_fall);
        ALL_POTIONS.add(ASPotions.projectile_ward);
        ALL_POTIONS.add(ASPotions.aquatic_agility);
        ALL_POTIONS.add(ASPotions.magma_strider);
        ALL_POTIONS.add(WizardryPotions.muffle);
        ALL_POTIONS.add(WizardryPotions.transience);
        ALL_POTIONS.add(WizardryPotions.sixth_sense);
        ALL_POTIONS.add(WizardryPotions.arcane_jammer);
        ALL_POTIONS.add(WizardryPotions.fireskin);
        ALL_POTIONS.add(WizardryPotions.frost);
        ALL_POTIONS.add(WizardryPotions.ice_shroud);
        ALL_POTIONS.add(WizardryPotions.containment);
        ALL_POTIONS.add(WizardryPotions.curse_of_enfeeblement);
        ALL_POTIONS.add(WizardryPotions.curse_of_undeath);
        ALL_POTIONS.add(WizardryPotions.ward);
        ALL_POTIONS.add(WizardryPotions.static_aura);
        ALL_POTIONS.add(WizardryPotions.frost_step);
        ALL_POTIONS.add(WizardryPotions.font_of_mana);
        ALL_POWERS.add(WizardryPotions.empowerment);
        ALL_POWERS.add(ASPotions.spell_blast);
        ALL_POWERS.add(ASPotions.spell_range);
        ALL_POWERS.add(ASPotions.spell_duration);
        ALL_POWERS.add(ASPotions.spell_cooldown);
        ALL_POWERS.add(ASPotions.spell_siphon);
        ALL_POWERS.add(ASPotions.mana_regeneration);
    }

    public ItemRelic(String name, EnumRarity rarity) {
        this.field_77777_bU = 1;
        this.func_77637_a(ASTabs.ANCIENTSPELLCRAFT);
        this.rarity = rarity;
        this.func_185043_a(new ResourceLocation("activating"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                return entityIn.func_184607_cu() != stack || !(entityIn.func_184607_cu().func_77973_b() instanceof ItemRelic) ? 0.0f : (entityIn.func_184605_cv() > 0 ? 1.0f : 0.0f);
            }
        });
    }

    public int func_77626_a(ItemStack stack) {
        return 120;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return SpellActions.IMBUE;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        RelicType relicType = ItemRelic.getRelicType(itemStack);
        if (relicType == RelicType.INCANTATION || relicType == RelicType.POWER || relicType == RelicType.ENCHANTMENT) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
    }

    public void onUsingTick(ItemStack itemStack, EntityLivingBase player, int usingTicks) {
        RelicType relicType;
        if (!(usingTicks % 25 != 0 && usingTicks != 0 || (relicType = ItemRelic.getRelicType(itemStack)) != RelicType.INCANTATION && relicType != RelicType.ENCHANTMENT && relicType != RelicType.POWER)) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ASSounds.RELIC_USE_LOOP, SoundCategory.NEUTRAL, 1.1f, 1.0f);
        }
        if (player.field_70170_p.field_72995_K && usingTicks % 10 == 0 && ((relicType = ItemRelic.getRelicType(itemStack)) == RelicType.INCANTATION || relicType == RelicType.ENCHANTMENT || relicType == RelicType.POWER)) {
            int color;
            int n = relicType == RelicType.INCANTATION ? ItemRelic.getIncantationFromRelic(itemStack).func_76401_j() : (color = relicType == RelicType.ENCHANTMENT ? 6034529 : 1099713);
            if (relicType == RelicType.ENCHANTMENT && player.field_70170_p.field_72995_K) {
                World world = player.field_70170_p;
                for (int i = 0; i < 10; ++i) {
                    double dx = (world.field_73012_v.nextDouble() * 2.0 - 1.0) * 3.0;
                    double dy = (world.field_73012_v.nextDouble() * 2.0 - 1.0) * 3.0;
                    double dz = (world.field_73012_v.nextDouble() * 2.0 - 1.0) * 3.0;
                    world.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, player.field_70165_t, player.field_70163_u + 1.5, player.field_70161_v, dx, dy, dz, new int[0]);
                }
            }
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).entity((Entity)player).pos(0.0, 0.1, 0.0).face(EnumFacing.UP).clr(color).collide(false).scale(4.3f).time(30).spawn(player.field_70170_p);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).entity((Entity)player).pos(0.0, 0.1, 0.0).face(EnumFacing.UP).clr(0x303030).collide(false).scale(2.3f).time(40).spawn(player.field_70170_p);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).entity((Entity)player).vel(0.0, 0.05, 0.0).scale(0.7f).time(48 + player.field_70170_p.field_73012_v.nextInt(12)).spin(1.0, (double)(120 - usingTicks) * 0.001).clr(color).spawn(player.field_70170_p);
        }
    }

    public ItemStack func_77654_b(ItemStack itemStack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            ((EntityPlayer)entityLiving).func_184811_cZ().func_185145_a((Item)this, 60);
            RelicType relicType = ItemRelic.getRelicType(itemStack);
            if (relicType == RelicType.INCANTATION) {
                Potion potion = ItemRelic.getIncantationFromRelic(itemStack);
                int duration = itemStack.func_77978_p().func_74762_e("duration");
                entityLiving.func_70690_d(new PotionEffect(potion, duration, 0));
                worldIn.func_184148_a(null, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, ASSounds.RELIC_ACTIVATE_2, SoundCategory.NEUTRAL, 0.9f, 1.0f);
                return ItemStack.field_190927_a;
            }
            if (relicType == RelicType.POWER) {
                Potion potion = ItemRelic.getPowerFromRelic(itemStack);
                int duration = itemStack.func_77978_p().func_74762_e("duration");
                entityLiving.func_70690_d(new PotionEffect(potion, duration, 0));
                worldIn.func_184148_a(null, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, ASSounds.RELIC_ACTIVATE_2, SoundCategory.NEUTRAL, 0.9f, 1.0f);
                return ItemStack.field_190927_a;
            }
            if (relicType == RelicType.ENCHANTMENT && !entityLiving.func_184592_cb().func_190926_b()) {
                ItemStack offHandStack = entityLiving.func_184592_cb();
                if (!offHandStack.func_77973_b().func_77616_k(offHandStack)) {
                    return itemStack;
                }
                Map<Enchantment, Integer> stoneEnchantments = ItemRelic.getStoredEnchantments(itemStack);
                ArrayList<EnchantmentData> stoneData = new ArrayList<EnchantmentData>();
                ArrayList<EnchantmentData> tempStoneData = new ArrayList<EnchantmentData>();
                for (Map.Entry<Enchantment, Integer> enchantment : stoneEnchantments.entrySet()) {
                    EnchantmentData data = new EnchantmentData(enchantment.getKey(), enchantment.getValue().intValue());
                    stoneData.add(data);
                }
                boolean enchantedSomething = false;
                boolean isItemEnchanted = offHandStack.func_77948_v();
                if (isItemEnchanted) {
                    Map currentEnchantments = EnchantmentHelper.func_82781_a((ItemStack)offHandStack);
                    ArrayList<EnchantmentData> currentData = new ArrayList<EnchantmentData>();
                    for (Map.Entry enchantment : currentEnchantments.entrySet()) {
                        EnchantmentData data = new EnchantmentData((Enchantment)enchantment.getKey(), ((Integer)enchantment.getValue()).intValue());
                        currentData.add(data);
                    }
                    for (EnchantmentData data : currentData) {
                        EnchantmentHelper.func_185282_a(stoneData, (EnchantmentData)data);
                    }
                }
                tempStoneData.addAll(0, stoneData);
                for (EnchantmentData data : tempStoneData) {
                    stoneData.remove(data);
                    EnchantmentHelper.func_185282_a(stoneData, (EnchantmentData)data);
                    stoneData.add(data);
                }
                stoneEnchantments = new HashMap<Enchantment, Integer>();
                for (EnchantmentData data : stoneData) {
                    if (!offHandStack.func_77973_b().canApplyAtEnchantingTable(offHandStack, data.field_76302_b)) continue;
                    stoneEnchantments.put(data.field_76302_b, data.field_76303_c);
                    offHandStack.func_77966_a(data.field_76302_b, data.field_76303_c);
                    enchantedSomething = true;
                }
                if (enchantedSomething) {
                    worldIn.func_184148_a(null, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, ASSounds.RELIC_ACTIVATE, SoundCategory.NEUTRAL, 0.9f, 1.0f);
                    return ItemStack.field_190927_a;
                }
                return itemStack;
            }
        }
        return itemStack;
    }

    public static void removeAllEnchantments(ItemStack stack) {
        if (stack.func_77948_v() && stack.func_77948_v()) {
            NBTTagCompound nbt = stack.func_77978_p();
            nbt.func_82580_o("ench");
            stack.func_77982_d(nbt);
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity;
    }

    private static Tier getTier(ItemStack stack) {
        switch (stack.func_77973_b().func_77613_e(stack)) {
            case COMMON: {
                return Tier.NOVICE;
            }
            case UNCOMMON: {
                return Tier.APPRENTICE;
            }
            case RARE: {
                return Tier.ADVANCED;
            }
            case EPIC: {
                return Tier.MASTER;
            }
        }
        return Tier.NOVICE;
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return this.rarity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound nbt;
        boolean researched = ItemRelic.isResearched(stack);
        if (advanced.func_194127_a() && !researched) {
            tooltip.add(Wizardry.proxy.translate("tooltip.ancientspellcraft:ancient_relic_tooltip", new Object[0]));
            tooltip.add(Wizardry.proxy.translate("tooltip.ancientspellcraft:ancient_relic_research", new Object[0]));
        }
        if (researched && (nbt = stack.func_77978_p()).func_74764_b("relicType")) {
            Map<Enchantment, Integer> list;
            RelicType type = RelicType.fromName(nbt.func_74779_i("relicType").toLowerCase());
            tooltip.add(AncientSpellcraft.proxy.translate(type.getUnlocalisedName(), type.colour.func_150217_b(Boolean.valueOf(true)), new Object[0]));
            if (type == RelicType.SPELL && nbt.func_74764_b(SPELL)) {
                Spell spell = ItemRelic.getSpell(stack);
                tooltip.add(" " + spell.getDisplayName());
                tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"relic_type.spell.required_components", (Object[])new Object[0]));
                for (ItemStack stack1 : ItemRelic.getSpellComponentItems(stack)) {
                    tooltip.add(" - " + stack1.func_82833_r());
                }
                tooltip.add(I18n.func_135052_a((String)"relic_type.spell.instruction", (Object[])new Object[0]));
            } else if (type == RelicType.INCANTATION && nbt.func_74764_b(INCANTATION)) {
                String potionName = nbt.func_74779_i(INCANTATION);
                String displayName = I18n.func_135052_a((String)Potion.func_180142_b((String)potionName).func_76393_a(), (Object[])new Object[0]);
                int duration = nbt.func_74762_e("duration");
                tooltip.add(" " + displayName + " (" + StringUtils.func_76337_a((int)duration) + ")");
                tooltip.add(I18n.func_135052_a((String)"relic_type.incantation.instruction", (Object[])new Object[0]));
            } else if (type == RelicType.POWER) {
                if (stack.func_77978_p().func_74764_b(POWER)) {
                    String potionName = nbt.func_74779_i(POWER);
                    String displayName = I18n.func_135052_a((String)Potion.func_180142_b((String)potionName).func_76393_a(), (Object[])new Object[0]);
                    int duration = nbt.func_74762_e("duration");
                    tooltip.add(" " + displayName + " (" + StringUtils.func_76337_a((int)duration) + ")");
                    tooltip.add(I18n.func_135052_a((String)"relic_type.power.instruction", (Object[])new Object[0]));
                }
            } else if (!(type != RelicType.ENCHANTMENT || (list = ItemRelic.getStoredEnchantments(stack)) == null && list.isEmpty())) {
                for (Map.Entry<Enchantment, Integer> entry : ItemRelic.getStoredEnchantments(stack).entrySet()) {
                    tooltip.add(" " + entry.getKey().func_77316_c(entry.getValue().intValue()));
                }
                tooltip.add(I18n.func_135052_a((String)"relic_type.enchantment.instruction", (Object[])new Object[0]));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.rarity == EnumRarity.EPIC;
    }

    public boolean hasRelicType(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("getRelicType");
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    private static Map<Enchantment, Integer> getStoredEnchantments(ItemStack stack) {
        HashMap<Enchantment, Integer> list = new HashMap<Enchantment, Integer>();
        if (ItemRelic.isResearched(stack)) {
            NBTTagList taglist = stack.func_77978_p().func_150295_c("StoredEnchantments", 10);
            for (int i = 0; i < taglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = taglist.func_150305_b(i);
                Enchantment enchantment = Enchantment.func_185262_c((int)nbttagcompound.func_74765_d("id"));
                short level = nbttagcompound.func_74765_d("lvl");
                list.put(enchantment, Integer.valueOf(level));
            }
            return list;
        }
        return null;
    }

    public static void setRandomContentType(ItemStack stack, EntityPlayer player, @Nullable RelicType type) {
        if (stack.func_77978_p() != null && ItemRelic.isResearched(stack)) {
            return;
        }
        if (type != null) {
            ItemRelic.setRelicType(stack, player, type);
            switch (type) {
                case SPELL: {
                    ItemRelic.setRandomSpell(player, stack);
                    break;
                }
                case INCANTATION: {
                    ItemRelic.setRandomIncantation(stack);
                    break;
                }
                case ENCHANTMENT: {
                    ItemRelic.setRandomEnchantment(stack, player);
                    break;
                }
                default: {
                    ItemRelic.setRandomPower(stack, player);
                }
            }
            ItemRelic.setRandomSpell(player, stack);
        } else {
            float f = player.field_70170_p.field_73012_v.nextFloat();
            if (f <= 0.4f) {
                ItemRelic.setRelicType(stack, player, RelicType.SPELL);
                ItemRelic.setRandomSpell(player, stack);
            } else if (0.4f < f && f <= 0.55f) {
                ItemRelic.setRelicType(stack, player, RelicType.INCANTATION);
                ItemRelic.setRandomIncantation(stack);
            } else if (0.55f < f && f <= 0.8f) {
                ItemRelic.setRelicType(stack, player, RelicType.ENCHANTMENT);
                ItemRelic.setRandomEnchantment(stack, player);
            } else if (0.8f < f && f <= 1.0f) {
                ItemRelic.setRelicType(stack, player, RelicType.POWER);
                ItemRelic.setRandomPower(stack, player);
            }
        }
        ItemRelic.setResearchedTag(stack);
    }

    public static void setResearchedTag(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("researched") && stack.func_77978_p().func_74767_n("researched")) {
            return;
        }
        NBTTagCompound nbt = ItemRelic.getTagCompound(stack);
        nbt.func_74757_a("researched", true);
        stack.func_77982_d(nbt);
    }

    public static boolean isResearched(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("researched")) {
            return stack.func_77978_p().func_74767_n("researched");
        }
        return false;
    }

    public static void setRelicType(ItemStack stack, EntityPlayer player, RelicType type) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("researched") && stack.func_77978_p().func_74767_n(type.unlocalisedName)) {
            return;
        }
        NBTTagCompound nbt = ItemRelic.getTagCompound(stack);
        nbt.func_74778_a("relicType", type.unlocalisedName);
        stack.func_77982_d(nbt);
    }

    private static NBTTagCompound getTagCompound(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p();
        }
        return new NBTTagCompound();
    }

    @Nullable
    public static List<ItemStack> getSpellComponentItems(ItemStack stack) {
        Spell spell;
        if (stack.func_77973_b() instanceof ItemRelic && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(SPELL) && (spell = Spell.get((String)stack.func_77978_p().func_74779_i(SPELL))) != null && SpellComponentList.containsSpell(spell)) {
            SpellComponentList componentList = SpellComponentList.lookupBySpell(spell);
            return Arrays.asList(componentList.getComponents());
        }
        return null;
    }

    @Nullable
    private static void setRandomSpell(EntityPlayer player, ItemStack stack) {
        WizardData data;
        if (player != null && (data = WizardData.get((EntityPlayer)player)) != null) {
            Tier tier = ItemRelic.getTier(stack);
            List<Spell> list = SpellComponentList.getSpellListByTier(tier);
            list.removeIf(spell -> !spell.isEnabled(new SpellProperties.Context[0]));
            if (list.isEmpty()) {
                return;
            }
            Spell spell2 = ASUtils.getRandomListItem(list);
            NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            nbt.func_74778_a(RelicType.SPELL.unlocalisedName, spell2.getUnlocalisedName());
            stack.func_77982_d(nbt);
        }
    }

    private static void setRandomIncantation(ItemStack stack) {
        Potion potion = ItemRelic.getRandomPotion();
        Tier tier = ItemRelic.getTier(stack);
        int duration = 0;
        switch (tier) {
            case NOVICE: {
                duration = 12000;
                break;
            }
            case APPRENTICE: {
                duration = 19200;
                break;
            }
            case ADVANCED: {
                duration = 36000;
                break;
            }
            case MASTER: {
                duration = 72000;
            }
        }
        NBTTagCompound nbt = ItemRelic.getTagCompound(stack);
        nbt.func_74778_a(RelicType.INCANTATION.unlocalisedName, potion.getRegistryName().toString());
        nbt.func_74768_a("duration", duration);
        stack.func_77982_d(nbt);
    }

    private static void setRandomEnchantment(ItemStack stack, EntityPlayer player) {
        ArrayList list = Lists.newArrayList();
        for (Enchantment enchantment1 : Enchantment.field_185264_b) {
            if (enchantment1.func_190936_d() || enchantment1.getRegistryName().toString().equals("ebwizardry:magic_sword") || enchantment1.getRegistryName().toString().equals("ebwizardry:flaming_weapon") || enchantment1.getRegistryName().toString().equals("ebwizardry:freezing_weapon") || enchantment1.getRegistryName().toString().equals("ebwizardry:shocking_weapon") || enchantment1.getRegistryName().toString().equals("ebwizardry:magic_bow")) continue;
            list.add(enchantment1);
        }
        int count = ItemRelic.getTier((ItemStack)stack).level + 1;
        for (int j = 0; j < count; ++j) {
            int i;
            Enchantment enchantment = (Enchantment)list.get(player.field_70170_p.field_73012_v.nextInt(list.size()));
            if (enchantment == null) continue;
            for (i = 0; !(i >= 5 || enchantment.field_77351_y != null && (enchantment.field_77351_y.func_77557_a((Item)Items.field_151161_ac) || enchantment.field_77351_y.func_77557_a((Item)Items.field_151163_ad) || enchantment.field_77351_y.func_77557_a((Item)Items.field_151173_ae) || enchantment.field_77351_y.func_77557_a((Item)Items.field_151175_af) || enchantment.field_77351_y.func_77557_a(Items.field_151048_u) || enchantment.field_77351_y.func_77557_a((Item)Items.field_151031_f) || enchantment.field_77351_y.func_77557_a(Items.field_151012_L) || enchantment.field_77351_y.func_77557_a(Items.field_151046_w))); ++i) {
                enchantment = (Enchantment)list.get(player.field_70170_p.field_73012_v.nextInt(list.size()));
            }
            i = MathHelper.func_76136_a((Random)player.field_70170_p.field_73012_v, (int)Math.min(enchantment.func_77319_d() + count / 2, enchantment.func_77325_b()), (int)enchantment.func_77325_b());
            ItemEnchantedBook.func_92115_a((ItemStack)stack, (EnchantmentData)new EnchantmentData(enchantment, i));
        }
    }

    private static void setRandomPower(ItemStack stack, EntityPlayer player) {
        Potion potion = ItemRelic.getRandomPower();
        Tier tier = ItemRelic.getTier(stack);
        int duration = 0;
        switch (tier) {
            case NOVICE: {
                duration = 6000;
                break;
            }
            case APPRENTICE: {
                duration = 12000;
                break;
            }
            case ADVANCED: {
                duration = 18000;
                break;
            }
            case MASTER: {
                duration = 24000;
            }
        }
        NBTTagCompound nbt = ItemRelic.getTagCompound(stack);
        nbt.func_74778_a(RelicType.POWER.unlocalisedName, potion.getRegistryName().toString());
        nbt.func_74768_a("duration", duration);
        stack.func_77982_d(nbt);
    }

    public static Element getRandomElement() {
        Element[] elements = Element.values();
        Random rand = new Random();
        int i = 0;
        while (i == 0) {
            i = rand.nextInt(elements.length);
        }
        return elements[i];
    }

    private static Potion getRandomPotion() {
        Random rand = new Random();
        return ALL_POTIONS.get(rand.nextInt(ALL_POTIONS.size()));
    }

    private static Potion getRandomPower() {
        Random rand = new Random();
        return ALL_POWERS.get(rand.nextInt(ALL_POWERS.size()));
    }

    @Nullable
    public static RelicType getRelicType(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemRelic && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("relicType")) {
            return RelicType.fromName(stack.func_77978_p().func_74779_i("relicType").toLowerCase());
        }
        return null;
    }

    @Nullable
    public static Spell getSpell(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemRelic && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(SPELL)) {
            return Spell.get((String)stack.func_77978_p().func_74779_i(SPELL));
        }
        return null;
    }

    public static Potion getIncantationFromRelic(ItemStack stack) {
        String potionName = stack.func_77978_p().func_74779_i(INCANTATION);
        return Potion.func_180142_b((String)potionName);
    }

    public static Potion getPowerFromRelic(ItemStack stack) {
        String potionName = stack.func_77978_p().func_74779_i(POWER);
        Potion potion = Potion.func_180142_b((String)potionName);
        if (potion == null) {
            AncientSpellcraft.logger.error("Couldn't find potion " + potionName + " in the registry, defaulting to minecraft:swiftness");
            potion = MobEffects.field_76424_c;
        }
        return potion;
    }

    public static int getColorFromPotion(ItemStack stack, int layer) {
        if (layer == 0 && ItemRelic.getRelicType(stack) == RelicType.INCANTATION) {
            return ItemRelic.getIncantationFromRelic(stack).func_76401_j();
        }
        if (layer == 1) {
            RelicType type = ItemRelic.getRelicType(stack);
            if (type == RelicType.INCANTATION) {
                return ItemRelic.getIncantationFromRelic(stack).func_76401_j();
            }
            if (type == RelicType.ENCHANTMENT) {
                return 6034529;
            }
            if (type == RelicType.POWER) {
                return 1099713;
            }
        }
        return 0;
    }

    public static enum RelicType implements IStringSerializable
    {
        SPELL(new Style().func_150238_a(TextFormatting.GOLD), "spell"),
        INCANTATION(new Style().func_150238_a(TextFormatting.BLUE), "incantation"),
        ENCHANTMENT(new Style().func_150238_a(TextFormatting.DARK_PURPLE), "enchantment"),
        POWER(new Style().func_150238_a(TextFormatting.DARK_AQUA), "power");

        private final Style colour;
        private final String unlocalisedName;

        private RelicType(Style colour, String name) {
            this.colour = colour;
            this.unlocalisedName = name;
        }

        public static RelicType fromName(String name) {
            for (RelicType relicType : RelicType.values()) {
                if (!relicType.unlocalisedName.equals(name)) continue;
                return relicType;
            }
            throw new IllegalArgumentException("No such relicType with unlocalised name: " + name);
        }

        public String getDisplayName() {
            return AncientSpellcraft.proxy.translate("relic_type." + this.func_176610_l(), new Object[0]);
        }

        public String func_176610_l() {
            return this.unlocalisedName;
        }

        public String getUnlocalisedName() {
            return "relic_type." + this.unlocalisedName;
        }

        public Style getColour() {
            return this.colour;
        }
    }
}

