/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.entity.ai.EntityAIWizardFollowPlayer;
import com.windanesz.ancientspellcraft.registry.ASTabs;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.MindControl;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemOverlordScepter
extends Item {
    private static final String CONTROLLED_ENTITY = "last_controlled_entity_uuid";

    public ItemOverlordScepter() {
        this.func_77637_a(ASTabs.ANCIENTSPELLCRAFT_GEAR);
        this.func_77656_e(0);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        World world = attacker.func_130014_f_();
        Entity lastEntity = ItemOverlordScepter.getLastControlledEntity(world, stack);
        if (lastEntity != target) {
            ItemOverlordScepter.controlEntity(target, attacker, world, stack);
            if (lastEntity instanceof EntityLivingBase) {
                ItemOverlordScepter.stopEntityControl((EntityLivingBase)lastEntity, world, attacker);
            }
        }
        return true;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public boolean isRepairable() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        Wizardry.proxy.addMultiLineDescription(tooltip, "item." + this.getRegistryName() + ".desc", new Object[0]);
    }

    @Nullable
    private static Entity getLastControlledEntity(World world, ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_186855_b(CONTROLLED_ENTITY)) {
            return EntityUtils.getEntityByUUID((World)world, (UUID)stack.func_77978_p().func_186857_a(CONTROLLED_ENTITY));
        }
        return null;
    }

    private static void controlEntity(EntityLivingBase target, EntityLivingBase caster, World world, ItemStack stack) {
        if (EntityUtils.isLiving((Entity)target)) {
            if (target instanceof EntityLiving && target.func_184222_aU() && Arrays.asList(Wizardry.settings.mindControlTargetsBlacklist).contains(EntityList.func_191306_a(target.getClass()))) {
                if (!world.field_72995_K && caster instanceof EntityPlayer) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), Spells.mind_control.getNameForTranslationFormatted()}), true);
                }
            } else if (target instanceof EntityLiving) {
                if (!world.field_72995_K && !MindControl.findMindControlTarget((EntityLiving)((EntityLiving)target), (EntityLivingBase)caster, (World)world)) {
                    ((EntityLiving)target).func_70624_b(null);
                }
                if (target instanceof EntitySheep && ((EntitySheep)target).func_175509_cj() == EnumDyeColor.BLUE && EntityUtils.canDamageBlocks((Entity)caster, (World)world)) {
                    if (!world.field_72995_K) {
                        ((EntitySheep)target).func_175512_b(EnumDyeColor.RED);
                    }
                    world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, SoundEvents.field_191249_bs, WizardrySounds.SPELLS, 1.0f, 1.0f, false);
                }
                if (!world.field_72995_K) {
                    MindControl.startControlling((EntityLiving)((EntityLiving)target), (EntityLivingBase)caster, (int)Integer.MAX_VALUE);
                    if (target instanceof EntityCreature) {
                        EntityCreature entityCreature = (EntityCreature)target;
                    }
                    ItemOverlordScepter.storeCurrentlyControlledEntityUUID(stack, target);
                }
            }
            if (world.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC, (Random)world.field_73012_v, (double)target.field_70165_t, (double)(target.field_70163_u + (double)target.func_70047_e()), (double)target.field_70161_v, (double)0.25, (boolean)false).clr(0.8f, 0.2f, 1.0f).spawn(world);
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC, (Random)world.field_73012_v, (double)target.field_70165_t, (double)(target.field_70163_u + (double)target.func_70047_e()), (double)target.field_70161_v, (double)0.25, (boolean)false).clr(0.2f, 0.04f, 0.25f).spawn(world);
                }
            }
        }
    }

    private static void storeCurrentlyControlledEntityUUID(ItemStack stack, EntityLivingBase entityToControl) {
        NBTTagCompound nbt = stack.func_77978_p() != null ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_186854_a(CONTROLLED_ENTITY, entityToControl.func_110124_au());
        stack.func_77982_d(nbt);
    }

    private static void stopEntityControl(EntityLivingBase controlledEntity, World world, EntityLivingBase attacker) {
        NBTTagCompound entityNBT;
        Entity caster;
        if (controlledEntity.func_70644_a(WizardryPotions.mind_control) && (caster = EntityUtils.getEntityByUUID((World)world, (UUID)(entityNBT = controlledEntity.getEntityData()).func_186857_a("controllingEntity"))) == attacker) {
            controlledEntity.func_184589_d(WizardryPotions.mind_control);
            if (controlledEntity instanceof EntityLiving) {
                for (EntityAITasks.EntityAITaskEntry entityaitasks$entityaitaskentry : ((EntityLiving)controlledEntity).field_70714_bg.field_75782_a) {
                    EntityAIBase entityAIBase = entityaitasks$entityaitaskentry.field_75733_a;
                    if (!(entityAIBase instanceof EntityAIWizardFollowPlayer)) continue;
                    ((EntityLiving)controlledEntity).field_70714_bg.func_85156_a(entityAIBase);
                }
            }
        }
    }
}

