/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.google.common.collect.ImmutableMap;
import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.client.gui.GuiHandlerAS;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryGuiHandler;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.spell.Spell;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemASSpellBook
extends ItemSpellBook {
    private static final Map<String, ResourceLocation> guiTextures = ImmutableMap.of((Object)"magic", (Object)new ResourceLocation("ancientspellcraft", "textures/gui/spell_book_ancient_element.png"), (Object)"non-magic", (Object)new ResourceLocation("ancientspellcraft", "textures/gui/spell_book_ancient_spellcraft.png"));

    public ResourceLocation getGuiTexture(Spell spell) {
        if (spell.getElement() == Element.MAGIC) {
            return guiTextures.get("magic");
        }
        return guiTextures.get("non-magic");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (world != null && itemstack.func_77952_i() != Short.MAX_VALUE) {
            Spell spell = Spell.byMetadata((int)itemstack.func_77952_i());
            boolean discovered = Wizardry.proxy.shouldDisplayDiscovered(spell, itemstack);
            String name = spell.getElement() == Element.MAGIC ? TextFormatting.GOLD + I18n.func_135052_a((String)("spell." + spell.getUnlocalisedName()), (Object[])new Object[0]) : "\u00a77" + spell.getDisplayNameWithFormatting();
            tooltip.add(discovered ? name : "#\u00a79" + SpellGlyphData.getGlyphName((Spell)spell, (World)world));
            tooltip.add(spell.getTier().getDisplayNameWithFormatting());
            if (discovered && advanced.func_194127_a()) {
                String elementTooltip = spell.getElement() == Element.MAGIC ? I18n.func_135052_a((String)"gui.ancientspellcraft:element.magic", (Object[])new Object[0]) : spell.getElement().getDisplayName();
                tooltip.add(elementTooltip);
                tooltip.add(spell.getType().getDisplayName());
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Spell spell = Spell.byMetadata((int)stack.func_77952_i());
        if (spell.getElement() == Element.MAGIC) {
            player.openGui((Object)AncientSpellcraft.instance, GuiHandlerAS.SPELL_BOOK_ANCIENT, world, 0, 0, 0);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        player.openGui((Object)Wizardry.instance, WizardryGuiHandler.SPELL_BOOK, world, 0, 0, 0);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }
}

