/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.handler;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.data.RitualDiscoveryData;
import com.windanesz.ancientspellcraft.entity.ai.EntitySummonAIFollowOwner;
import com.windanesz.ancientspellcraft.entity.projectile.EntityContingencyProjectile;
import com.windanesz.ancientspellcraft.entity.projectile.EntityMetamagicProjectile;
import com.windanesz.ancientspellcraft.integration.artemislib.ASArtemisLibIntegration;
import com.windanesz.ancientspellcraft.integration.baubles.ASBaublesIntegration;
import com.windanesz.ancientspellcraft.item.ItemBeltScrollHolder;
import com.windanesz.ancientspellcraft.item.ItemManaArtefact;
import com.windanesz.ancientspellcraft.item.ItemNewArtefact;
import com.windanesz.ancientspellcraft.item.ItemRitualBook;
import com.windanesz.ancientspellcraft.item.ItemSoulboundWandUpgrade;
import com.windanesz.ancientspellcraft.potion.PotionMetamagicEffect;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASEnchantments;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASPotions;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import com.windanesz.ancientspellcraft.ritual.Ritual;
import com.windanesz.ancientspellcraft.spell.Contingency;
import com.windanesz.ancientspellcraft.spell.DimensionalAnchor;
import com.windanesz.ancientspellcraft.spell.Martyr;
import com.windanesz.ancientspellcraft.spell.MetaSpellBuff;
import com.windanesz.ancientspellcraft.spell.MetamagicProjectile;
import com.windanesz.ancientspellcraft.spell.TimeKnot;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.construct.EntityBubble;
import electroblob.wizardry.entity.living.EntitySkeletonMinion;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.entity.projectile.EntityMagicProjectile;
import electroblob.wizardry.event.SpellBindEvent;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.integration.DamageSafetyChecker;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.item.ItemWandUpgrade;
import electroblob.wizardry.potion.Curse;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.ImbueWeapon;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.spell.SpellMinion;
import electroblob.wizardry.spell.SpellProjectile;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod.EventBusSubscriber
public class ASEventHandler {
    public static final float COST_REDUCTION_PER_ARMOUR = 0.15f;
    public static final IStoredVariable<Integer> SPELL_ID = IStoredVariable.StoredVariable.ofInt((String)"artefactEternitySpell", (Persistence)Persistence.ALWAYS);
    public static final IStoredVariable<Integer> COUNTDOWN_KEY = IStoredVariable.StoredVariable.ofInt((String)"artefactEternityCountdown", (Persistence)Persistence.NEVER).withTicker(ASEventHandler::update);

    private ASEventHandler() {
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.getWorld().field_72995_K && event.getItemStack().func_77973_b() == WizardryItems.identification_scroll && event.getEntityLiving() instanceof EntityPlayer) {
            Ritual ritual;
            EntityPlayer player;
            EnumHand otherHand = event.getHand() == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
            ItemStack otherItemStack = event.getEntityLiving().func_184586_b(otherHand);
            if (otherItemStack.func_77973_b() instanceof ItemRitualBook && !RitualDiscoveryData.hasRitualBeenDiscovered(player = (EntityPlayer)event.getEntityLiving(), ritual = ItemRitualBook.getRitual(otherItemStack))) {
                RitualDiscoveryData.addKnownRitual(player, ritual);
                if (!player.func_184812_l_()) {
                    event.getItemStack().func_190918_g(1);
                }
                ASUtils.sendMessage((Entity)player, "ritual.discover", false, ritual.getNameForTranslationFormatted());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        NBTTagCompound activeContingencies;
        EntityPlayer player;
        WizardData data;
        if (event.getEntityLiving().func_70644_a(ASPotions.magma_strider)) {
            EntityLivingBase entity = event.getEntityLiving();
            PotionEffect effect = entity.func_70660_b(ASPotions.magma_strider);
            if (entity.func_180799_ab() && entity instanceof EntityPlayer && !((EntityPlayer)entity).func_184812_l_()) {
                entity.field_70159_w *= (double)1.7f + 0.03 * (double)effect.func_76458_c();
                entity.field_70179_y *= (double)1.7f + 0.03 * (double)effect.func_76458_c();
                if (entity.func_70093_af() && entity.field_70181_x < 0.0 || entity.field_70181_x > 0.0) {
                    entity.field_70181_x *= (double)1.7f + 0.03 * (double)effect.func_76458_c();
                }
            }
        }
        if (event.getEntityLiving().func_70644_a(ASPotions.aquatic_agility)) {
            PotionEffect effect = event.getEntityLiving().func_70660_b(ASPotions.aquatic_agility);
            if (event.getEntityLiving().func_70090_H()) {
                event.getEntityLiving().field_70159_w *= (double)1.1f + 0.025 * (double)effect.func_76458_c();
                event.getEntityLiving().field_70179_y *= (double)1.1f + 0.025 * (double)effect.func_76458_c();
                if (event.getEntityLiving().func_70093_af() && event.getEntityLiving().field_70181_x < 0.0 || event.getEntityLiving().field_70181_x > 0.0) {
                    event.getEntityLiving().field_70181_x *= (double)1.1f + 0.025 * (double)effect.func_76458_c();
                }
            }
        }
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().field_70122_E && event.getEntityLiving().field_70143_R >= 4.0f && (data = WizardData.get((EntityPlayer)(player = (EntityPlayer)event.getEntityLiving()))) != null && (activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES)) != null && activeContingencies.func_74764_b(Contingency.Type.FALL.spellName)) {
            Contingency.tryCastContingencySpell(player, data, Contingency.Type.FALL);
        }
    }

    @SubscribeEvent
    public static void onPotionAddedEvent(PotionEvent.PotionAddedEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            NBTTagCompound activeContingencies;
            EntityPlayer player;
            WizardData data;
            ArrayList<Potion> effects = new ArrayList<Potion>();
            for (String entry : Settings.generalSettings.immobility_contingency_effects) {
                try {
                    Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(entry));
                    effects.add(potion);
                }
                catch (Exception e) {
                    AncientSpellcraft.logger.warn("No such potion type named as " + entry);
                }
            }
            if (event.getPotionEffect().func_188419_a() != null && effects.contains(event.getPotionEffect().func_188419_a()) && (data = WizardData.get((EntityPlayer)(player = (EntityPlayer)event.getEntityLiving()))) != null && (activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES)) != null && activeContingencies.func_74764_b(Contingency.Type.IMMOBILITY.spellName)) {
                Contingency.tryCastContingencySpell(player, data, Contingency.Type.IMMOBILITY);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityMountEvent(EntityMountEvent event) {
        NBTTagCompound activeContingencies;
        EntityPlayer player;
        WizardData data;
        if (event.getEntityBeingMounted() instanceof EntityBubble && event.getEntityMounting() instanceof EntityPlayer && event.isMounting() && (data = WizardData.get((EntityPlayer)(player = (EntityPlayer)event.getEntityMounting()))) != null && (activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES)) != null && activeContingencies.func_74764_b(Contingency.Type.IMMOBILITY.spellName)) {
            String spellName = activeContingencies.func_74779_i(Contingency.Type.IMMOBILITY.spellName);
            Contingency.tryCastContingencySpell(player, data, Contingency.Type.IMMOBILITY);
            if (spellName.equals(Spells.cure_effects.getUnlocalisedName())) {
                event.setCanceled(true);
                event.getEntityBeingMounted().func_70106_y();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        int level;
        EntityLivingBase attacker;
        if (event.getEntity() instanceof EntityPlayer && ((EntityPlayer)event.getEntity()).func_70644_a(ASPotions.burrow) && "inWall".equals(event.getSource().func_76355_l())) {
            event.setCanceled(true);
        }
        if (event.getSource() != null && event.getSource().func_76346_g() instanceof EntityLivingBase && !(attacker = (EntityLivingBase)event.getSource().func_76346_g()).func_184614_ca().func_190926_b() && ImbueWeapon.isSword((ItemStack)attacker.func_184614_ca()) && (level = EnchantmentHelper.func_77506_a((Enchantment)ASEnchantments.static_charge, (ItemStack)attacker.func_184614_ca())) > 0 && event.getEntityLiving().field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARK, (Entity)event.getEntityLiving()).spawn(event.getEntityLiving().field_70170_p);
            }
        }
    }

    private static void onMetaMagicFinished(EntityPlayer player, Spell spell, Potion effect) {
        ASEventHandler.setCooldown(player, spell);
        if (!player.field_70170_p.field_72995_K) {
            float chance = 0.0f;
            for (ItemArtefact ring : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[]{ItemArtefact.Type.RING})) {
                if (ring != ASItems.ring_metamagic_preserve) continue;
                chance += 0.33f;
            }
            if (chance > 0.0f && player.field_70170_p.field_73012_v.nextFloat() < chance) {
                player.func_184589_d(effect);
            }
        }
    }

    private static void setCooldown(EntityPlayer player, Spell spell) {
        List<ItemStack> wands = ASUtils.getAllHotbarWands(player);
        if (wands != null && !wands.isEmpty()) {
            for (ItemStack wand : wands) {
                int index = 0;
                for (Spell currentSpell : WandHelper.getSpells((ItemStack)wand)) {
                    try {
                        int[] cooldowns = WandHelper.getCooldowns((ItemStack)wand);
                        if (cooldowns.length == 0) {
                            int count = WandHelper.getSpells((ItemStack)wand).length - 1;
                            cooldowns = new int[count];
                        }
                        if (currentSpell == spell) {
                            int[] maxCooldowns = WandHelper.getMaxCooldowns((ItemStack)wand);
                            if (maxCooldowns.length == 0) {
                                int count = WandHelper.getSpells((ItemStack)wand).length - 1;
                                maxCooldowns = new int[count];
                            }
                            cooldowns[index] = 1200;
                            maxCooldowns[index] = 1200;
                            WandHelper.setCooldowns((ItemStack)wand, (int[])cooldowns);
                            WandHelper.setMaxCooldowns((ItemStack)wand, (int[])maxCooldowns);
                        }
                        ++index;
                    }
                    catch (Exception e) {
                        AncientSpellcraft.logger.error("Failed to set a wand cooldown");
                    }
                }
            }
        }
    }

    private static int update(EntityPlayer player, Integer countdown) {
        if (countdown == null) {
            return 0;
        }
        if (!player.field_70170_p.field_72995_K) {
            WizardData data = WizardData.get((EntityPlayer)player);
            Integer spellId = (Integer)data.getVariable(SPELL_ID);
            if (spellId == null) {
                return 0;
            }
            Spell spell = Spell.byMetadata((int)spellId);
            if (countdown != 1 || ItemArtefact.findMatchingWandAndCast((EntityPlayer)player, (Spell)spell)) {
                // empty if block
            }
            if (countdown > 0) {
                Integer n = countdown;
                Integer n2 = countdown = Integer.valueOf(countdown - 1);
            }
        }
        return countdown;
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        int level;
        EntityLivingBase attacker;
        WizardData data;
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer) {
            NBTTagCompound activeContingencies;
            Object effect;
            player = (EntityPlayer)event.getEntity();
            if (player.func_70644_a(ASPotions.wizard_shield) && (effect = player.func_70660_b(ASPotions.wizard_shield)) != null) {
                float oldAmount = event.getAmount();
                int oldTimer = effect.func_76459_b();
                int amplifier = effect.func_76458_c();
                player.func_85034_r(0);
                int usedUp = (int)event.getAmount();
                int newAmplifier = amplifier - usedUp;
                float newAmount = (int)event.getAmount() - (amplifier + 1);
                if (newAmount < 0.0f) {
                    amplifier = (int)(-newAmount);
                    event.setCanceled(true);
                }
                if (newAmplifier > 0) {
                    if (event.getSource().func_76364_f() instanceof EntityArrow) {
                        event.getSource().func_76364_f().func_70106_y();
                    }
                    player.func_184589_d(ASPotions.wizard_shield);
                    player.func_70690_d(new PotionEffect(ASPotions.wizard_shield, oldTimer, newAmplifier));
                } else {
                    player.func_184589_d(ASPotions.wizard_shield);
                }
                event.setAmount(newAmount);
            }
            block0: for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (artefact == ASItems.amulet_time_knot && player.func_70644_a(ASPotions.time_knot) && player.func_110143_aJ() - event.getAmount() <= 0.0f && !player.func_184811_cZ().func_185141_a(ASItems.amulet_time_knot)) {
                    TimeKnot.loopPlayer(player);
                    event.setCanceled(true);
                    player.func_70066_B();
                    player.func_184811_cZ().func_185145_a(ASItems.amulet_time_knot, 6000);
                }
                if (artefact == ASItems.charm_cryostasis) {
                    if (!(player.func_110143_aJ() <= 6.0f) && !(player.func_110143_aJ() - event.getAmount() <= 6.0f) || !(player.field_70170_p.field_73012_v.nextFloat() < 0.25f)) continue;
                    ASSpells.cryostasis.cast(player.field_70170_p, player, player.func_184600_cs(), 0, new SpellModifiers());
                    continue;
                }
                if (artefact == ASItems.ring_protector) {
                    if (!(player.func_110143_aJ() <= 8.0f) && !(player.func_110143_aJ() - event.getAmount() <= 6.0f) || !(player.field_70170_p.field_73012_v.nextFloat() < 0.5f)) continue;
                    boolean shouldContinue = true;
                    for (ItemStack wand : ASUtils.getAllHotbarWands(player)) {
                        if (!shouldContinue) continue block0;
                        Spell[] spells = WandHelper.getSpells((ItemStack)wand);
                        ArrayList<Spell> minions = new ArrayList<Spell>();
                        ArrayList<Integer> indexes = new ArrayList<Integer>();
                        int index = 0;
                        for (Spell spell : spells) {
                            if (spell instanceof SpellMinion) {
                                minions.add(spell);
                                indexes.add(index);
                            }
                            ++index;
                        }
                        if (minions.isEmpty()) continue;
                        int currIndex = indexes.size() == 1 ? 0 : player.field_70170_p.field_73012_v.nextInt(indexes.size() - 1);
                        Spell spell = (Spell)minions.get(currIndex);
                        SpellModifiers modifiers = new SpellModifiers();
                        modifiers = WizardData.get((EntityPlayer)player) != null ? WizardData.get((EntityPlayer)player).itemCastingModifiers : ((ItemWand)wand.func_77973_b()).calculateModifiers(wand, player, spell);
                        int[] cooldowns = WandHelper.getCooldowns((ItemStack)wand);
                        if (cooldowns != null && cooldowns.length != spells.length) continue;
                        WandHelper.selectSpell((ItemStack)wand, (int)currIndex);
                        shouldContinue = !((ItemWand)wand.func_77973_b()).cast(wand, spell, player, EnumHand.MAIN_HAND, 0, modifiers);
                        if (shouldContinue) continue;
                        WandHelper.setCooldowns((ItemStack)wand, (int[])cooldowns);
                    }
                    continue;
                }
                if (artefact == ASItems.ring_berserker) {
                    if (player.field_70170_p.field_72995_K || !(player.func_110143_aJ() <= 6.0f) && !(player.func_110143_aJ() - event.getAmount() <= 6.0f) || player.func_70644_a(MobEffects.field_76420_g)) continue;
                    player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 300));
                    continue;
                }
                if (artefact == ASItems.amulet_rabbit) {
                    if (player.field_70170_p.field_72995_K || !(player.field_70170_p.field_73012_v.nextFloat() < 0.25f)) continue;
                    if (!player.func_70644_a(MobEffects.field_76424_c)) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 200));
                    }
                    if (player.func_70644_a(MobEffects.field_76437_t)) continue;
                    player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 1));
                    continue;
                }
                if (artefact != ASItems.amulet_shield || player.func_184811_cZ().func_185141_a(ASItems.amulet_shield) || !(event.getAmount() > 1.0f)) continue;
                player.func_70690_d(new PotionEffect(ASPotions.wizard_shield, 100, 15));
                player.func_184811_cZ().func_185145_a(ASItems.amulet_shield, 3600);
            }
            if (event.getAmount() >= 0.0f && (data = WizardData.get((EntityPlayer)player)) != null && (activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES)) != null) {
                if (Contingency.isFireDamageSource(event.getSource()) && activeContingencies.func_74764_b(Contingency.Type.FIRE.spellName)) {
                    Contingency.tryCastContingencySpell(player, data, Contingency.Type.FIRE);
                } else if (event.getSource() == DamageSource.field_76369_e && activeContingencies.func_74764_b(Contingency.Type.DROWNING.spellName)) {
                    Contingency.tryCastContingencySpell(player, data, Contingency.Type.DROWNING);
                } else if (activeContingencies.func_74764_b(Contingency.Type.DAMAGE.spellName)) {
                    Contingency.tryCastContingencySpell(player, data, Contingency.Type.DAMAGE);
                }
                if (((double)player.func_110143_aJ() <= (double)player.func_110138_aP() * 0.25 || (double)(player.func_110143_aJ() - event.getAmount()) <= (double)player.func_110138_aP() * 0.25) && activeContingencies.func_74764_b(Contingency.Type.CRITICAL_HEALTH.spellName)) {
                    Contingency.tryCastContingencySpell(player, data, Contingency.Type.CRITICAL_HEALTH);
                }
            }
        }
        if (!(event.getEntity().field_70170_p.field_72995_K || !event.getEntityLiving().func_70644_a(ASPotions.martyr_beneficial) || !(event.getEntityLiving() instanceof EntityPlayer) || event.getSource().func_76363_c() || event.getSource() instanceof IElementalDamage && ((IElementalDamage)event.getSource()).isRetaliatory() || (data = WizardData.get((EntityPlayer)(player = (EntityPlayer)event.getEntityLiving()))) == null)) {
            Iterator<UUID> iterator = Martyr.getMartyrBoundEntities(data).iterator();
            while (iterator.hasNext()) {
                Entity entity = EntityUtils.getEntityByUUID((World)player.field_70170_p, (UUID)iterator.next());
                if (entity == null) {
                    iterator.remove();
                }
                if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_70644_a(ASPotions.martyr)) continue;
                if (DamageSafetyChecker.attackEntitySafely((Entity)entity, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)player, (MagicDamage.DamageType)MagicDamage.DamageType.MAGIC, (boolean)true), (float)event.getAmount(), (String)event.getSource().func_76355_l(), (DamageSource)DamageSource.field_76376_m, (boolean)false)) {
                    entity.func_184185_a(WizardrySounds.SPELL_CURSE_OF_SOULBINDING_RETALIATE, 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.2f + 1.0f);
                }
                event.setCanceled(true);
            }
        }
        if (event.getSource().func_76346_g() instanceof EntityLivingBase && !(attacker = (EntityLivingBase)event.getSource().func_76346_g()).func_184614_ca().func_190926_b() && ImbueWeapon.isSword((ItemStack)attacker.func_184614_ca()) && (level = EnchantmentHelper.func_77506_a((Enchantment)ASEnchantments.static_charge, (ItemStack)attacker.func_184614_ca())) > 0 && !MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.SHOCK, (Entity)event.getEntityLiving())) {
            event.setAmount(event.getAmount() + (float)(level * 2));
        }
    }

    @SubscribeEvent
    public static void onPotionApplicableEvent(PotionEvent.PotionApplicableEvent event) {
        if (event.getPotionEffect().func_188419_a() == ASPotions.eagle_eye && !(event.getEntityLiving() instanceof EntityPlayer)) {
            event.setResult(Event.Result.DENY);
        }
        if (!(event.getPotionEffect().func_188419_a() != ASPotions.shrinkage && event.getPotionEffect().func_188419_a() != ASPotions.growth || ASArtemisLibIntegration.enabled())) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (artefact == ASItems.amulet_poison_resistance) {
                    if (event.getPotionEffect().func_188419_a() != MobEffects.field_76436_u || !(player.field_70170_p.field_73012_v.nextFloat() < 0.5f)) continue;
                    event.setResult(Event.Result.DENY);
                    continue;
                }
                if (artefact == ASItems.amulet_curse_ward) {
                    if (!(event.getPotionEffect().func_188419_a() instanceof Curse)) continue;
                    event.setResult(Event.Result.DENY);
                    continue;
                }
                if (artefact != ASItems.amulet_persistence || event.getPotionEffect().func_188419_a() != ASPotions.shrinkage && event.getPotionEffect().func_188419_a() != ASPotions.growth) continue;
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionRemoveEvent(PotionEvent.PotionRemoveEvent event) {
        if (event.getPotion() == ASPotions.magical_exhaustion) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPotionExpiryEvent(PotionEvent.PotionExpiryEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                ItemStack pendant;
                Spell spell;
                ArrayList amuletList;
                if (artefact != ASItems.amulet_pendant_of_eternity || (amuletList = ASBaublesIntegration.enabled() ? ASBaublesIntegration.getEquippedArtefactStacks(player, ItemArtefact.Type.AMULET) : new ArrayList()).isEmpty() || (spell = ASEventHandler.getCurrentSpellFromSpellBearingArtefact(ASItems.amulet_pendant_of_eternity, pendant = (ItemStack)amuletList.get(0))) == Spells.none || !(spell instanceof SpellBuff)) continue;
                try {
                    SpellBuff obj = (SpellBuff)spell;
                    Field field = ASUtils.ReflectionUtil.getField(obj.getClass(), "potionSet");
                    ASUtils.ReflectionUtil.makeAccessible(field);
                    Set potionset = (Set)field.get(obj);
                    if (!potionset.contains(event.getPotionEffect().func_188419_a())) continue;
                    WizardData data = WizardData.get((EntityPlayer)player);
                    data.setVariable(COUNTDOWN_KEY, (Object)20);
                    data.setVariable(SPELL_ID, (Object)spell.metadata());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        NBTTagCompound compound;
        EntityPlayer player;
        if (event.getSource().func_76346_g() instanceof EntityPlayer && event.getEntity() instanceof EntityLivingBase && ((EntityLivingBase)event.getEntity()).func_70662_br()) {
            EntityLivingBase entity;
            player = (EntityPlayer)event.getSource().func_76346_g();
            if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_reanimation) && !event.getEntityLiving().field_70170_p.field_72995_K && player.field_70170_p.field_73012_v.nextFloat() < 0.15f && ((entity = event.getEntityLiving()) instanceof EntitySkeleton || entity instanceof EntityZombie)) {
                EntitySkeletonMinion skeletonMinion = new EntitySkeletonMinion(entity.field_70170_p);
                skeletonMinion.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                skeletonMinion.setCaster((EntityLivingBase)player);
                skeletonMinion.setLifetime(600);
                if (entity.func_184592_cb().func_77973_b() instanceof ItemBow || entity.func_184614_ca().func_77973_b() instanceof ItemBow) {
                    skeletonMinion.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                } else {
                    skeletonMinion.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151041_m));
                }
                skeletonMinion.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
                entity.field_70170_p.func_72838_d((Entity)skeletonMinion);
            }
        } else if (event.getEntityLiving() instanceof EntityPlayer) {
            NBTTagCompound activeContingencies;
            player = (EntityPlayer)event.getEntityLiving();
            WizardData data = WizardData.get((EntityPlayer)player);
            if (data != null && (activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES)) != null && activeContingencies.func_74764_b(Contingency.Type.DEATH.spellName)) {
                Contingency.tryCastContingencySpell(player, data, Contingency.Type.DEATH);
            }
            ItemSoulboundWandUpgrade.storeSoulboundWands(player);
        }
        if (event.getEntityLiving().getEntityData().func_74764_b("active_listener") && (compound = event.getEntityLiving().getEntityData().func_74775_l("active_listener")) != null && compound.func_74764_b(Contingency.Type.DEATH.spellName)) {
            Contingency.tryCastContingencySpellAsMob(event.getEntityLiving(), Contingency.Type.DEATH);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeathEventLowest(LivingDeathEvent event) {
        EntityPlayer player;
        if (event.getSource().func_76346_g() instanceof EntityPlayer && (player = (EntityPlayer)event.getSource().func_76346_g()).func_70644_a(ASPotions.spell_siphon)) {
            for (ItemStack stack : InventoryUtils.getPrioritisedHotbarAndOffhand((EntityPlayer)player)) {
                if (!(stack.func_77973_b() instanceof IManaStoringItem) || ((IManaStoringItem)stack.func_77973_b()).isManaFull(stack)) continue;
                int mana = 5 * (player.func_70660_b(ASPotions.spell_siphon).func_76458_c() + 1);
                ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, mana);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onProjectileImpactArrowEvent(ProjectileImpactEvent.Arrow event) {
        if (!event.getArrow().field_70170_p.field_72995_K && event.getArrow().field_70250_c instanceof EntityPlayer) {
            EntityLivingBase target;
            EntityPlayer player = (EntityPlayer)event.getArrow().field_70250_c;
            if (player.field_70170_p.field_73012_v.nextFloat() < 0.2f && ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.ring_poison_arrow) && event.getRayTraceResult().field_72308_g instanceof EntityLivingBase && !(target = (EntityLivingBase)event.getRayTraceResult().field_72308_g).func_70644_a(MobEffects.field_76436_u)) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        EntityPlayer player;
        if (event.getSpell().getTier().ordinal() > 1) {
            for (EntityPlayer player2 : event.getWorld().field_73010_i) {
                if (!(event.getCaster() instanceof EntityLivingBase) || !(event.getCaster().func_70068_e((Entity)player2) < 20.0) || !ItemArtefact.isArtefactActive((EntityPlayer)player2, (Item)ASItems.charm_suppression_orb)) continue;
                if (event.getCaster() instanceof EntityPlayer) {
                    ASUtils.sendMessage((Entity)event.getCaster(), "item.ancientspellcraft:charm_suppression_orb.message", true, new Object[0]);
                }
                event.setCanceled(true);
                return;
            }
        }
        if (event.getCaster() instanceof EntityPlayer && event.getSource() == SpellCastEvent.Source.WAND) {
            List<ItemStack> list;
            int wandMana;
            ItemStack wand;
            player = (EntityPlayer)event.getCaster();
            int cost = (int)((float)event.getSpell().getCost() * event.getModifiers().get("cost") + 0.1f);
            ItemStack itemStack = wand = event.getCaster().func_184614_ca().func_77973_b() instanceof ItemWand ? event.getCaster().func_184614_ca() : event.getCaster().func_184592_cb();
            if (wand.func_77973_b() instanceof ItemWand && (wandMana = ((ItemWand)wand.func_77973_b()).getMana(wand)) < cost && ASBaublesIntegration.enabled() && !(list = ASBaublesIntegration.getEquippedArtefactStacks(player, ItemArtefact.Type.RING)).isEmpty()) {
                for (ItemStack currentStack : list) {
                    int currMana;
                    if (!(currentStack.func_77973_b() instanceof ItemManaArtefact) || (currMana = ((ItemManaArtefact)currentStack.func_77973_b()).getMana(currentStack)) < cost) continue;
                    ((ItemManaArtefact)currentStack.func_77973_b()).setMana(currentStack, currMana - cost);
                    ((ItemWand)wand.func_77973_b()).setMana(wand, wandMana + cost);
                    if (!event.getSpell().isContinuous || (currMana = ((ItemManaArtefact)currentStack.func_77973_b()).getMana(currentStack)) < 50) break;
                    ((ItemManaArtefact)currentStack.func_77973_b()).setMana(currentStack, currMana - 50);
                    ((ItemWand)wand.func_77973_b()).rechargeMana(wand, 50);
                    break;
                }
            }
        }
        if (event.getSpell().getType() == SpellType.ALTERATION || event.getSpell().getType() == SpellType.ATTACK || event.getSpell().getType() == SpellType.MINION || event.getSpell().getType() == SpellType.PROJECTILE) {
            List closestPlayers = new ArrayList();
            if (event.getCaster() != null) {
                closestPlayers = EntityUtils.getEntitiesWithinRadius((double)20.0, (double)event.getCaster().field_70165_t, (double)event.getCaster().field_70163_u, (double)event.getCaster().field_70161_v, (World)event.getWorld(), EntityPlayer.class);
            }
            if (!closestPlayers.isEmpty()) {
                for (EntityPlayer player3 : closestPlayers) {
                    NBTTagCompound activeContingencies;
                    WizardData data;
                    if (event.getCaster() == player3 || AllyDesignationSystem.isAllied((EntityLivingBase)player3, (EntityLivingBase)event.getCaster()) || (data = WizardData.get((EntityPlayer)player3)) == null || (activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES)) == null || !activeContingencies.func_74764_b(Contingency.Type.HOSTILE_SPELLCAST.spellName)) continue;
                    Contingency.tryCastContingencySpell(player3, data, Contingency.Type.HOSTILE_SPELLCAST);
                }
            }
        }
        if (event.getCaster() instanceof EntityPlayer) {
            WizardData data;
            if (!(event.getSpell() instanceof MetaSpellBuff)) {
                player = (EntityPlayer)event.getCaster();
                HashMap potionEffectMap = new HashMap();
                Map potionEffects = player.func_193076_bZ();
                potionEffectMap.putAll(potionEffects);
                for (Map.Entry entry : potionEffectMap.entrySet()) {
                    float duration;
                    float range;
                    Potion potion = (Potion)entry.getKey();
                    if (potion instanceof PotionMetamagicEffect) {
                        int level;
                        PotionEffect effect;
                        if (potion.equals(ASPotions.arcane_augmentation)) {
                            effect = (PotionEffect)entry.getValue();
                            SpellModifiers modifiers = event.getModifiers();
                            range = modifiers.get(WizardryItems.range_upgrade);
                            float blast = modifiers.get(WizardryItems.blast_upgrade);
                            level = effect.func_76458_c() + 1;
                            if (level > 0) {
                                modifiers.set(WizardryItems.range_upgrade, blast + (float)level * 0.25f, true);
                                modifiers.set(WizardryItems.blast_upgrade, range + (float)level * 0.25f, true);
                            }
                            ASEventHandler.onMetaMagicFinished(player, ASSpells.arcane_augmentation, ASPotions.arcane_augmentation);
                        } else if (potion.equals(ASPotions.intensifying_focus)) {
                            effect = (PotionEffect)entry.getValue();
                            SpellModifiers modifiers = event.getModifiers();
                            float potency = modifiers.get("potency");
                            float range2 = modifiers.get(WizardryItems.range_upgrade);
                            float blast = modifiers.get(WizardryItems.range_upgrade);
                            int level2 = effect.func_76458_c() + 1;
                            if (level2 > 0) {
                                modifiers.set("potency", potency + (float)level2 * 0.15f, true);
                                modifiers.set(WizardryItems.range_upgrade, blast - (float)level2 * 0.25f, true);
                                modifiers.set(WizardryItems.blast_upgrade, range2 - (float)level2 * 0.25f, true);
                            }
                            ASEventHandler.setCooldown(player, ASSpells.intensifying_focus);
                            ASEventHandler.onMetaMagicFinished(player, ASSpells.intensifying_focus, ASPotions.intensifying_focus);
                        } else if (potion.equals(ASPotions.continuity_charm)) {
                            effect = (PotionEffect)entry.getValue();
                            SpellModifiers modifiers = event.getModifiers();
                            duration = modifiers.get(WizardryItems.duration_upgrade);
                            float cost = modifiers.get("cost");
                            level = effect.func_76458_c() + 1;
                            if (level > 0) {
                                modifiers.set(WizardryItems.duration_upgrade, duration + (float)level * 0.25f, true);
                                modifiers.set("cost", cost + (float)level * 0.15f, true);
                            }
                            ASEventHandler.onMetaMagicFinished(player, ASSpells.continuity_charm, ASPotions.continuity_charm);
                        }
                    }
                    int level = ((PotionEffect)entry.getValue()).func_76458_c() + 1;
                    if (potion == ASPotions.spell_blast) {
                        SpellModifiers modifiers = event.getModifiers();
                        float blast = modifiers.get(WizardryItems.blast_upgrade);
                        modifiers.set(WizardryItems.blast_upgrade, blast + (float)level * 0.25f, true);
                    }
                    if (potion == ASPotions.spell_range) {
                        SpellModifiers modifiers = event.getModifiers();
                        range = modifiers.get(WizardryItems.range_upgrade);
                        modifiers.set(WizardryItems.range_upgrade, range + (float)level * 0.25f, true);
                    }
                    if (potion == ASPotions.spell_cooldown) {
                        SpellModifiers modifiers = event.getModifiers();
                        float cooldown = modifiers.get(WizardryItems.cooldown_upgrade);
                        modifiers.set(WizardryItems.cooldown_upgrade, cooldown - (float)level * 0.15f, true);
                    }
                    if (potion != ASPotions.spell_duration) continue;
                    SpellModifiers modifiers = event.getModifiers();
                    duration = modifiers.get(WizardryItems.duration_upgrade);
                    modifiers.set(WizardryItems.duration_upgrade, duration + (float)level * 0.25f, false);
                }
            }
            player = (EntityPlayer)event.getCaster();
            SpellModifiers modifiers = event.getModifiers();
            int jewelsSetCount = 0;
            if (ItemNewArtefact.isNewArtefactActive(player, ASItems.belt_enchanter) && event.getSpell().getType() == SpellType.BUFF) {
                modifiers.set(WizardryItems.duration_upgrade, modifiers.get(WizardryItems.duration_upgrade) * 1.2f, false);
            }
            for (ItemNewArtefact artefact : ItemNewArtefact.getActiveNewArtefacts(player, new ItemNewArtefact.AdditionalType[0])) {
                if (artefact == ASItems.head_curse) {
                    float potency = modifiers.get("potency");
                    int modifier = 0;
                    for (Potion potion : player.func_193076_bZ().keySet()) {
                        if (!(potion instanceof Curse)) continue;
                        modifier = (int)((double)modifier + 0.1);
                    }
                    if (modifier < 0) continue;
                    modifiers.set("potency", (float)(1 + modifier) * potency, false);
                    continue;
                }
                if (artefact == ASItems.belt_scroll_holder && ASBaublesIntegration.enabled()) {
                    ItemStack scroll;
                    ItemStack holder = ASBaublesIntegration.getBeltSlotItemStack(player);
                    if (!(holder.func_77973_b() instanceof ItemBeltScrollHolder) || !((scroll = ItemBeltScrollHolder.getScroll(holder)).func_77973_b() instanceof ItemWandUpgrade)) continue;
                    if (scroll.func_77973_b() == WizardryItems.blast_upgrade) {
                        modifiers.set(WizardryItems.blast_upgrade, modifiers.get(WizardryItems.blast_upgrade) + 0.25f, true);
                        continue;
                    }
                    if (scroll.func_77973_b() == WizardryItems.range_upgrade) {
                        modifiers.set(WizardryItems.range_upgrade, modifiers.get(WizardryItems.range_upgrade) + 0.25f, true);
                        continue;
                    }
                    if (scroll.func_77973_b() == WizardryItems.duration_upgrade) {
                        modifiers.set(WizardryItems.duration_upgrade, modifiers.get(WizardryItems.duration_upgrade) + 0.25f, true);
                        continue;
                    }
                    if (scroll.func_77973_b() != WizardryItems.cooldown_upgrade) continue;
                    modifiers.set(WizardryItems.cooldown_upgrade, modifiers.get(WizardryItems.cooldown_upgrade) - 0.15f, true);
                    continue;
                }
                if (artefact != ASItems.head_lightning || !ASBaublesIntegration.enabled() || event.getSpell().getElement() != Element.LIGHTNING || player.field_70170_p.func_180495_p(player.func_180425_c()).func_177230_c() != ASBlocks.lightning_block) continue;
                modifiers.set(WizardryItems.blast_upgrade, modifiers.get(WizardryItems.blast_upgrade) + 0.25f, true);
                modifiers.set(WizardryItems.range_upgrade, modifiers.get(WizardryItems.range_upgrade) + 0.25f, true);
                modifiers.set(WizardryItems.duration_upgrade, modifiers.get(WizardryItems.duration_upgrade) + 0.25f, true);
            }
            for (ItemNewArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                float potency = modifiers.get("potency");
                float cost = modifiers.get("cost");
                if (artefact == ASItems.charm_mana_orb) {
                    modifiers.set("cost", 0.85f * cost, false);
                } else if (artefact == ASItems.amulet_mana) {
                    modifiers.set("cost", 0.9f * cost, false);
                } else if (artefact == ASItems.ring_blast) {
                    modifiers.set("cost", 1.25f * cost, false);
                    event.getModifiers().set(WizardryItems.blast_upgrade, event.getModifiers().get(WizardryItems.blast_upgrade) + 0.25f, true);
                } else if (artefact == ASItems.ring_range) {
                    modifiers.set("cost", 1.25f * cost, false);
                    event.getModifiers().set(WizardryItems.range_upgrade, event.getModifiers().get(WizardryItems.range_upgrade) + 0.25f, true);
                } else if (artefact == ASItems.charm_elemental_grimoire) {
                    if (event.getSpell().getElement() == Element.FIRE || event.getSpell().getElement() == Element.ICE || event.getSpell().getElement() == Element.LIGHTNING) {
                        modifiers.set("potency", 0.1f + potency, false);
                    }
                } else if (artefact == ASItems.charm_earth_orb) {
                    if (event.getSpell().getElement() == Element.EARTH) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (artefact == ASItems.charm_healing_orb) {
                    if (event.getSpell().getElement() == Element.HEALING) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (artefact == ASItems.charm_lightning_orb) {
                    if (event.getSpell().getElement() == Element.LIGHTNING) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (artefact == ASItems.charm_fire_orb) {
                    if (event.getSpell().getElement() == Element.FIRE) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (artefact == ASItems.charm_ice_orb) {
                    if (event.getSpell().getElement() == Element.ICE) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (artefact == ASItems.charm_necromancy_orb) {
                    if (event.getSpell().getElement() == Element.NECROMANCY) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (artefact == ASItems.charm_sorcery_orb) {
                    if (event.getSpell().getElement() == Element.SORCERY) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                }
                if (artefact == ASItems.ring_power) {
                    ++jewelsSetCount;
                    modifiers.set("potency", 0.05f + potency, false);
                    modifiers.set("cost", 0.05f + cost, false);
                    continue;
                }
                if (artefact == ASItems.amulet_power) {
                    ++jewelsSetCount;
                    modifiers.set("potency", 0.1f + potency, false);
                    modifiers.set("cost", 0.1f + cost, false);
                    continue;
                }
                if (artefact != ASItems.charm_power_orb) continue;
                ++jewelsSetCount;
                modifiers.set("potency", 0.2f + potency, false);
                modifiers.set("cost", 0.2f + cost, false);
            }
            if (jewelsSetCount > 1) {
                float potency = modifiers.get("potency");
                float potencyBonus = (float)(jewelsSetCount - 1) * 5.0f / 100.0f;
                modifiers.set("potency", potencyBonus + potency, false);
            }
            if ((data = WizardData.get((EntityPlayer)player)) != null && !(event.getSpell() instanceof Contingency)) {
                if (data.getVariable(MetamagicProjectile.METAMAGIC_PROJECTILE) != null && ((Boolean)data.getVariable(MetamagicProjectile.METAMAGIC_PROJECTILE)).booleanValue()) {
                    if (event.getSpell() instanceof MetaSpellBuff || event.getSpell() instanceof SpellRay || event.getSpell() instanceof SpellProjectile || event.getSpell() instanceof MetamagicProjectile) {
                        return;
                    }
                    EntityMetamagicProjectile projectile = new EntityMetamagicProjectile(player.field_70170_p);
                    projectile.setCaster((EntityLivingBase)player);
                    projectile.setStoredSpell(event.getSpell());
                    projectile.aim((EntityLivingBase)player, ASEventHandler.calculateVelocity(projectile, modifiers, player.func_70047_e() - 0.1f));
                    projectile.damageMultiplier = modifiers.get("potency");
                    if (!player.field_70170_p.field_72995_K) {
                        player.field_70170_p.func_72838_d((Entity)projectile);
                    }
                    data.setVariable(MetamagicProjectile.METAMAGIC_PROJECTILE, null);
                    event.setCanceled(true);
                    return;
                }
                NBTTagCompound activeContingencyListener = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCY_LISTENER);
                if (activeContingencyListener != null && activeContingencyListener.func_74764_b("active_listener")) {
                    if (player.func_70093_af() && Contingency.Type.fromName(activeContingencyListener.func_74779_i("active_listener")) == Contingency.Type.DEATH) {
                        EntityContingencyProjectile projectile = new EntityContingencyProjectile(player.field_70170_p);
                        projectile.setCaster((EntityLivingBase)player);
                        projectile.setStoredSpell(event.getSpell());
                        projectile.setContingencyType(Contingency.Type.fromName(activeContingencyListener.func_74779_i("active_listener")));
                        projectile.aim((EntityLivingBase)player, ASEventHandler.calculateVelocity(projectile, modifiers, player.func_70047_e() - 0.1f));
                        projectile.damageMultiplier = modifiers.get("potency");
                        if (!event.getWorld().field_72995_K) {
                            player.field_70170_p.func_72838_d((Entity)projectile);
                        }
                        data.setVariable(Contingency.ACTIVE_CONTINGENCY_LISTENER, null);
                        Contingency.playSound(event.getWorld(), player.func_180425_c());
                        event.setCanceled(true);
                        return;
                    }
                    String spellTag = activeContingencyListener.func_74779_i("active_listener");
                    Spell contingency = (Spell)Spell.registry.getValue(new ResourceLocation(spellTag));
                    Spell spellToStore = event.getSpell();
                    NBTTagCompound activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES);
                    if (activeContingencies == null) {
                        activeContingencies = new NBTTagCompound();
                    }
                    activeContingencies.func_74778_a(contingency.getRegistryName().toString(), spellToStore.getRegistryName().toString());
                    if (event.getSource() == SpellCastEvent.Source.WAND) {
                        if (player.func_184614_ca().func_77973_b() instanceof ItemWand) {
                            ((ItemWand)player.func_184614_ca().func_77973_b()).consumeMana(player.func_184614_ca(), spellToStore.getCost(), (EntityLivingBase)player);
                            if (!spellToStore.isContinuous && !player.func_184812_l_()) {
                                WandHelper.setCurrentCooldown((ItemStack)player.func_184614_ca(), (int)((int)((float)spellToStore.getCooldown() * modifiers.get(WizardryItems.cooldown_upgrade))));
                            }
                        } else if (player.func_184592_cb().func_77973_b() instanceof ItemWand) {
                            ((ItemWand)player.func_184592_cb().func_77973_b()).consumeMana(player.func_184592_cb(), spellToStore.getCost(), (EntityLivingBase)player);
                            if (!spellToStore.isContinuous && !player.func_184812_l_()) {
                                WandHelper.setCurrentCooldown((ItemStack)player.func_184592_cb(), (int)((int)((float)spellToStore.getCooldown() * modifiers.get(WizardryItems.cooldown_upgrade))));
                            }
                        }
                    } else if (event.getSource() == SpellCastEvent.Source.SCROLL) {
                        if (player.func_184614_ca().func_77973_b() instanceof ItemScroll) {
                            player.func_184614_ca().func_190918_g(1);
                            player.func_184811_cZ().func_185145_a(player.func_184614_ca().func_77973_b(), spellToStore.getCooldown());
                        } else if (player.func_184592_cb().func_77973_b() instanceof ItemScroll) {
                            player.func_184592_cb().func_190918_g(1);
                            player.func_184811_cZ().func_185145_a(player.func_184614_ca().func_77973_b(), spellToStore.getCooldown());
                        }
                    }
                    if (event.getWorld().field_72995_K) {
                        Contingency.spawnParticles(event.getWorld(), (EntityLivingBase)player, Contingency.Type.fromName(spellTag));
                    }
                    Contingency.playSound(event.getWorld(), player.func_180425_c());
                    data.setVariable(Contingency.ACTIVE_CONTINGENCY_LISTENER, null);
                    data.setVariable(Contingency.ACTIVE_CONTINGENCIES, (Object)activeContingencies);
                    data.sync();
                    event.setCanceled(true);
                }
            }
        }
        if (DimensionalAnchor.shouldPreventSpell(event.getCaster(), event.getWorld(), event.getSpell())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onSpellCastPostEvent(SpellCastEvent.Post event) {
        EntityPlayer player;
        if (event.getCaster() instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)(player = (EntityPlayer)event.getCaster()), (Item)ASItems.charm_knowledge_orb)) {
            boolean flag = false;
            if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemWand) {
                if (((ItemWand)player.func_184614_ca().func_77973_b()).tier.level == Tier.MASTER.level) {
                    flag = true;
                }
            } else if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ItemWand && ((ItemWand)player.func_184592_cb().func_77973_b()).tier.level == Tier.MASTER.level) {
                flag = true;
            }
            if (flag) {
                int progression = (int)((float)event.getSpell().getCost() * event.getModifiers().get("progression"));
                List<ItemStack> wands = ASUtils.getAllHotbarWands(player, Tier.ADVANCED);
                if (wands != null && !wands.isEmpty()) {
                    ItemStack targetWand = ASUtils.getRandomListItem(wands);
                    WandHelper.addProgression((ItemStack)targetWand, (int)progression);
                    Tier nextTier = Tier.values()[((ItemWand)targetWand.func_77973_b()).tier.ordinal() + 1];
                    int excess = WandHelper.getProgression((ItemStack)targetWand) - nextTier.getProgression();
                    if (excess >= 0 && excess < progression) {
                        player.func_184185_a(WizardrySounds.ITEM_WAND_LEVELUP, 1.25f, 1.0f);
                        if (!player.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("item.ebwizardry:wand.levelup", new Object[]{targetWand.func_77973_b().func_77653_i(targetWand), nextTier.getNameForTranslationFormatted()}));
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onArcaneWorkbenchApplyButtonPressed(SpellBindEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            int centre_slot = 9;
            int upgrade_slot = 10;
            ItemStack centre = event.getContainer().func_75139_a(centre_slot).func_75211_c();
            ItemStack upgrade = event.getContainer().func_75139_a(upgrade_slot).func_75211_c();
            EntityPlayer player = event.getEntityPlayer();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (artefact != ASItems.charm_wand_upgrade || !(player.field_70170_p.field_73012_v.nextFloat() < 0.2f) || !WandHelper.isWandUpgrade((Item)upgrade.func_77973_b()) || !(centre.func_77973_b() instanceof ItemWand)) continue;
                Item specialUpgrade = upgrade.func_77973_b();
                if (WandHelper.getTotalUpgrades((ItemStack)centre) >= ((ItemWand)centre.func_77973_b()).tier.upgradeLimit || WandHelper.getUpgradeLevel((ItemStack)centre, (Item)specialUpgrade) >= 3) continue;
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.tag_has_no_name", new Object[0]), true);
                player.func_191521_c(new ItemStack(specialUpgrade));
            }
        }
    }

    private static ItemStack getArtefactItemStack(EntityPlayer player, ItemArtefact artefact) {
        return ASUtils.getItemStackFromInventoryHotbar(player, (Item)artefact);
    }

    private static Spell getCurrentSpellFromSpellBearingArtefact(Item item, ItemStack stack) {
        return Spell.byMetadata((int)stack.func_77952_i());
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        EntityPlayer player;
        if (event.phase == TickEvent.Phase.START) {
            player = event.player;
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                float i;
                if (artefact != ASItems.ring_prismarine || !player.func_70027_ad() || (i = player.func_184811_cZ().func_185143_a(ASItems.ring_prismarine, 0.0f)) != 0.0f) continue;
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 120));
                SpellModifiers modifiers = new SpellModifiers();
                if (!ASSpells.extinguish.cast(player.field_70170_p, player, EnumHand.MAIN_HAND, 0, modifiers)) continue;
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.SCROLL, ASSpells.extinguish, (EntityLivingBase)player, modifiers));
                player.func_184811_cZ().func_185145_a(ASItems.ring_prismarine, 1200);
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            player = event.player;
            if (ASBaublesIntegration.enabled()) {
                ASBaublesIntegration.tickWornArtefacts(player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCheckSpawnEvent(EntityJoinWorldEvent event) {
        Entity owner;
        if (event.getEntity() instanceof ISummonedCreature && event.getEntity() instanceof EntityCreature && ((ISummonedCreature)event.getEntity()).func_70902_q() != null && (owner = ((ISummonedCreature)event.getEntity()).func_70902_q()) instanceof EntityPlayer && ItemNewArtefact.isNewArtefactActive((EntityPlayer)owner, ASItems.head_minions) && ItemNewArtefact.isNewArtefactActive((EntityPlayer)owner, ASItems.head_minions)) {
            EntityCreature creature = (EntityCreature)event.getEntity();
            EntitySummonAIFollowOwner task = new EntitySummonAIFollowOwner(creature, 1.0, 10.0f, 2.0f);
            creature.field_70714_bg.func_75776_a(5, (EntityAIBase)task);
        }
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)event.getEntity();
            if (arrow.field_70250_c instanceof EntityLivingBase) {
                EntityLivingBase archer = (EntityLivingBase)arrow.field_70250_c;
                ItemStack bow = archer.func_184614_ca();
                if (!ImbueWeapon.isBow((ItemStack)bow) && !ImbueWeapon.isBow((ItemStack)(bow = archer.func_184592_cb()))) {
                    return;
                }
                int level = EnchantmentHelper.func_77506_a((Enchantment)ASEnchantments.degrade_bow, (ItemStack)bow);
                if (level > 0) {
                    arrow.func_70239_b(arrow.func_70242_d() * (1.5 / (double)(level + 1)));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        ItemSoulboundWandUpgrade.restoreStoredWandsToInventory(event.player);
    }

    public static float calculateVelocity(EntityMagicProjectile projectile, SpellModifiers modifiers, float launchHeight) {
        float range = 20.0f * modifiers.get(WizardryItems.range_upgrade);
        if (projectile.func_189652_ae()) {
            if (projectile.getLifetime() <= 0) {
                return 1.5f;
            }
            return range / (float)projectile.getLifetime();
        }
        float g = 0.03f;
        return range / MathHelper.func_76129_c((float)(2.0f * launchHeight / g));
    }

    static {
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{COUNTDOWN_KEY, SPELL_ID});
    }
}

