/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.living;

import com.google.common.base.Optional;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.util.ParticleBuilder;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityWolfMinion
extends EntityWolf
implements ISummonedCreature {
    private int lifetime = -1;
    private UUID casterUUID;

    public EntityWolfMinion(World world) {
        super(world);
        this.field_70728_aV = 0;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public void setOwner(EntityLivingBase owner) {
        this.casterUUID = owner.func_110124_au();
        this.field_70180_af.func_187227_b(field_184756_bw, (Object)Optional.fromNullable((Object)owner.func_110124_au()));
    }

    public void readSpawnData(ByteBuf buffer) {
        int id = buffer.readInt();
        if (id > -1) {
            Entity entity = Wizardry.proxy.getTheWorld().func_73045_a(id);
            if (entity instanceof EntityLivingBase) {
                this.setOwner((EntityLivingBase)entity);
            } else {
                Wizardry.logger.warn("Received a spawn packet for entity {}, but no living entity matched the supplied ID", (Object)this);
            }
        }
        this.setLifetime(buffer.readInt());
    }

    public void onSpawn() {
        this.spawnParticleEffect();
    }

    public void onDespawn() {
        this.spawnParticleEffect();
    }

    private void spawnParticleEffect() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 15; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)this.field_70146_Z.nextFloat(), this.field_70163_u + 1.0 + (double)this.field_70146_Z.nextFloat(), this.field_70161_v + (double)this.field_70146_Z.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean hasParticleEffect() {
        return false;
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, this.getTargetSelector()));
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        if (this.field_70170_p.field_72995_K) {
            this.spawnAppearParticles();
        }
        if (this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70606_j(this.func_110138_aP());
        }
        return livingdata;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateDelegate();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return this.interactDelegate(player, hand) || super.func_184645_a(player, hand);
    }

    private void spawnAppearParticles() {
        for (int i = 0; i < 15; ++i) {
            double x = this.field_70165_t - (double)(this.field_70130_N / 2.0f) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N);
            double y = this.field_70163_u + (double)(this.field_70131_O * this.field_70146_Z.nextFloat()) + (double)0.2f;
            double z = this.field_70161_v - (double)(this.field_70130_N / 2.0f) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).clr(0, 67, 0).spawn(this.field_70170_p);
        }
    }

    public EntityWolf func_90011_a(EntityAgeable par1EntityAgeable) {
        return null;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected Item func_146068_u() {
        return null;
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    public ITextComponent func_145748_c_() {
        if (this.func_70902_q() != null) {
            return new TextComponentTranslation("entity.ebwizardry:summonedcreature.nameplate", new Object[]{this.func_70902_q().func_70005_c_(), new TextComponentTranslation("entity." + this.func_70022_Q() + ".name", new Object[0])});
        }
        return super.func_145748_c_();
    }

    public boolean func_145818_k_() {
        return Wizardry.settings.summonedCreatureNames && this.func_70902_q() != null;
    }

    public void func_193101_c(EntityPlayer player) {
        super.func_193101_c(player);
        this.setCaster(this.func_70902_q());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }
}

