/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.living;

import com.windanesz.ancientspellcraft.entity.ai.EntityAIAttackSpellImproved;
import com.windanesz.ancientspellcraft.entity.living.Vector;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntitySkeletonMageMinion
extends AbstractSkeleton
implements ISpellCaster,
ISummonedCreature {
    private int lifetime = -1;
    private UUID casterUUID;
    private double AISpeed = 1.0;
    private Spell continuousSpell;
    private int spellCounter;
    private int particleCount = 1;
    private float particleSize = 0.7f;
    private Element element = Element.MAGIC;
    private static final DataParameter<Integer> ELEMENT = EntityDataManager.func_187226_a(EntitySkeletonMageMinion.class, (DataSerializer)DataSerializers.field_187192_b);
    private List<Spell> spells = new ArrayList<Spell>(1);
    private EntityAIAttackSpellImproved<EntitySkeletonMageMinion> spellcastingAI = new EntityAIAttackSpellImproved<EntitySkeletonMageMinion>(this, this.AISpeed, 15.0f, 25, 0);
    private EntityAINearestAttackableTarget<EntityLivingBase> commonTargetingAI = new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, this.getTargetSelector());
    private EntityAINearestAttackableTarget<EntityPlayer> healerTargetingAI = new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, false, true){

        protected boolean func_75296_a(@Nullable EntityLivingBase target, boolean includeInvincibles) {
            return target instanceof EntityPlayer && ((EntityPlayer)target).func_110124_au() == EntitySkeletonMageMinion.this.func_184753_b() && target.func_110143_aJ() < target.func_110138_aP();
        }
    };

    public EntitySkeletonMageMinion(World world) {
        super(world);
        this.field_70728_aV = 0;
        this.field_70714_bg.func_75776_a(0, this.spellcastingAI);
        this.field_70715_bh.func_75776_a(2, this.commonTargetingAI);
    }

    public EntitySkeletonMageMinion(World world, Element element) {
        super(world);
        this.field_70728_aV = 0;
        this.element = element;
        this.field_70714_bg.func_75776_a(0, this.spellcastingAI);
        if (this.element == Element.HEALING || this.getElement() == Element.HEALING) {
            this.field_70715_bh.func_75776_a(2, this.healerTargetingAI);
        } else {
            this.field_70715_bh.func_75776_a(2, this.commonTargetingAI);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ELEMENT, (Object)0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_184641_n(false);
        if (this.element == Element.MAGIC) {
            this.setElement(Element.values()[this.field_70146_Z.nextInt(Element.values().length - 1) + 1]);
        } else {
            this.setElement(this.element);
        }
        Element element = this.getElement();
        this.populateSpellList(element, null);
        return livingdata;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ASItems.wizard_hat_ancient));
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            this.func_184642_a(slot, 0.0f);
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.func_70659_e((float)this.AISpeed);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateDelegate();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.renderHandParticle();
    }

    private void renderHandParticle() {
        Vec3d height = this.func_174791_d().func_72441_c(0.0, 0.84, 0.0);
        Vec3d rightHand = Vector.toRectangular(Math.toRadians(this.field_70761_aq + 90.0f), 0.0).times(0.385).withY(0.0).toMinecraft();
        Vec3d leftHand = Vector.toRectangular(Math.toRadians(this.field_70761_aq - 90.0f), 0.0).times(0.385).withY(0.0).toMinecraft();
        rightHand = rightHand.func_178787_e(height);
        leftHand = leftHand.func_178787_e(height);
        if (this.field_82175_bq) {
            rightHand = rightHand.func_72441_c(this.func_70040_Z().field_72450_a * 0.5, (double)this.field_70733_aJ * 0.6, this.func_70040_Z().field_72449_c * 0.5);
        }
        this.spawnHandParticle(rightHand);
        this.spawnHandParticle(leftHand);
    }

    private void spawnHandParticle(Vec3d handSide) {
        if (this.field_70170_p.field_72995_K) {
            block9: for (int i = 0; i < this.particleCount; ++i) {
                switch (this.getElement()) {
                    case FIRE: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).pos(handSide).time(6 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(246, 180 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 50), 80).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(6 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(255, 116, 0).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).pos(handSide).time(6 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(246, 180 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 50), 80).collide(false).scale(this.particleSize / 2.0f).spawn(this.field_70170_p);
                        continue block9;
                    }
                    case ICE: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.ICE).pos(handSide).time(6 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(6 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(0, 204, 255).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        continue block9;
                    }
                    case LIGHTNING: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARK).pos(handSide).time(6 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(EntitySkeletonMageMinion.getRandomNumberInRange(0, 2)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(27, 102, 125).collide(false).scale(this.particleSize / 0.9f).spawn(this.field_70170_p);
                        continue block9;
                    }
                    case EARTH: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LEAF).pos(handSide).time(6 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(6 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(102, 51, 0).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LEAF).pos(handSide).time(6 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).collide(false).scale(this.particleSize / 2.0f).spawn(this.field_70170_p);
                        continue block9;
                    }
                    case SORCERY: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(6 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(89, 238, 155).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        continue block9;
                    }
                    case HEALING: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(handSide).time(6 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(246, 180 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 50), 80).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(6 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(255, 255, 204).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(handSide).time(6 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(246, 180 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 50), 80).collide(false).scale(this.particleSize / 2.0f).spawn(this.field_70170_p);
                        continue block9;
                    }
                    case NECROMANCY: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(6 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(51, 0, 26).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(6 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(32 + EntitySkeletonMageMinion.getRandomNumberInRange(0, 25), 1, 36).collide(false).scale(this.particleSize / 2.2f).spawn(this.field_70170_p);
                    }
                }
            }
        }
    }

    public Element getElement() {
        return Element.values()[(Integer)this.field_70180_af.func_187225_a(ELEMENT)];
    }

    public void setElement(Element element) {
        this.field_70180_af.func_187227_b(ELEMENT, (Object)element.ordinal());
    }

    public void populateSpellList(Element element, Spell spell) {
        this.spells = new ArrayList<Spell>(1);
        if (spell != null) {
            this.spells.add(spell);
            return;
        }
        switch (element) {
            case FIRE: {
                this.spells.add(Spells.fireball);
                break;
            }
            case ICE: {
                this.spells.add(Spells.iceball);
                break;
            }
            case LIGHTNING: {
                this.spells.add(Spells.lightning_arrow);
                break;
            }
            case EARTH: {
                this.spells.add(Spells.dart);
                break;
            }
            case SORCERY: {
                this.spells.add(Spells.force_arrow);
                break;
            }
            case HEALING: {
                this.spells.add(ASSpells.healing_heart);
                break;
            }
            case NECROMANCY: {
                this.spells.add(Spells.darkness_orb);
                break;
            }
            default: {
                this.spells.add(Spells.magic_missile);
            }
        }
    }

    private static int getRandomNumberInRange(int min, int max) {
        Random r = new Random();
        return r.nextInt(max - min + 1) + min;
    }

    private boolean hasRangedAttack() {
        return true;
    }

    public List<Spell> getSpells() {
        return this.spells;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public void setOwnerId(UUID uuid) {
        this.casterUUID = uuid;
    }

    public UUID func_184753_b() {
        return this.casterUUID;
    }

    public void onSpawn() {
        this.spawnParticleEffect();
    }

    public void onDespawn() {
        this.spawnParticleEffect();
    }

    private void spawnParticleEffect() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 15; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)this.field_70146_Z.nextFloat(), this.field_70163_u + 1.0 + (double)this.field_70146_Z.nextFloat(), this.field_70161_v + (double)this.field_70146_Z.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.writeNBTDelegate(nbt);
        nbt.func_74768_a("element", this.getElement().ordinal());
        NBTExtras.storeTagSafely((NBTTagCompound)nbt, (String)"spells", (NBTBase)NBTExtras.listToNBT(this.spells, spell -> new NBTTagInt(spell.metadata())));
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.readNBTDelegate(nbt);
        this.setElement(Element.values()[nbt.func_74762_e("element")]);
        this.spells = (List)NBTExtras.NBTToList((NBTTagList)nbt.func_150295_c("spells", 3), tag -> Spell.byMetadata((int)tag.func_150287_d()));
    }

    public boolean hasParticleEffect() {
        return false;
    }

    public SpellModifiers getModifiers() {
        return new SpellModifiers();
    }

    public void setContinuousSpell(Spell spell) {
        this.continuousSpell = spell;
    }

    public Spell getContinuousSpell() {
        return this.continuousSpell;
    }

    public void setSpellCounter(int count) {
        this.spellCounter = count;
    }

    public int getSpellCounter() {
        return this.spellCounter;
    }

    protected SoundEvent func_190727_o() {
        return SoundEvents.field_190035_gx;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190032_gu;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_190034_gw;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190033_gv;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return this.interactDelegate(player, hand) || super.func_184645_a(player, hand);
    }

    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected Item func_146068_u() {
        return null;
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    public boolean func_98052_bS() {
        return false;
    }

    protected boolean func_70692_ba() {
        return this.getCaster() == null && this.func_184753_b() == null;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> entityType) {
        return !EntityFlying.class.isAssignableFrom(entityType) || this.hasRangedAttack();
    }

    public ITextComponent func_145748_c_() {
        if (this.getCaster() != null) {
            return new TextComponentTranslation("entity.ebwizardry:summonedcreature.nameplate", new Object[]{this.getCaster().func_70005_c_(), new TextComponentTranslation("entity." + this.func_70022_Q() + ".name", new Object[0])});
        }
        return super.func_145748_c_();
    }

    public boolean func_145818_k_() {
        return Wizardry.settings.summonedCreatureNames && this.getCaster() != null;
    }

    public float func_70047_e() {
        return 1.74f;
    }

    public double func_70033_W() {
        return -0.6;
    }
}

