/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.living;

import com.windanesz.ancientspellcraft.entity.ai.EntityAIAttackSpellImproved;
import com.windanesz.ancientspellcraft.entity.ai.EntityAIBattlemageMelee;
import com.windanesz.ancientspellcraft.entity.ai.EntityAIBattlemageSpellcasting;
import com.windanesz.ancientspellcraft.entity.living.IArmourClassWizard;
import com.windanesz.ancientspellcraft.entity.living.ICustomCooldown;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.living.EntityAIAttackSpell;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityEvilClassWizard
extends EntityEvilWizard
implements ICustomCooldown,
IArmourClassWizard {
    private static final ResourceLocation BATTLEMAGE_LOOT_TABLE = new ResourceLocation("ancientspellcraft", "entities/evil_battlemage");
    private static final ResourceLocation SAGE_LOOT_TABLE = new ResourceLocation("ancientspellcraft", "entities/evil_sage");
    public ItemWizardArmour.ArmourClass armourClass = ItemWizardArmour.ArmourClass.BATTLEMAGE;
    protected int cooldown;
    private static final DataParameter<Integer> EVIL_WIZARD_ARMOUR_CLASS = EntityDataManager.func_187226_a(EntityEvilClassWizard.class, (DataSerializer)DataSerializers.field_187192_b);
    private List<Spell> spells = new ArrayList<Spell>(4);
    private EntityAIAttackSpellImproved<EntityEvilClassWizard> spellCastingAIImproved = new EntityAIAttackSpellImproved<EntityEvilClassWizard>(this, 0.5, 14.0f, 30, 50);
    private final EntityAIBattlemageMelee entityAIBattlemageMelee = new EntityAIBattlemageMelee<EntityEvilClassWizard>(this, 0.6, false);
    private final EntityAIBattlemageSpellcasting entityAIBattlemageSpellcasting = new EntityAIBattlemageSpellcasting<EntityEvilClassWizard>(this, 0.6, 14.0f, 30, 50);

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public int incrementCooldown() {
        return this.cooldown++;
    }

    @Override
    public int decrementCooldown() {
        return this.cooldown--;
    }

    public EntityEvilClassWizard(World world) {
        super(world);
        this.field_70714_bg.field_75782_a.removeIf(t -> t.field_75733_a instanceof EntityAIAttackSpell);
        this.field_70714_bg.func_75776_a(3, this.spellCastingAIImproved);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.entityAIBattlemageMelee);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.entityAIBattlemageSpellcasting);
    }

    protected ResourceLocation func_184647_J() {
        ResourceLocation loot = super.func_184647_J();
        if (this.getArmourClass() == ItemWizardArmour.ArmourClass.BATTLEMAGE) {
            loot = BATTLEMAGE_LOOT_TABLE;
        } else if (this.getArmourClass() == ItemWizardArmour.ArmourClass.SAGE) {
            loot = SAGE_LOOT_TABLE;
        }
        return loot;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EVIL_WIZARD_ARMOUR_CLASS, (Object)0);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.field_70146_Z.nextInt(10) > 2) {
            this.setElement(Element.values()[this.field_70146_Z.nextInt(Element.values().length - 1) + 1]);
        } else {
            this.setElement(Element.MAGIC);
        }
        if (this.hasStructure) {
            this.setArmourClass(this.armourClass);
        } else {
            this.setArmourClass(ItemWizardArmour.ArmourClass.values()[this.field_70146_Z.nextInt(ItemWizardArmour.ArmourClass.values().length - 1) + 1]);
        }
        Element element = this.getElement();
        for (EntityEquipmentSlot slot : InventoryUtils.ARMOUR_SLOTS) {
            this.func_184201_a(slot, new ItemStack(ItemWizardArmour.getArmour((Element)element, (ItemWizardArmour.ArmourClass)this.getArmourClass(), (EntityEquipmentSlot)slot)));
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            this.func_184642_a(slot, 0.0f);
        }
        this.spells.add(Spells.magic_missile);
        switch (this.getArmourClass()) {
            case SAGE: {
                int n = 9;
            }
            case WARLOCK: {
                int n = 6;
            }
        }
        int spellCount = 4;
        Tier maxTier = IArmourClassWizard.populateSpells((EntityLiving)this, this.spells, element, this.getArmourClass() == ItemWizardArmour.ArmourClass.SAGE, spellCount, this.field_70146_Z);
        ItemStack wand = new ItemStack(WizardryItems.getWand((Tier)maxTier, (Element)element));
        ArrayList<Spell> list = new ArrayList<Spell>(this.spells);
        list.add(Spells.heal);
        WandHelper.setSpells((ItemStack)wand, (Spell[])list.toArray(new Spell[5]));
        if (this.getArmourClass() == ItemWizardArmour.ArmourClass.BATTLEMAGE) {
            ItemStack sword = new ItemStack(ASItems.battlemage_sword_master);
            NBTTagCompound nbt = sword.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            nbt.func_74778_a("element", element.name());
            sword.func_77982_d(nbt);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, sword);
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, wand);
            this.setAITask(ItemWizardArmour.ArmourClass.BATTLEMAGE);
        } else {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, wand);
            this.setAITask(ItemWizardArmour.ArmourClass.WIZARD);
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            this.func_184642_a(slot, 0.0f);
        }
        return livingdata;
    }

    private void setAITask(ItemWizardArmour.ArmourClass armourClass) {
        if (armourClass == ItemWizardArmour.ArmourClass.BATTLEMAGE) {
            this.field_70714_bg.field_75782_a.removeIf(t -> t.field_75733_a == this.spellCastingAIImproved);
        } else {
            this.field_70714_bg.field_75782_a.removeIf(t -> t.field_75733_a == this.entityAIBattlemageSpellcasting);
            this.field_70714_bg.field_75782_a.removeIf(t -> t.field_75733_a == this.entityAIBattlemageMelee);
        }
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.values()[(Integer)this.field_70180_af.func_187225_a(EVIL_WIZARD_ARMOUR_CLASS)];
    }

    @Override
    public void setArmourClass(ItemWizardArmour.ArmourClass armourClass) {
        this.field_70180_af.func_187227_b(EVIL_WIZARD_ARMOUR_CLASS, (Object)armourClass.ordinal());
    }

    public List<Spell> getSpells() {
        return this.spells;
    }

    public ITextComponent func_145748_c_() {
        if (this.func_145818_k_()) {
            TextComponentString textcomponentstring = new TextComponentString(ScorePlayerTeam.func_96667_a((Team)this.func_96124_cp(), (String)this.func_70005_c_()));
            textcomponentstring.func_150256_b().func_150209_a(this.func_174823_aP());
            textcomponentstring.func_150256_b().func_179989_a(this.func_189512_bd());
            if (textcomponentstring == null) {
                TextComponentTranslation wizardName = new TextComponentTranslation("class_element." + this.getElement().func_176610_l() + ".wizard", new Object[0]);
                ITextComponent className = this.getArmourClassNameFor(this.getArmourClass());
                new TextComponentTranslation("entity." + this.func_70022_Q() + "_combined.name", new Object[]{wizardName, className});
            }
            return textcomponentstring;
        }
        if (this.getElement() == Element.MAGIC) {
            return this.getArmourClassNameFor(this.getArmourClass());
        }
        TextComponentTranslation wizardName = new TextComponentTranslation("class_element." + this.getElement().func_176610_l() + ".wizard", new Object[0]);
        ITextComponent className = this.getArmourClassNameFor(this.getArmourClass());
        return new TextComponentTranslation("entity." + this.func_70022_Q() + "_combined.name", new Object[]{wizardName, className});
    }

    public SpellModifiers getModifiers() {
        return this.getArmourClass() == ItemWizardArmour.ArmourClass.WARLOCK ? this.getWarlockSpellModifiers() : super.getModifiers();
    }

    private SpellModifiers getWarlockSpellModifiers() {
        SpellModifiers modifiers = new SpellModifiers();
        modifiers.set("potency", 1.4f, false);
        return modifiers;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        NBTExtras.storeTagSafely((NBTTagCompound)nbt, (String)"spells", (NBTBase)NBTExtras.listToNBT(this.spells, spell -> new NBTTagInt(spell.metadata())));
        nbt.func_74768_a("armour_class", this.getArmourClass().ordinal());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.spells = (List)NBTExtras.NBTToList((NBTTagList)nbt.func_150295_c("spells", 3), tag -> Spell.byMetadata((int)tag.func_150287_d()));
        ItemWizardArmour.ArmourClass armourClass = ItemWizardArmour.ArmourClass.values()[nbt.func_74762_e("armour_class")];
        this.setArmourClass(armourClass);
        this.setAITask(armourClass);
        if (this.hasStructure) {
            this.field_70714_bg.field_75782_a.removeIf(t -> t.field_75733_a instanceof EntityAIWander);
        }
    }
}

