/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.construct;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASPotions;
import com.windanesz.ancientspellcraft.registry.ASSounds;
import com.windanesz.ancientspellcraft.util.SpellTeleporter;
import electroblob.wizardry.entity.construct.EntityMagicConstruct;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityTransportationPortal
extends EntityMagicConstruct {
    private int targetDim;
    private BlockPos targetPos;
    private int entityTicker = 0;
    private int r = 255;
    private int g = 255;
    private int b = 255;

    public EntityTransportationPortal(World world) {
        super(world);
        this.field_70131_O = 1.0f;
        this.field_70130_N = 2.0f;
    }

    public void setTargetDim(int dim) {
        this.targetDim = dim;
    }

    public int getTargetDim() {
        return this.targetDim;
    }

    public void setTargetPos(@Nullable BlockPos pos) {
        this.targetPos = pos;
    }

    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    public void setParticleColors() {
        switch (this.targetDim) {
            case -1: {
                this.r = 162;
                this.g = 54;
                this.b = 37;
                break;
            }
            case 1: {
                this.r = 9;
                this.g = 7;
                this.b = 13;
                break;
            }
            case 7: {
                this.r = 66;
                this.g = 24;
                this.b = 141;
                break;
            }
            case 67: {
                this.r = 227;
                this.g = 206;
                this.b = 139;
                break;
            }
            default: {
                this.r = 89;
                this.g = 238;
                this.b = 155;
            }
        }
    }

    private BlockPos getRandomBlockPos(int x, int z, double radius) {
        double ang = Math.random() * 2.0 * Math.PI;
        double hyp = Math.sqrt(Math.random()) * radius;
        double adj = Math.cos(ang) * hyp;
        double opp = Math.sin(ang) * hyp;
        int xPos = (int)((double)x + adj);
        int zPos = (int)((double)z + opp);
        int yPos = this.field_70170_p.func_175672_r(new BlockPos(xPos, 0, zPos)).func_177956_o();
        return new BlockPos(xPos, yPos, zPos);
    }

    public void func_70071_h_() {
        boolean hasEntityInside;
        if (this.field_70173_aa == 3) {
            this.setParticleColors();
        }
        if (this.field_70173_aa == 20 || this.field_70173_aa % 160 == 0) {
            this.func_184185_a(ASSounds.ENTITY_TRANSPORTATION_PORTAL_AMBIENT, 0.4f, 1.0f);
        }
        List items = EntityUtils.getEntitiesWithinRadius((double)this.field_70130_N, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (World)this.field_70170_p, EntityItem.class);
        for (EntityItem entityItem : items) {
            if (!(entityItem != null & entityItem.func_92059_d().func_77973_b() == ASItems.charm_wild_catalyst)) continue;
            entityItem.func_92058_a(ItemStack.field_190927_a);
            BlockPos newPos = this.getRandomBlockPos(this.func_180425_c().func_177958_n(), this.func_180425_c().func_177952_p(), Settings.generalSettings.wild_catalyst_max_distance);
            this.setTargetPos(newPos);
        }
        List targets = EntityUtils.getEntitiesWithinRadius((double)this.field_70130_N, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (World)this.field_70170_p, EntityLivingBase.class);
        boolean bl = hasEntityInside = !targets.isEmpty();
        if (this.field_70170_p.field_72995_K) {
            double speed = (double)(this.field_70146_Z.nextBoolean() ? 1 : -1) * 0.1;
            double radius = this.field_70146_Z.nextDouble() * 2.0;
            float angle = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(this.field_70165_t, this.field_70163_u + 0.1, this.field_70161_v).face(EnumFacing.UP).clr(this.r, this.g, this.b).collide(false).scale(4.3f).time(10).spawn(this.field_70170_p);
            if (this.r != 255 || this.g != 255 || this.b != 255) {
                if (hasEntityInside) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(this.field_70165_t + radius / 3.0 * (double)MathHelper.func_76134_b((float)angle), this.field_70163_u, this.field_70161_v + radius / 3.0 * (double)MathHelper.func_76126_a((float)angle)).vel(0.0, 0.05, 0.0).scale(0.7f).time(48 + this.field_70146_Z.nextInt(12)).spin((double)(this.field_70130_N / 2.0f), speed).clr(this.r, this.g, this.b).spawn(this.field_70170_p);
                } else {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(this.field_70165_t + radius / 3.0 * (double)MathHelper.func_76134_b((float)angle), this.field_70163_u, this.field_70161_v + radius / 3.0 * (double)MathHelper.func_76126_a((float)angle)).vel(0.0, 0.05, 0.0).time(48 + this.field_70146_Z.nextInt(12)).clr(this.r, this.g, this.b).spawn(this.field_70170_p);
                }
            }
        } else if (hasEntityInside) {
            if (this.entityTicker == 50) {
                this.func_184185_a(ASSounds.TRANSPORTATION_PORTAL_TELEPORTS, 0.6f, 1.0f);
            }
            if (this.entityTicker == 90) {
                EntityLivingBase target = (EntityLivingBase)targets.get(0);
                if (this.targetPos == null || this.targetPos.func_177958_n() == 0 && this.targetPos.func_177956_o() == 0 && this.targetPos.func_177952_p() == 0) {
                    this.func_70106_y();
                    return;
                }
                if (target instanceof EntityPlayer) {
                    if (!target.func_70644_a(ASPotions.dimensional_anchor)) {
                        this.teleportPlayer((EntityPlayer)target, this.targetDim, this.targetPos);
                    }
                } else if (Settings.generalSettings.transportation_portal_teleports_any_entites && !target.func_70644_a(ASPotions.dimensional_anchor) && target.field_71093_bK == this.getTargetDim()) {
                    this.teleportEntityLiving(target, this.targetDim, this.targetPos);
                    this.func_184185_a(ASSounds.TRANSPORTATION_PORTAL_TELEPORTS, 0.6f, 1.0f);
                } else {
                    EntityUtils.applyStandardKnockback((Entity)this, (EntityLivingBase)((EntityLivingBase)targets.get(0)));
                }
            } else {
                ++this.entityTicker;
            }
        } else {
            this.entityTicker = 0;
        }
        super.func_70071_h_();
    }

    public void teleportPlayer(EntityPlayer player, int targetDim, BlockPos targetPos) {
        if (player != null) {
            SpellTeleporter.teleportEntity(targetDim, targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p(), true, player);
        }
    }

    public void teleportEntityLiving(EntityLivingBase entity, int targetDim, BlockPos targetPos) {
        if (entity != null && !entity.field_70170_p.field_72995_K) {
            SpellTeleporter.teleportEntity(entity, targetDim, targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("target_dim", this.getTargetDim());
        if (this.getTargetPos() != null) {
            nbt.func_74782_a("target_pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.getTargetPos()));
        }
        nbt.func_74768_a("r", this.r);
        nbt.func_74768_a("g", this.g);
        nbt.func_74768_a("b", this.b);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("target_dim")) {
            this.targetDim = nbt.func_74762_e("target_dim");
        }
        if (nbt.func_74764_b("target_pos")) {
            this.targetPos = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("target_pos"));
        }
        if (nbt.func_74764_b("r")) {
            this.r = nbt.func_74762_e("r");
        }
        if (nbt.func_74764_b("g")) {
            this.g = nbt.func_74762_e("g");
        }
        if (nbt.func_74764_b("b")) {
            this.b = nbt.func_74762_e("b");
        }
    }

    public boolean func_90999_ad() {
        return false;
    }
}

