/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.ai;

import com.windanesz.ancientspellcraft.data.SpellCategorization;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.packet.PacketNPCCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityAIAttackSpellImproved<T extends EntityLiving>
extends EntityAIBase {
    private final T entity;
    private final double moveSpeedAmp;
    private int attackCooldown;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private int timeSinceDisengage = 0;
    protected final T attacker;
    protected EntityLivingBase target;
    protected int cooldown = -1;
    private final int baseCooldown;
    private int continuousSpellTimer;
    private final int continuousSpellDuration;
    private final double speed;

    public EntityAIAttackSpellImproved(T attacker, double speed, float maxDistance, int baseCooldown, int continuousSpellDuration) {
        this.attacker = attacker;
        this.baseCooldown = baseCooldown;
        this.continuousSpellDuration = continuousSpellDuration;
        this.speed = speed;
        this.func_75248_a(3);
        this.entity = attacker;
        this.moveSpeedAmp = speed;
        this.attackCooldown = continuousSpellDuration;
        this.maxAttackDistance = maxDistance * maxDistance;
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null || entitylivingbase.field_70128_L || entitylivingbase.field_71093_bK != ((EntityLiving)this.attacker).field_71093_bK) {
            return false;
        }
        this.target = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.attacker.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.target = null;
        this.seeTime = 0;
        this.cooldown = -1;
        this.setContinuousSpellAndNotify(Spells.none, new SpellModifiers());
        this.continuousSpellTimer = 0;
    }

    private void setContinuousSpellAndNotify(Spell spell, SpellModifiers modifiers) {
        ((ISpellCaster)this.attacker).setContinuousSpell(spell);
        WizardryPacketHandler.net.sendToAllAround((IMessage)new PacketNPCCastSpell.Message(this.attacker.func_145782_y(), this.target == null ? -1 : this.target.func_145782_y(), EnumHand.MAIN_HAND, spell, modifiers), new NetworkRegistry.TargetPoint(((EntityLiving)this.attacker).field_71093_bK, ((EntityLiving)this.attacker).field_70165_t, ((EntityLiving)this.attacker).field_70163_u, ((EntityLiving)this.attacker).field_70161_v, 128.0));
    }

    public void func_75246_d() {
        double distanceSq = this.attacker.func_70092_e(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v);
        boolean targetIsVisible = this.attacker.func_70635_at().func_75522_a((Entity)this.target);
        this.seeTime = targetIsVisible ? ++this.seeTime : 0;
        if (distanceSq <= (double)this.maxAttackDistance && this.seeTime >= 20) {
            this.attacker.func_70661_as().func_75499_g();
        } else {
            this.attacker.func_70661_as().func_75497_a((Entity)this.target, this.speed);
        }
        this.attacker.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        if (this.continuousSpellTimer > 0) {
            --this.continuousSpellTimer;
            if (distanceSq > (double)this.maxAttackDistance || !targetIsVisible || MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(SpellCastEvent.Source.NPC, ((ISpellCaster)this.attacker).getContinuousSpell(), this.attacker, ((ISpellCaster)this.attacker).getModifiers(), this.continuousSpellDuration - this.continuousSpellTimer)) || !((ISpellCaster)this.attacker).getContinuousSpell().cast(((EntityLiving)this.attacker).field_70170_p, this.attacker, EnumHand.MAIN_HAND, this.continuousSpellDuration - this.continuousSpellTimer, this.target, ((ISpellCaster)this.attacker).getModifiers()) || this.continuousSpellTimer == 0) {
                this.continuousSpellTimer = 0;
                this.cooldown = ((ISpellCaster)this.attacker).getContinuousSpell().getCooldown() + this.baseCooldown;
                this.setContinuousSpellAndNotify(Spells.none, new SpellModifiers());
                return;
            }
            if (this.continuousSpellDuration - this.continuousSpellTimer == 1) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.NPC, ((ISpellCaster)this.attacker).getContinuousSpell(), this.attacker, ((ISpellCaster)this.attacker).getModifiers()));
            }
        } else if (--this.cooldown == 0) {
            if (distanceSq > (double)this.maxAttackDistance || !targetIsVisible) {
                return;
            }
            double dx = this.target.field_70165_t - ((EntityLiving)this.attacker).field_70165_t;
            double dz = this.target.field_70161_v - ((EntityLiving)this.attacker).field_70161_v;
            ArrayList<Spell> spells = new ArrayList<Spell>(((ISpellCaster)this.attacker).getSpells());
            if (spells.size() > 0 && !((EntityLiving)this.attacker).field_70170_p.field_72995_K) {
                while (!spells.isEmpty()) {
                    Spell spell = EntityAIAttackSpellImproved.selectSpellConditionally(((EntityLiving)this.attacker).field_70170_p, this.attacker, this.target, spells);
                    SpellModifiers modifiers = ((ISpellCaster)this.attacker).getModifiers();
                    if (spell != null && this.attemptCastSpell(spell, modifiers)) {
                        ((EntityLiving)this.attacker).field_70177_z = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                        SpellCategorization.SpellCategory category = SpellCategorization.getCategoryFor(spell);
                        if (category == SpellCategorization.SpellCategory.CLOSE_COMBAT || category == SpellCategorization.SpellCategory.DISENGAGE) {
                            this.timeSinceDisengage = 60;
                        }
                        return;
                    }
                    spells.remove(spell);
                }
            }
        } else if (this.cooldown < 0) {
            this.cooldown = this.baseCooldown;
        }
        EntityLivingBase target = this.entity.func_70638_az();
        if (this.timeSinceDisengage == 0) {
            if (target != null) {
                boolean flag1;
                double d0 = this.entity.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v);
                boolean flag = this.entity.func_70635_at().func_75522_a((Entity)target);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (d0 <= (double)this.maxAttackDistance * 0.5 && this.seeTime >= 20) {
                    this.entity.func_70661_as().func_75499_g();
                    ++this.strafingTime;
                } else {
                    this.entity.func_70661_as().func_75497_a((Entity)target, this.moveSpeedAmp);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.45f : 0.45f, this.strafingClockwise ? 0.3f : -0.3f);
                    this.entity.func_70625_a((Entity)target, 30.0f, 30.0f);
                } else {
                    this.entity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                }
            }
        } else {
            --this.timeSinceDisengage;
        }
    }

    private boolean attemptCastSpell(Spell spell, SpellModifiers modifiers) {
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.NPC, spell, this.attacker, modifiers))) {
            return false;
        }
        if (spell.cast(((EntityLiving)this.attacker).field_70170_p, this.attacker, EnumHand.MAIN_HAND, 0, this.target, modifiers)) {
            if (spell.isContinuous) {
                this.continuousSpellTimer = this.continuousSpellDuration - 1;
                this.setContinuousSpellAndNotify(spell, modifiers);
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.NPC, spell, this.attacker, modifiers));
                LinkedList spellPreferenceQueue = new LinkedList();
                float healthRatio = this.attacker.func_110143_aJ() / this.attacker.func_110138_aP();
                this.cooldown = healthRatio <= 0.5f ? (int)((double)this.baseCooldown + (double)spell.getCooldown() * 0.5) : (healthRatio <= 0.25f ? (int)((double)this.baseCooldown + (double)spell.getCooldown() * 0.1) : this.baseCooldown + spell.getCooldown());
                if (spell.requiresPacket()) {
                    PacketNPCCastSpell.Message msg = new PacketNPCCastSpell.Message(this.attacker.func_145782_y(), this.target.func_145782_y(), EnumHand.MAIN_HAND, spell, modifiers);
                    WizardryPacketHandler.net.sendToDimension((IMessage)msg, ((EntityLiving)this.attacker).field_70170_p.field_73011_w.getDimension());
                }
            }
            this.attacker.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 30, 3));
            return true;
        }
        return false;
    }

    public static Spell selectSpellConditionally(World world, EntityLivingBase caster, EntityLivingBase target, List<Spell> spells) {
        if (!spells.isEmpty()) {
            Spell spellToPick = Spells.none;
            double closeCombatDistance = 3.0;
            double criticalHealthFactor = 0.45f;
            LinkedList<SpellCategorization.SpellCategory> spellPreferenceQueue = new LinkedList<SpellCategorization.SpellCategory>();
            double distanceSq = caster.func_70011_f(target.field_70165_t, target.field_70163_u, target.field_70161_v);
            float t = caster.func_110143_aJ() / caster.func_110138_aP();
            if ((double)t <= criticalHealthFactor) {
                spellPreferenceQueue.add(SpellCategorization.SpellCategory.LIFE_SAVING);
            }
            if (distanceSq <= closeCombatDistance) {
                spellPreferenceQueue.add(SpellCategorization.SpellCategory.DISENGAGE);
                spellPreferenceQueue.add(SpellCategorization.SpellCategory.DISABLE);
                spellPreferenceQueue.add(SpellCategorization.SpellCategory.CLOSE_COMBAT);
            } else {
                spellPreferenceQueue.add(SpellCategorization.SpellCategory.RANGED_ATTACK);
            }
            ArrayList<Spell> spellList = new ArrayList<Spell>(spells);
            Collections.shuffle(spellList);
            block0: while (spellToPick == Spells.none && !spellPreferenceQueue.isEmpty()) {
                SpellCategorization.SpellCategory category = (SpellCategorization.SpellCategory)((Object)spellPreferenceQueue.remove());
                for (Spell currSpell : spellList) {
                    if (category != SpellCategorization.getCategoryFor(currSpell)) continue;
                    spellToPick = currSpell;
                    continue block0;
                }
            }
            if (spellToPick == Spells.none || spellToPick == Spells.magic_missile && world.field_73012_v.nextBoolean()) {
                return spells.get(world.field_73012_v.nextInt(spells.size()));
            }
            return spellToPick;
        }
        return Spells.none;
    }
}

