/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.client.gui;

import com.windanesz.ancientspellcraft.client.gui.ContainerSphereCognizance;
import com.windanesz.ancientspellcraft.item.ItemRelic;
import com.windanesz.ancientspellcraft.packet.ASPacketHandler;
import com.windanesz.ancientspellcraft.packet.PacketControlInput;
import com.windanesz.ancientspellcraft.tileentity.TileSphereCognizance;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiSphereCognizance
extends GuiContainer {
    private GuiButton researchButton;
    int currentHintId = 0;
    int currentHintTypeId = 0;
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("ancientspellcraft", "textures/gui/container/gui_sphere_cognizance.png");
    private String tooltipLangKey = "";
    private int researchCost = 1;
    private TileSphereCognizance tileSphere;
    private IInventory playerInv;

    public GuiSphereCognizance(EntityPlayer player, IInventory playerInv, TileSphereCognizance te) {
        super((Container)new ContainerSphereCognizance(player, playerInv, te));
        this.tileSphere = te;
        this.playerInv = playerInv;
        this.field_146999_f = 176;
        this.field_147000_g = 241;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.researchButton = new GuiButtonApply(0, this.field_146294_l / 2 + 57, this.field_146295_m / 2 + 6);
        this.field_146292_n.add(this.researchButton);
        this.researchButton.field_146124_l = false;
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        Slot crystalSlot = this.field_147002_h.func_75139_a(ContainerSphereCognizance.CRYSTAL_SLOT);
        Slot bookSlot = this.field_147002_h.func_75139_a(ContainerSphereCognizance.BOOK_SLOT);
        this.researchButton.field_146124_l = false;
        if (!bookSlot.func_75216_d()) {
            this.researchButton.field_146124_l = false;
            this.tooltipLangKey = "no_book";
        } else if (!crystalSlot.func_75216_d()) {
            this.tooltipLangKey = "no_crystal";
            this.researchButton.field_146124_l = false;
        } else if (bookSlot.func_75211_c().func_77973_b() instanceof ItemSpellBook || bookSlot.func_75211_c().func_77973_b() instanceof ItemScroll) {
            if (this.tileSphere.getCurrentSpell() != null && this.tileSphere.getPlayerWizardData() != null) {
                Spell spell = this.tileSphere.getCurrentSpell();
                if (!this.tileSphere.getPlayerWizardData().hasSpellBeenDiscovered(spell)) {
                    this.researchCost = this.tileSphere.getResearchCost(spell);
                    if (crystalSlot.func_75211_c().func_190916_E() >= this.researchCost) {
                        this.researchButton.field_146124_l = true;
                        this.tooltipLangKey = "research";
                    } else {
                        this.researchButton.field_146124_l = false;
                        this.tooltipLangKey = "too_few_crystals";
                    }
                } else {
                    this.researchButton.field_146124_l = false;
                    this.tooltipLangKey = "known_item";
                }
            }
        } else if (bookSlot.func_75211_c().func_77973_b() instanceof ItemRelic) {
            if (!ItemRelic.isResearched(bookSlot.func_75211_c())) {
                this.researchButton.field_146124_l = true;
                this.tooltipLangKey = "research";
            } else {
                this.researchButton.field_146124_l = false;
                this.tooltipLangKey = "known_book";
            }
        } else {
            this.researchButton.field_146124_l = false;
            this.tooltipLangKey = "no_book";
        }
    }

    private void drawMultilineHintText(String unlocalizedText) {
        this.drawMultilineHintText(unlocalizedText, null);
    }

    private void drawMultilineHintText(String unlocalizedText, Spell spell) {
        List localizedTextList = spell == null ? this.field_146289_q.func_78271_c(I18n.func_135052_a((String)unlocalizedText, (Object[])new Object[0]), 104) : this.field_146289_q.func_78271_c(I18n.func_135052_a((String)unlocalizedText, (Object[])new Object[]{spell.getDisplayName()}), 104);
        int lineCount = localizedTextList.size();
        int offset = (lineCount - 1) * 7;
        int i = 0;
        for (String text : localizedTextList) {
            this.func_73732_a(this.field_146289_q, text, 87, 70 - offset + i, 0xFFFFFF);
            i += 10;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int scale = this.getResearchProgressScaled(76);
        this.func_73729_b(this.field_147003_i + 51, this.field_147009_r + 106, 176, 0, scale, 5);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 0 && button.field_146124_l) {
            PacketControlInput.Message msg = new PacketControlInput.Message(PacketControlInput.ControlType.APPLY_BUTTON);
            ASPacketHandler.net.sendToServer((IMessage)msg);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)WizardrySounds.BLOCK_ARCANE_WORKBENCH_SPELLBIND, (float)1.0f));
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        try {
            String unlocalizedText;
            this.currentHintTypeId = this.tileSphere.func_174887_a_(2);
            this.currentHintId = this.tileSphere.func_174887_a_(3);
            if (this.currentHintTypeId == 1) {
                unlocalizedText = "gui.ancientspellcraft:sphere_cognizance.hint.failed." + this.currentHintId;
                this.drawMultilineHintText(unlocalizedText);
            } else if (this.currentHintTypeId == 2 && this.tileSphere.getCurrentSpell() != null) {
                unlocalizedText = "gui.ancientspellcraft:sphere_cognizance.hint.discovered." + this.currentHintId;
                this.drawMultilineHintText(unlocalizedText, this.tileSphere.getCurrentSpell());
            } else if (this.currentHintTypeId != 0 && this.currentHintId != 0) {
                String hintTypeName = ContainerSphereCognizance.HINT_TYPES.get(this.currentHintTypeId);
                String unlocalizedText2 = "gui.ancientspellcraft:sphere_cognizance.hint." + hintTypeName + "." + this.currentHintId;
                this.drawMultilineHintText(unlocalizedText2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (GuiButton guibutton : this.field_146292_n) {
            if (!guibutton.func_146115_a()) continue;
            guibutton.func_146111_b(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            break;
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverLayPost(RenderGameOverlayEvent.Post event) {
    }

    private int getResearchProgressScaled(int pixels) {
        int researchProgress = this.tileSphere.func_174887_a_(0);
        int researchDuration = this.tileSphere.func_174887_a_(1);
        return researchDuration != 0 && researchProgress != 0 ? researchProgress * 76 / researchDuration : 0;
    }

    private class GuiButtonApply
    extends GuiButton {
        public GuiButtonApply(int id, int x, int y) {
            super(id, x, y, 16, 16, I18n.func_135052_a((String)"container.ebwizardry:arcane_workbench.apply", (Object[])new Object[0]));
        }

        public void func_191745_a(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int k = 176;
            int l = 7;
            boolean t = false;
            if (this.field_146124_l) {
                if (this.field_146123_n) {
                    t = true;
                    k += this.field_146120_f * 2;
                }
            } else {
                k += this.field_146120_f;
            }
            DrawingUtils.drawTexturedRect((int)this.field_146128_h, (int)this.field_146129_i, (int)k, (int)l, (int)this.field_146120_f, (int)this.field_146121_g, (int)256, (int)256);
        }

        public void func_146111_b(int mouseX, int mouseY) {
            if (GuiSphereCognizance.this.tooltipLangKey.equals("too_few_crystals")) {
                GuiSphereCognizance.this.func_146279_a(I18n.func_135052_a((String)("gui.ancientspellcraft:sphere_cognizance." + GuiSphereCognizance.this.tooltipLangKey), (Object[])new Object[]{GuiSphereCognizance.this.researchCost}), mouseX, mouseY);
            } else {
                GuiSphereCognizance.this.func_146279_a(I18n.func_135052_a((String)("gui.ancientspellcraft:sphere_cognizance." + GuiSphereCognizance.this.tooltipLangKey), (Object[])new Object[0]), mouseX, mouseY);
            }
        }
    }
}

