/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.client.gui;

import com.windanesz.ancientspellcraft.item.ItemRunicPlate;
import com.windanesz.ancientspellcraft.spell.Runeword;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.spell.Spell;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GuiRunicPlate
extends GuiScreen {
    protected static final String TRANSLATION_KEY_PREFIX = "gui.ebwizardry:spell_book";
    protected final int xSize;
    protected final int ySize;
    private ItemRunicPlate plate;
    private Spell spell;
    protected int textureWidth = 512;
    protected int textureHeight = 256;

    public GuiRunicPlate(ItemStack stack) {
        this.xSize = 150;
        this.ySize = 180;
        if (!(stack.func_77973_b() instanceof ItemRunicPlate)) {
            throw new ClassCastException("Cannot create runic plate GUI for item that does not extend ItemRunicPlate!");
        }
        this.plate = (ItemRunicPlate)stack.func_77973_b();
        this.spell = Spell.byMetadata((int)stack.func_77952_i());
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int left = this.field_146294_l / 2 - this.xSize / 2;
        int top = this.field_146295_m / 2 - this.ySize / 2;
        this.func_146276_q_();
        this.drawBackgroundLayer(left, top, mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawForegroundLayer(left, top, mouseX, mouseY);
    }

    protected void drawForegroundLayer(int left, int top, int mouseX, int mouseY) {
        boolean discovered = Wizardry.proxy.shouldDisplayDiscovered(this.getSpell(), null);
        if (discovered) {
            this.field_146289_q.func_78276_b(this.getSpell().getDisplayName(), left + 24, top + 30, 3943492);
            if (this.getSpell().hasProperty("charges")) {
                int charges = this.getSpell().getProperty("charges").intValue();
                String chargesString = I18n.func_135052_a((String)"gui.ancientspellcraft:runic_plate.charges", (Object[])new Object[]{charges});
                this.field_146289_q.func_78276_b(chargesString, left + 24, top + 57, 3943492);
            } else if (((Runeword)this.getSpell()).isPassive()) {
                this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.ancientspellcraft:runic_plate.passive", (Object[])new Object[0]), left + 24, top + 57, 3943492);
            }
        } else {
            this.field_146297_k.field_71464_q.func_78276_b(SpellGlyphData.getGlyphName((Spell)this.getSpell(), (World)this.field_146297_k.field_71441_e), left + 24, top + 30, 0);
            this.field_146297_k.field_71464_q.func_78276_b(this.getSpell().getType().getDisplayName(), left + 24, top + 26, 3943492);
        }
        String tier = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.tier", (Object[])new Object[]{this.getSpell().getTier() == Tier.NOVICE ? "\u00a77" + this.getSpell().getTier().getDisplayName() : this.getSpell().getTier().getDisplayNameWithFormatting()});
        this.field_146289_q.func_78276_b(tier, left + 24, top + 45, 3943492);
        String manaCost = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.mana_cost", (Object[])new Object[]{this.getSpell().getCost()});
        if (this.getSpell().isContinuous) {
            manaCost = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.mana_cost_continuous", (Object[])new Object[]{this.getSpell().getCost()});
        }
        if (!discovered) {
            manaCost = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.mana_cost_undiscovered", (Object[])new Object[0]);
        }
        this.field_146289_q.func_78276_b(manaCost, left + 24, top + 69, 3943492);
        if (discovered) {
            this.field_146289_q.func_78279_b(this.getSpell().getDescription(), left + 24, top + 83, 110, 3943492);
        } else {
            this.field_146297_k.field_71464_q.func_78279_b(SpellGlyphData.getGlyphDescription((Spell)this.getSpell(), (World)this.field_146297_k.field_71441_e), left + 24, top + 83, 110, 3943492);
        }
    }

    protected void drawBackgroundLayer(int left, int top, int mouseX, int mouseY) {
        boolean discovered = Wizardry.proxy.shouldDisplayDiscovered(this.getSpell(), null);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTexture());
        DrawingUtils.drawTexturedRect((int)left, (int)top, (int)0, (int)0, (int)this.xSize, (int)this.ySize, (int)this.textureWidth, (int)this.textureHeight);
    }

    public boolean func_73868_f() {
        return Wizardry.settings.booksPauseGame;
    }

    public Spell getSpell() {
        return this.spell;
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation("ancientspellcraft", "textures/gui/runic_plate.png");
    }
}

