/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.capability;

import com.windanesz.ancientspellcraft.util.ASUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class DeathMarkCapability
implements INBTSerializable<NBTTagCompound> {
    public static final String CASTER_UUID_TAG = "casterUUID";
    @CapabilityInject(value=DeathMarkCapability.class)
    private static final Capability<DeathMarkCapability> DEATH_MARK_CAPABILITY = null;
    private final EntityLivingBase entity;
    protected UUID casterUUID;

    public DeathMarkCapability() {
        this(null);
    }

    public DeathMarkCapability(EntityLivingBase entity) {
        this.entity = entity;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(DeathMarkCapability.class, (Capability.IStorage)new Capability.IStorage<DeathMarkCapability>(){

            public NBTBase writeNBT(Capability<DeathMarkCapability> capability, DeathMarkCapability instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<DeathMarkCapability> capability, DeathMarkCapability instance, EnumFacing side, NBTBase nbt) {
            }
        }, DeathMarkCapability::new);
    }

    public static DeathMarkCapability get(EntityLivingBase entity) {
        return (DeathMarkCapability)entity.getCapability(DEATH_MARK_CAPABILITY, null);
    }

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityCreature) {
            event.addCapability(new ResourceLocation("ancientspellcraft", "DeathMarkCapability"), (ICapabilityProvider)new Provider((EntityLivingBase)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        UUID casterUUID;
        if (event.getEntity() instanceof EntityLivingBase && event.getEntity().hasCapability(DEATH_MARK_CAPABILITY, null) && DeathMarkCapability.get((EntityLivingBase)event.getEntityLiving()).casterUUID != null && event.getEntity().field_70170_p.func_152378_a(casterUUID = DeathMarkCapability.get((EntityLivingBase)event.getEntityLiving()).casterUUID) != null) {
            ASUtils.sendMessage((Entity)event.getEntity().field_70170_p.func_152378_a(casterUUID), "spell.ancientspellcraft:death_mark.entity_death_message", false, event.getEntity().func_145748_c_());
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.casterUUID != null) {
            NBTTagCompound casterUUID = new NBTTagCompound();
            casterUUID.func_186854_a(CASTER_UUID_TAG, this.getCasterId());
            nbt.func_74782_a(CASTER_UUID_TAG, (NBTBase)casterUUID);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(CASTER_UUID_TAG)) {
            this.setCasterId(nbt.func_74775_l(CASTER_UUID_TAG).func_186857_a(CASTER_UUID_TAG));
        }
    }

    public void setCaster(@Nullable EntityLivingBase caster) {
        this.setCasterId(caster == null ? null : caster.func_110124_au());
    }

    public UUID getCasterId() {
        return this.casterUUID;
    }

    public void setCasterId(UUID uuid) {
        this.casterUUID = uuid;
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final DeathMarkCapability capability;

        public Provider(EntityLivingBase entity) {
            this.capability = new DeathMarkCapability(entity);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == DEATH_MARK_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == DEATH_MARK_CAPABILITY) {
                return (T)DEATH_MARK_CAPABILITY.cast((Object)this.capability);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return this.capability.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.capability.deserializeNBT(nbt);
        }
    }
}

