/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemArtefact;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="ancientspellcraft", name="AncientSpellcraft")
public class Settings {
    public ResourceLocation[] lootInjectionLocations;
    public ResourceLocation[] artefactInjectionLocations;
    public ResourceLocation[] voidCreeperBiomeBlacklist;
    public List<ResourceLocation> shardEarthShardBiomeWhitelist;
    public List<ResourceLocation> shardSorceryShardBiomeWhitelist;
    public List<ResourceLocation> shardNecromancyShardBiomeWhitelist;
    public List<ResourceLocation> shardHealingBiomeWhitelist;
    public List<ResourceLocation> shardLightningBiomeWhitelist;
    public List<ResourceLocation> shardFireBiomeWhitelist;
    public List<ResourceLocation> shardIceBiomeWhitelist;
    public ResourceLocation[] battlemageCampWithChestFiles;
    public ResourceLocation[] battlemageKeepWithChestFiles;
    public ResourceLocation[] sageHillWithChestFiles;
    public ResourceLocation[] ancientVaultFiles;
    public ResourceLocation[] ancientTempleFiles;
    @Config.Name(value="General Settings")
    @Config.LangKey(value="settings.ancientspellcraft:general_settings")
    public static GeneralSettings generalSettings = new GeneralSettings();
    @Config.Name(value="Client Settings")
    @Config.LangKey(value="settings.ancientspellcraft:client_settings")
    public static ClientSettings clientSettings = new ClientSettings();
    @Config.Name(value="Spell Compat Settings")
    @Config.LangKey(value="settings.ancientspellcraft:spell_compat_settings")
    public static SpellCompatSettings spellCompatSettings = new SpellCompatSettings();
    @Config.Name(value="Worldgen Settings")
    @Config.LangKey(value="settings.ancientspellcraft:worldgen_settings")
    public static WorldgenSettings worldgenSettings = new WorldgenSettings();

    public Settings() {
        this.lootInjectionLocations = electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.DEFAULT_LOOT_INJECTION_LOCATIONS);
        this.artefactInjectionLocations = electroblob.wizardry.Settings.toResourceLocations((String[])generalSettings.ARTEFACT_INJECTION_LOCATIONS);
        this.voidCreeperBiomeBlacklist = electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.void_creeper_biome_blacklist);
        this.shardEarthShardBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.earth_shard_biome_whitelist));
        this.shardSorceryShardBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.sorcery_shard_biome_whitelist));
        this.shardNecromancyShardBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.necromancy_shard_biome_whitelist));
        this.shardHealingBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.healing_shard_biome_whitelist));
        this.shardLightningBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.lightning_shard_biome_whitelist));
        this.shardFireBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.fire_shard_biome_whitelist));
        this.shardIceBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.ice_shard_biome_whitelist));
        this.battlemageCampWithChestFiles = new ResourceLocation[]{new ResourceLocation("ancientspellcraft", "battlemage_camp_chest_0")};
        this.battlemageKeepWithChestFiles = new ResourceLocation[]{new ResourceLocation("ancientspellcraft", "battlemage_keep_chest_0")};
        this.sageHillWithChestFiles = new ResourceLocation[]{new ResourceLocation("ancientspellcraft", "sage_hill_chest_0")};
        this.ancientVaultFiles = new ResourceLocation[]{new ResourceLocation("ancientspellcraft", "ancient_vault_1")};
        this.ancientTempleFiles = new ResourceLocation[]{new ResourceLocation("ancientspellcraft", "ancient_temple_0")};
    }

    public static boolean isArtefactEnabled(Item artefact) {
        if (artefact instanceof ItemArtefact && Wizardry.settings.getConfigCategory("artefacts").containsKey(artefact.getRegistryName().toString())) {
            return Wizardry.settings.getConfigCategory("artefacts").get(artefact.getRegistryName().toString()).getBoolean();
        }
        return true;
    }

    public static class WorldgenSettings {
        @Config.Name(value="Battlemage Camp Dimensions")
        @Config.Comment(value={"[Server-only] List of dimension ids in which to spawn battlemage camps."})
        @Config.RequiresMcRestart
        public int[] battlemageCampDimensions = new int[]{0};
        @Config.Name(value="Battlemage Camp Rarity")
        @Config.Comment(value={"[Server-only] The rarity of battlemage camps, used by the world generator. Larger numbers are rarer."})
        @Config.RequiresMcRestart
        public int battlemageCampRarity = 1800;
        @Config.Name(value="Battlemage Keep Dimensions")
        @Config.Comment(value={"[Server-only] List of dimension ids in which to spawn battlemage keeps."})
        @Config.RequiresMcRestart
        public int[] battlemageKeepDimensions = new int[]{0};
        @Config.Name(value="Ancient Vault Dimensions")
        @Config.Comment(value={"[Server-only] List of dimension ids in which to spawn Ancient Vault."})
        @Config.RequiresMcRestart
        public int[] ancientVaultDimensions = new int[]{0};
        @Config.Name(value="Battlemage Keep Rarity")
        @Config.Comment(value={"[Server-only] The rarity of battlemage keeps, used by the world generator. Larger numbers are rarer."})
        @Config.RequiresMcRestart
        public int battlemageKeepRarity = 2000;
        @Config.Name(value="Sage hill Dimensions")
        @Config.Comment(value={"[Server-only] List of dimension ids in which to spawn the sage hill structures."})
        @Config.RequiresMcRestart
        public int[] sageHillDimensions = new int[]{0};
        @Config.Name(value="Sage hill Rarity")
        @Config.Comment(value={"[Server-only] The rarity of the sage hill structure, used by the world generator. Larger numbers are rarer."})
        @Config.RequiresMcRestart
        public int sageHillRarity = 2000;
        @Config.Name(value="Ancient Vault Structure")
        @Config.Comment(value={"[Server-only] The rarity of the ancient vault and others (e.g. ancient temple) structures, used by the world generator. Larger numbers are rarer."})
        @Config.RequiresMcRestart
        public int ancientVaultRarity = 2500;
    }

    public static class SpellCompatSettings {
        @Config.Name(value="Mine Spell Override")
        @Config.Comment(value={"If enabled, Ancient Spellcraft will override the base Wizardry mod's Mine spell to add compatibility to the Fortune related artefact.Disabling this feature will cause the game to load the default Mine spell class which can be helpful if you are having issues, but it also makes the Circlet of Fortune artefact useless!"})
        @Config.RequiresMcRestart
        public boolean mineSpellOverride = true;
        @Config.Name(value="Mine Spell Network ID")
        @Config.Comment(value={"WARNING! Don't change this value unless you are told you so, otherwise your world won't start! \nThe reason this value exists as a settings is to provide a quick way to fix compatibility (until the A.S. update is released to fix it) if the network ID of the spell is changed by an EBWiz update. \nThis could possibly happen if new spells are added by the base mod and the NetworkIDs shift."})
        @Config.RequiresMcRestart
        public int mineSpellNetworkID = 141;
        @Config.Name(value="Charge Spell Network ID")
        @Config.Comment(value={"WARNING! Don't change this value unless you are told you so, otherwise your world won't start! \nThe reason this value exists as a settings is to provide a quick way to fix compatibility (until the A.S. update is released to fix it) if the network ID of the spell is changed by an EBWiz update. \nThis could possibly happen if new spells are added by the base mod and the NetworkIDs shift."})
        @Config.RequiresMcRestart
        public int chargeSpellNetworkID = 147;
        @Config.Name(value="Charge Spell Override")
        @Config.Comment(value={"If enabled, Ancient Spellcraft will override the base Wizardry mod's Charge spell to add compatibility for the related artefact.\nDisabling this feature will cause the game to load the default Charge spell class which can be helpful if you are having issues, but it also makes the related artefact useless!"})
        @Config.RequiresMcRestart
        public boolean chargeSpellOverride = true;
        @Config.Name(value="Conjure Pickaxe Spell Override")
        @Config.Comment(value={"If enabled, Ancient Spellcraft will override the base Wizardry mod's Conjure Pickaxe spell to add compatibility to the Fortune related artefact.\nDisabling this feature will cause the game to load the default Conjure Pickaxe spell class which can be helpful if you are having issues, but it also makes the Circlet of Fortune artefact useless!"})
        @Config.RequiresMcRestart
        public boolean conjurePickaxeSpellOverride = true;
        @Config.Name(value="Conjure Pickaxe Spell Network ID")
        @Config.Comment(value={"WARNING! Don't change this value unless you are told you so, otherwise your world won't start! \nThe reason this value exists as a settings is to provide a quick way to fix compatibility (until the A.S. update is released to fix it) if the network ID of the spell is changed by an EBWiz update.\nThis could possibly happen if new spells are added by the base mod and the NetworkIDs shift."})
        @Config.RequiresMcRestart
        public int conjurePickaxeSpellNetworkID = 41;
    }

    public static class ClientSettings {
        @Config.Name(value="Show Contingency HUD")
        @Config.Comment(value={"Whether to show the contingency HUD when there are active spell Contingencies."})
        @Config.RequiresMcRestart
        public boolean show_contingency_hud = true;
        @Config.Name(value="Clips Mouse To Hud")
        @Config.Comment(value={"Clips the mouse to the hud, possibly allowing faster spell selection."})
        @Config.RequiresMcRestart
        public boolean clip_mouse_to_circle = true;
        @Config.Name(value="Contingency HUD Left Side Position")
        @Config.Comment(value={"Whether to show the contingency HUD on the left side of the screen (defaults to right side)."})
        @Config.RequiresMcRestart
        public boolean contingency_hud_left_side_position = true;
        @Config.Name(value="Radial Spell Menu Enabled")
        @Config.Comment(value={"If true, you can open the radial spell selector menu with the configured key. Otherwise you must click on a spell to select it."})
        public boolean radial_menu_enabled = true;
        @Config.Name(value="Release To Swap")
        @Config.Comment(value={"If true, the hovered spell will be selected when you release the radial GUI button while having the cursor over a spell."})
        public boolean release_to_swap = true;
    }

    public static class GeneralSettings {
        @Config.Name(value="JEI integration")
        @Config.Comment(value={"Enables or disables the JEI integration of the mod"})
        @Config.RequiresMcRestart
        public boolean jei_integration = true;
        @Config.Name(value="ArtemisLib integration")
        @Config.Comment(value={"Enables or disables the ArtemisLib integration of the mod"})
        @Config.RequiresMcRestart
        public boolean artemislib_integration = true;
        @Config.Name(value="Antique Atlas Integration")
        @Config.Comment(value={"Enables or disables the Antique Atlas integration of the mod"})
        @Config.RequiresMcRestart
        public boolean antique_atlas_integration = true;
        @Config.Name(value="Battlemage Camp Map Markers")
        @Config.Comment(value={"[Server-only] Controls whether AS automatically places antique atlas markers at the locations of battlemage camps"})
        public boolean auto_battlemage_camp_markers = true;
        @Config.Name(value="Battlemage Keep Map Markers")
        @Config.Comment(value={"[Server-only] Controls whether AS automatically places antique atlas markers at the locations of battlemage keeps"})
        public boolean auto_battlemage_keep_markers = true;
        @Config.Name(value="Ancient Vault Map Markers")
        @Config.Comment(value={"[Server-only] Controls whether AS automatically places antique atlas markers at the locations of ancient vaults"})
        public boolean ancient_vault_markers = true;
        @Config.Name(value="Generate Crystal Ore Shards")
        @Config.Comment(value={"Determines whether to generate elemental crystal shards in the Overworld or not"})
        @Config.RequiresMcRestart
        public boolean generate_ore_shards = true;
        @Config.Name(value="Generate Devoritium Ore")
        @Config.Comment(value={"Determines whether to generate devoritium ore blocks in the Overworld or not"})
        @Config.RequiresMcRestart
        public boolean generate_devoritium_ore = true;
        @Config.Name(value="Sphere Spell Identify Chance")
        @Config.Comment(value={"The chance of identifying unknown spells when researching them with the Sphere of Cognizance. This doesn't affects the other hint texts given by the Sphere. 0 = never identify a spell, 1.0 = always"})
        @Config.RequiresMcRestart
        public double sphere_spell_identification_chance = 0.05;
        @Config.Name(value="Loot Inject Locations")
        @Config.Comment(value={"List of loot tables to inject Ancient Spellcraft loot (as specified in loot_tables/chests/dungeon_additions.json) into. This currently includes stuff like Stone Tablets."})
        public String[] DEFAULT_LOOT_INJECTION_LOCATIONS = new String[]{"ebwizardry:chests/wizard_tower", "ebwizardry:chests/shrine", "ebwizardry:chests/obelisk", "minecraft:chests/desert_pyramid", "minecraft:chests/jungle_temple", "minecraft:chests/stronghold_corridor", "minecraft:chests/stronghold_crossing", "minecraft:chests/stronghold_library", "minecraft:chests/igloo_chest", "minecraft:chests/woodland_mansion", "minecraft:chests/end_city_treasure"};
        @Config.Name(value="Artefact Inject locations")
        @Config.Comment(value={"List of loot tables to inject Ancient Spellcraft artefacts into."})
        private String[] ARTEFACT_INJECTION_LOCATIONS = new String[]{"ebwizardry:subsets/uncommon_artefacts", "ebwizardry:subsets/rare_artefacts", "ebwizardry:subsets/epic_artefacts"};
        @Config.Name(value="Extension Spell Potion Blacklist")
        @Config.Comment(value={"List of potion effect which cannot be extended with the Extension sage spell."})
        public String[] extension_spell_blacklist = new String[0];
        @Config.Name(value="Expertiment Debuff Blacklist")
        @Config.Comment(value={"List of negative potion effect which cannot occur as a side effect of the Experiment spell. Must be in a 'modid:potion_registry_name' format."})
        public String[] experiment_debuff_blacklist = new String[0];
        @Config.Name(value="Expertiment Buff Blacklist")
        @Config.Comment(value={"List of postive potion effect which cannot occur as a side effect of the Experiment spell. Must be in a 'modid:potion_registry_name' format."})
        public String[] experiment_buff_blacklist = new String[0];
        @Config.Name(value="Essence Extraction Screen Shake")
        @Config.Comment(value={"Determines whether to the Essence Extraction spell shakes the screen while extracting powerful blocks or not."})
        @Config.RequiresMcRestart
        public boolean shake_screen = true;
        @Config.Name(value="Baubles Integration")
        @Config.Comment(value={"Enable/Disable Baubles integration for the new artefact types (belt, helm, etc). This does NOT affect Electroblob's Wizardry's own Baubles support implementation (ring, amulet, charm)!"})
        @Config.RequiresMcRestart
        public boolean baubles_integration = true;
        @Config.Name(value="Void Creeper Spawn Rate")
        @Config.Comment(value={"Spawn rate for naturally-spawned void creepers; higher numbers mean more void creepers will spawn. Set to 0 do disable spawning entirely"})
        @Config.RequiresMcRestart
        public int void_creeper_spawn_rate = 2;
        @Config.Name(value="Class Armour Evil Wizard Spawn Rate")
        @Config.Comment(value={"Spawn rate for naturally-spawned class (sage, warlock, battlemage) wizards; higher numbers mean more wizards will spawn.\n5 is equivalent to witches, 100 is equivalent to zombies, skeletons and creepers.\nSet to 0 to disable evil wizard spawning entirely."})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0, max=100)
        public int evil_class_wizard_spawn_rate = 2;
        @Config.Name(value="Spellblade base damage")
        @Config.Comment(value={"The base damage of spellblades, not accounting for the tiers"})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=1, max=32)
        public int spellblade_base_damage = 2;
        @Config.Name(value="Spellblade damage increase per tier")
        @Config.Comment(value={"The damage increase per tier of the spellblade"})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=1, max=6)
        public int spellblade_damage_increase_per_tier = 1;
        @Config.Name(value="Spellblade charge progress per spellcast")
        @Config.Comment(value={"The amount of charge received for each spellcasts with the spellblade"})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0, max=100)
        public int spellblade_charge_gain_per_spellcast = 20;
        @Config.Name(value="Spellblade charge progress per hit")
        @Config.Comment(value={"The amount of charge received for each hit with the spellblade"})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0, max=100)
        public int spellblade_charge_gain_per_hit = 5;
        @Config.Name(value="Spellblade base hit mana cost per tier")
        @Config.Comment(value={"The amount of mana required & consumed when the spellblade is used to hit a target, based on the tier of the blade\nExample: if the cost is 5, a novice blade will consume 5 mana, an apprentice sword will consume 2x5 mana, a master blade will consume 20 mana"})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=1, max=100)
        public int spellblade_base_mana_cost = 5;
        @Config.Name(value="Orb Artefact Potency Percent Bonus")
        @Config.Comment(value={"Determines the potency bonus of the elemental orb artefacts in a percentage value"})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0, max=100)
        public int orb_artefact_potency_bonus = 30;
        @Config.Name(value="Void Creeper Biome Blacklist")
        @Config.Comment(value={"List of Biomes where Void Creepers will never spawn."})
        @Config.RequiresMcRestart
        public String[] void_creeper_biome_blacklist = new String[]{"mushroom_island", "mushroom_island_shore"};
        @Config.Name(value="Void Creeper Dimension Whitelist")
        @Config.Comment(value={"List of Dimensions where Void Creepers are allowed to spawn. Defaults to Overworld only.\n make"})
        @Config.RequiresMcRestart
        public Integer[] void_creeper_dimension_whitelist = new Integer[]{0};
        @Config.Name(value="Elemental Fire Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Fire Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] fire_shard_biome_whitelist = new String[]{"desert", "desert_hills", "mutated_desert"};
        @Config.Name(value="Elemental Earth Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Earth Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] earth_shard_biome_whitelist = new String[]{"forest", "birch_forest", "roofed_forest"};
        @Config.Name(value="Elemental Sorcery Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Sorcery Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] sorcery_shard_biome_whitelist = new String[]{"plains", "mutated_plains"};
        @Config.Name(value="Elemental Necromancy Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Necromancy Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] necromancy_shard_biome_whitelist = new String[]{"swampland", "mutated_swampland"};
        @Config.Name(value="Elemental Healing Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Healing Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] healing_shard_biome_whitelist = new String[]{"jungle", "jungle_hills", "jungle_edge"};
        @Config.Name(value="Elemental Lightning Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Lightning Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] lightning_shard_biome_whitelist = new String[]{"extreme_hills", "smaller_extreme_hills", "extreme_hills_with_trees", "mutated_extreme_hills", "mutated_extreme_hills_with_trees"};
        @Config.Name(value="Elemental Ice Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Ice Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] ice_shard_biome_whitelist = new String[]{"taiga", "taiga_hills", "taiga_cold", "taiga_cold_hills", "mutated_taiga", "mutated_taiga_cold"};
        @Config.Name(value="[UNUSED] Pocket Biome registry ID")
        @Config.Comment(value={"Allows you to change the pocket biome registry ID if you encounter biome ID conflicts"})
        @Config.RequiresMcRestart
        public int pocket_biome_registry_id = 168;
        @Config.Name(value="Immobility Contingency Spell Trigger Effects")
        @Config.Comment(value={"List of potion effects which can be considered as an immobilizing effect. Receiving one of these will trigger the stored Contingency - Immobility spell"})
        @Config.RequiresMcRestart
        public String[] immobility_contingency_effects = new String[]{"ebwizardry:paralysis", "ebwizardry:containment", "ebwizardry:slow_time", "ebwizardry:frost", "minecraft:slowness"};
        @Config.Name(value="Duplication Scroll Additonal Items")
        @Config.Comment(value={"List of registry names (in a 'modid:itemname' format) of additional items that can be duplicated by the Scroll of Duplication"})
        @Config.RequiresMcRestart
        public String[] duplication_scroll_additional_items = new String[0];
        @Config.Name(value="Wizards Buy Ancient Element Books")
        @Config.Comment(value={"If true, friendly Wizards will buy ancient element books (the gray ones)"})
        @Config.RequiresMcRestart
        public boolean wizards_buy_ancient_element_books = true;
        @Config.Name(value="Wizards Buy Ancient Spellcraft Spell Books")
        @Config.Comment(value={"If true, friendly Wizards will buy ancient spellcraft element books (the blue/dark books)"})
        @Config.RequiresMcRestart
        public boolean wizards_buy_ancient_spellcraft_books = true;
        @Config.Name(value="Wizards Buy Ancient Spellcraft Ritual Books")
        @Config.Comment(value={"If true, friendly Wizards will buy ancient spellcraft ritual books"})
        @Config.RequiresMcRestart
        public boolean wizards_buy_ancient_spellcraft_ritual_books = true;
        @Config.Name(value="Enable Wizard Entity Changes")
        @Config.Comment(value={"If true, A.S. will alter the wizard entities to inject into their trade list. Disable if you are having issues related to this feature."})
        @Config.RequiresMcRestart
        public boolean apply_wizard_entity_changes = true;
        @Config.Name(value="Transportation Portal Teleports Any Entites")
        @Config.Comment(value={"If true, Transportation Portals can transport non-player entities. If false, only players can use the portal."})
        public boolean transportation_portal_teleports_any_entites = true;
        @Config.Name(value="Sage Lectern Allowed Item List")
        @Config.Comment(value={"List of item registry names that are allowed to be placed on the sage lectern. Each entry has a format of 'modid:item_name', example: antiqueatlas:antique_atlas. All spell books are allowed by default, without listing them.NOTE that this probably won't work with many items as they expect the player to hold the item in their hand to function, so only experiment with this in a testworld."})
        @Config.RequiresMcRestart
        public String[] sage_lectern_item_whitelist = new String[]{"ancientspellcraft:empty_mystic_spell_book", "antiqueatlas:antique_atlas", "minecraft:writable_book", "minecraft:written_book", "minecraft:book", "minecraft:enchanted_book"};
        @Config.Name(value="Sage Tome Required Enchanted Pages Per Tier")
        @Config.Comment(value={"The required amount of Enchanted Pages to progress a Sage Tome to the next tier."})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=1, max=100)
        public int sage_tome_enchanted_page_requirement = 2;
        @Config.Name(value="Sage Tome Required Enchanted Pages Per Tier Multiplier")
        @Config.Comment(value={"Works in conjunction with \"Sage Tome Required Enchanted Pages Per Tier\".This is basically a multiplier, to require more and more Enchanted Pages for each tier. If set to 0, all tiers will require the amount of Enchanted Pages defined in \"Sage Tome Required Enchanted Pages Per Tier\".The formula: (\"Sage Tome Required Enchanted Pages Per Tier\") * (this multiplier) * (tierNumber (1->3, Apprentice->Master))"})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0, max=10)
        public int sage_tome_enchanted_page_requirement_multiplier = 2;
        @Config.Name(value="Potency Gain from Sage Tome Empowerment Upgade Scrolls")
        @Config.Comment(value={""})
        @Config.RequiresMcRestart
        @Config.RangeDouble(min=0.0, max=10.0)
        public double empowerment_upgrade_potency_gain = 0.05f;
        @Config.Name(value="Wild Catalyst max distance ")
        @Config.Comment(value={"[Server-only] The max destination distance in blocks where the Wild Catalyst artefact can redirect Transportation Portals."})
        @Config.RequiresMcRestart
        public int wild_catalyst_max_distance = 10000;
    }

    @Mod.EventBusSubscriber(modid="ancientspellcraft")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("ancientspellcraft")) {
                ConfigManager.sync((String)"ancientspellcraft", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

