/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.vanilla;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.mods.adlods.vanilla.VanillaOre;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class VanillaGen {
    protected final Path configsDir;
    protected final EnumMap<OreGenEvent.GenerateMinable.EventType, VanillaOre> vanillaOres = new EnumMap(OreGenEvent.GenerateMinable.EventType.class);

    public VanillaGen(Path configsDir) {
        this.configsDir = configsDir;
    }

    public void loadOres() {
        this.vanillaOres.clear();
        for (OreGenEvent.GenerateMinable.EventType oreType : OreGenEvent.GenerateMinable.EventType.values()) {
            String name = oreType.name().toLowerCase(Locale.ROOT);
            UnitConfig config = new UnitConfig(this.configsDir, name);
            VanillaOre ore = new VanillaOre(config);
            this.vanillaOres.put(oreType, ore);
        }
    }

    @SubscribeEvent
    public void onGenerateMinable(OreGenEvent.GenerateMinable event) {
        VanillaOre ore = this.vanillaOres.get(event.getType());
        if (ore == null) {
            return;
        }
        if (ore.isEnabled() && ore.inAllowableDimenstion(event.getWorld()) && ore.inAllowableBiome(event.getWorld(), event.getPos())) {
            return;
        }
        event.setResult(Event.Result.DENY);
    }
}

