/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.ForgeWorld;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class Stripper {
    protected static final Map<World, Stripper> strippers = new ConcurrentHashMap<World, Stripper>();
    protected final Map<ChunkPos, IBlockState[][][]> strippedChunks = new ConcurrentHashMap<ChunkPos, IBlockState[][][]>();

    public static Stripper getFor(World world) {
        Stripper stripper = strippers.get(world);
        if (stripper == null) {
            stripper = new Stripper();
            strippers.put(world, stripper);
        }
        return stripper;
    }

    @SubscribeEvent
    public static void onWorldUnloaded(WorldEvent.Unload event) {
        strippers.remove(event.getWorld());
    }

    public void stripChunk(World world, ChunkPos chunkPos, BiPredicate<World, BlockPos> isOreBlock) {
        if (this.strippedChunks.containsKey(chunkPos)) {
            return;
        }
        IBlockState[][][] data = new IBlockState[16][ChunkBounds.DEFAULT_HEIGHT][16];
        ChunkBounds bounds = ChunkBounds.from((ChunkPos)chunkPos);
        bounds.forEach(pos -> {
            BlockPos rel = bounds.relative((BlockPos)pos);
            IBlockState state = world.func_180495_p((BlockPos)pos);
            if (pos.func_177956_o() <= 0 || ForgeWorld.isAirBlock((IBlockState)state) || isOreBlock.test(world, (BlockPos)pos)) {
                return;
            }
            data[rel.func_177958_n()][rel.func_177956_o()][rel.func_177952_p()] = state;
            world.func_180501_a((BlockPos)pos, Blocks.field_150350_a.func_176223_P(), 2);
        });
        this.strippedChunks.put(chunkPos, data);
    }

    public void stripChunksAround(World world, ChunkPos centerPos, BiPredicate<World, BlockPos> isOreBlock) {
        for (ChunkPos chunkPos : ForgeWorld.Position.getAroundHoriz((ChunkPos)centerPos, (boolean)true, (ChunkPos[])new ChunkPos[]{centerPos})) {
            this.stripChunk(world, chunkPos, isOreBlock);
        }
    }

    public void dressChunk(World world, ChunkPos chunkPos) {
        this.dressChunk(world, chunkPos, true);
    }

    public void dressChunksAround(World world, ChunkPos centerPos) {
        for (ChunkPos chunkPos : ForgeWorld.Position.getAroundHoriz((ChunkPos)centerPos, (boolean)true, (ChunkPos[])new ChunkPos[]{centerPos})) {
            this.dressChunk(world, chunkPos);
        }
    }

    public void dressAllChunks(World world) {
        for (ChunkPos chunkPos : this.strippedChunks.keySet()) {
            this.dressChunk(world, chunkPos, false);
        }
        this.strippedChunks.clear();
    }

    protected void dressChunk(World world, ChunkPos chunkPos, boolean removeEntry) {
        if (!this.strippedChunks.containsKey(chunkPos)) {
            return;
        }
        IBlockState[][][] data = this.strippedChunks.get(chunkPos);
        ChunkBounds bounds = ChunkBounds.from((ChunkPos)chunkPos);
        bounds.forEach(pos -> {
            BlockPos rel = bounds.relative((BlockPos)pos);
            IBlockState state = data[rel.func_177958_n()][rel.func_177956_o()][rel.func_177952_p()];
            if (state != null) {
                world.func_180501_a((BlockPos)pos, state, 2);
            }
        });
        if (removeEntry) {
            this.strippedChunks.remove(chunkPos);
        }
    }
}

