/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.motion.realistic;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.mods.adhooks.motion.realistic.RealisticTarget;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Deprecated
public class RealisticController {
    protected static final Map<Entity, RealisticTarget> serverTargets = new ConcurrentHashMap<Entity, RealisticTarget>();
    protected static final Map<Entity, RealisticTarget> clientTargets = new ConcurrentHashMap<Entity, RealisticTarget>();

    public static Optional<RealisticTarget> getTarget(Entity entity) {
        return Optional.ofNullable(RealisticController.findTarget(entity));
    }

    public static RealisticTarget getOrCreateTarget(Entity entity) {
        RealisticTarget target = RealisticController.findTarget(entity);
        if (target == null) {
            target = RealisticController.createTarget(entity);
        }
        return target;
    }

    protected static RealisticTarget createTarget(Entity entity) {
        RealisticTarget target = new RealisticTarget(entity);
        if (ForgeEntity.isServerSide((Entity)entity)) {
            serverTargets.put(entity, target);
        } else {
            clientTargets.put(entity, target);
        }
        return target;
    }

    @Nullable
    protected static RealisticTarget findTarget(Entity entity) {
        if (ForgeEntity.isServerSide((Entity)entity)) {
            return serverTargets.get(entity);
        }
        return clientTargets.get(entity);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        Collection<RealisticTarget> targets = serverTargets.values();
        if (event.phase == TickEvent.Phase.END) {
            RealisticController.applyTo(targets);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Collection<RealisticTarget> targets = clientTargets.values();
        if (event.phase == TickEvent.Phase.END) {
            RealisticController.applyTo(targets);
        }
    }

    @SubscribeEvent
    public static void onEntityJump(LivingEvent.LivingJumpEvent event) {
        RealisticController.getTarget(event.getEntity()).ifPresent(target -> {
            target.jumpTicksLeft = 10;
        });
    }

    protected static void applyTo(Collection<RealisticTarget> targets) {
        Iterator<RealisticTarget> iterator = targets.iterator();
        while (iterator.hasNext()) {
            RealisticTarget target = iterator.next();
            if (target.hasSources()) {
                target.applyMotion();
                continue;
            }
            iterator.remove();
        }
    }
}

