/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.aireducer.routine;

import com.charles445.aireducer.ai.AIAvoidReduced;
import com.charles445.aireducer.config.ModConfig;
import com.charles445.aireducer.reflect.ReflectorMinecraft;
import com.charles445.aireducer.routine.Routine;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;

public class AvoidRoutine
extends Routine {
    @Override
    public boolean canRun() {
        return ModConfig.vanilla.avoidTaskReplacement && ReflectorMinecraft.reflector != null;
    }

    protected EntityAIBase constructAvoid(EntityCreature entity, Class<?> classToAvoid, Predicate<?> avoidTargetSelector, float avoidDistance, double farSpeed, double nearSpeed) {
        return new AIAvoidReduced(entity, classToAvoid, avoidTargetSelector, avoidDistance, farSpeed, nearSpeed){

            @Override
            public boolean getRadiusConfig() {
                return ModConfig.vanilla.avoidTaskReplacement;
            }
        };
    }

    @Override
    protected void run(EntityLiving entity, String domain, String path) {
        if (entity instanceof EntityCreature) {
            this.findAndReplaceAvoids((EntityCreature)entity);
        }
    }

    private void findAndReplaceAvoids(EntityCreature entityIn) {
        int count = this.tryAndReplaceAllTasks((EntityLiving)entityIn, entityIn.field_70714_bg, EntityAIAvoidEntity.class, (Function<EntityAITasks.EntityAITaskEntry, EntityAIBase>)((Function)oldTaskEntry -> {
            try {
                Class classToAvoid = (Class)ReflectorMinecraft.reflector.f_EntityAIAvoidEntity_classToAvoid.get(oldTaskEntry.field_75733_a);
                Predicate avoidTargetSelector = (Predicate)ReflectorMinecraft.reflector.f_EntityAIAvoidEntity_avoidTargetSelector.get(oldTaskEntry.field_75733_a);
                float avoidDistance = ((Float)ReflectorMinecraft.reflector.f_EntityAIAvoidEntity_avoidDistance.get(oldTaskEntry.field_75733_a)).floatValue();
                double farSpeed = (Double)ReflectorMinecraft.reflector.f_EntityAIAvoidEntity_farSpeed.get(oldTaskEntry.field_75733_a);
                double nearSpeed = (Double)ReflectorMinecraft.reflector.f_EntityAIAvoidEntity_nearSpeed.get(oldTaskEntry.field_75733_a);
                EntityCreature entity = (EntityCreature)ReflectorMinecraft.reflector.f_EntityAIAvoidEntity_entity.get(oldTaskEntry.field_75733_a);
                return this.constructAvoid(entity, classToAvoid, avoidTargetSelector, avoidDistance, farSpeed, nearSpeed);
            }
            catch (Exception e) {
                return null;
            }
        }));
    }
}

