/*
 * Decompiled with CFR 0.152.
 */
package net.elnounch.mc.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.function.Consumer;
import net.elnounch.mc.utils.Version;
import net.elnounch.mc.utils.VersionRange;

public class VersionFilteredReader {
    private Version version;
    private Consumer<String> fn;

    public VersionFilteredReader(String v, Consumer<String> f) {
        this.version = new Version(v);
        this.fn = f;
    }

    public void ingest(URL source) throws IOException {
        BufferedInputStream definitions = new BufferedInputStream(source.openStream());
        boolean matchingVersion = false;
        StringBuilder reading = new StringBuilder();
        int input = definitions.read();
        while (input != -1) {
            switch (input) {
                case 10: 
                case 13: {
                    String line = reading.toString().replaceAll("\\s*(//.*)?$", "");
                    if (line.length() > 0) {
                        if (line.startsWith("--")) {
                            matchingVersion = false;
                        } else if (line.startsWith("\t")) {
                            if (matchingVersion) {
                                this.fn.accept(line.substring(1));
                            }
                        } else {
                            VersionRange spec = VersionRange.createFromVersionSpec(line);
                            matchingVersion = matchingVersion || spec.containsVersion(this.version);
                        }
                    }
                    reading.setLength(0);
                    break;
                }
                default: {
                    reading.append((char)input);
                }
            }
            input = definitions.read();
        }
    }
}

