/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.util.catenation;

import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IWorld;
import java.util.LinkedList;
import java.util.Queue;
import youyihj.zenutils.api.util.catenation.Catenation;
import youyihj.zenutils.api.util.catenation.ICatenationBuilder;
import youyihj.zenutils.api.util.catenation.ICatenationTask;
import youyihj.zenutils.api.util.catenation.IWorldCondition;
import youyihj.zenutils.api.util.catenation.IWorldFunction;
import youyihj.zenutils.impl.util.catenation.CatenationManager;
import youyihj.zenutils.impl.util.catenation.InstantTask;
import youyihj.zenutils.impl.util.catenation.SleepTask;
import youyihj.zenutils.impl.util.catenation.SleepUntilTask;

public class CatenationBuilder
implements ICatenationBuilder {
    private final IWorld world;
    private final Queue<ICatenationTask> tasks = new LinkedList<ICatenationTask>();
    private IWorldCondition stopWhen;

    public CatenationBuilder(IWorld world) {
        this.world = world;
    }

    @Override
    public ICatenationBuilder addTask(ICatenationTask task) {
        this.tasks.add(task);
        return this;
    }

    @Override
    public ICatenationBuilder run(IWorldFunction function) {
        return this.addTask(new InstantTask(function));
    }

    @Override
    public ICatenationBuilder sleep(long ticks) {
        return this.addTask(new SleepTask(ticks));
    }

    @Override
    public ICatenationBuilder sleepUntil(IWorldCondition condition) {
        return this.addTask(new SleepUntilTask(condition));
    }

    @Override
    public ICatenationBuilder stopWhen(IWorldCondition condition) {
        this.stopWhen = condition;
        return this;
    }

    @Override
    public Catenation start() {
        Catenation catenation = new Catenation(this.tasks, this.stopWhen);
        CatenationManager.addCatenation(CraftTweakerMC.getWorld((IWorld)this.world), catenation);
        return catenation;
    }
}

