/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.ftbq;

import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;

@ZenRegister
@ZenClass(value="mods.zenutils.ftbq.QuestObjectBase")
@ModOnly(value="ftbquests")
public class CTQuestObjectBase {
    public final QuestObjectBase object;

    public CTQuestObjectBase(QuestObjectBase object) {
        this.object = object;
    }

    @ZenGetter(value="parentID")
    public int getParentID() {
        return this.object.getParentID();
    }

    @ZenGetter(value="data")
    public IData getData() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.object.writeData(nbt);
        return CraftTweakerMC.getIData((NBTBase)nbt);
    }

    @ZenGetter(value="title")
    public String getTitle() {
        return this.object.getTitle();
    }

    @ZenGetter(value="id")
    public int getID() {
        return this.object.id;
    }

    @ZenGetter(value="icon")
    public IItemStack getIcon() {
        return CraftTweakerMC.getIItemStack((ItemStack)this.object.icon);
    }

    @ZenGetter(value="codeString")
    public String getCodeString() {
        return this.object.getCodeString();
    }

    @ZenGetter(value="type")
    public String getType() {
        return this.object.getObjectType().name();
    }

    @ZenGetter(value="tags")
    public String[] getTags() {
        return this.object.getTags().toArray(new String[0]);
    }

    @ZenMethod
    public boolean hasTag(String tag) {
        return this.object.hasTag(tag);
    }

    @ZenOperator(value=OperatorType.EQUALS)
    public boolean equals(CTQuestObjectBase others) {
        if (others == null) {
            return false;
        }
        return this.object.equals((Object)others.object);
    }
}

