/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.m_guide.client;

import com.valkyrieofnight.vlib.core.util.client.LangUtil;
import com.valkyrieofnight.vliblegacy.ValkyrieLib;
import com.valkyrieofnight.vliblegacy.base.client.GuiHandler;
import com.valkyrieofnight.vliblegacy.lib.client.gui.VLGuiResources;
import com.valkyrieofnight.vliblegacy.lib.client.gui.VLGuiScreen;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.VLElement;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.VLElementIndex;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.button.VLButtonIcon;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.container.VLContScissorPane;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.sizablebox.VLElementGuiSizableBox;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.sizablebox.VLElementSizablePanel;
import com.valkyrieofnight.vliblegacy.lib.client.util.GridAlignment;
import com.valkyrieofnight.vliblegacy.lib.util.core.NetworkUtil;
import com.valkyrieofnight.vliblegacy.m_guide.client.ModGuideEntry;
import com.valkyrieofnight.vliblegacy.m_guide.client.elements.ButtonMetro;
import com.valkyrieofnight.vliblegacy.m_guide.client.elements.ModGuide;
import com.valkyrieofnight.vliblegacy.m_guide.client.network.PacketSaveGuide;
import com.valkyrieofnight.vliblegacy.m_guide.item.ItemGuide;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;

public class GuiGuide
extends VLGuiScreen {
    protected static List<ModGuideEntry> GUIDE_ENTRIES = new ArrayList<ModGuideEntry>();
    VLGuiResources GR;
    private VLButtonIcon patreon;
    private VLButtonIcon twitter;
    private VLButtonIcon discord;
    private VLButtonIcon curseforge;
    private VLButtonIcon twitch;
    private VLButtonIcon youtube;
    private VLButtonIcon github;
    private VLButtonIcon home;
    private VLButtonIcon next;
    private VLButtonIcon prev;
    private VLButtonIcon up;
    private VLButtonIcon down;
    private VLElementIndex guideIndex;
    private MainMenu mainMenu;
    private GridAlignment grid = new GridAlignment(120, 56, 4, 4, 3, GridAlignment.Alignment.VERTICAL);
    protected EntityPlayer player;
    ModGuide cmg;

    public static void addGuide(ModGuideEntry guideEntry) {
        if (guideEntry != null) {
            GUIDE_ENTRIES.add(guideEntry);
        }
    }

    public GuiGuide(EntityPlayer player) {
        this();
        this.player = player;
        this.loadFromHeld();
    }

    public GuiGuide() {
        int guiWidth = 384;
        int guiHeight = 212;
        this.func_183500_a(guiWidth, guiHeight);
        this.addElement(new VLElementGuiSizableBox("bg", VLGuiResources.GUI_STYLE_6));
        this.addElement(new VLElementSizablePanel("screenbg", VLGuiResources.METRO_CC_BLACK, 4, 4, 376, 184));
        int iy = guiHeight - 20;
        this.patreon = new VLButtonIcon("patreon", 4, iy, 16, 16, VLGuiResources.LOGO_PATREON_NAVY_WHITE);
        this.addElement(this.patreon);
        this.patreon.setBg(VLGuiResources.METRO_PATREON_CORAL);
        this.patreon.setIconMo(VLGuiResources.LOGO_PATREON_CORAL_WHITE);
        this.patreon.setBgMo(VLGuiResources.METRO_PATREON_NAVY);
        this.patreon.setBgDisabled(VLGuiResources.METRO_A_GRAY);
        this.patreon.addToolTip(LangUtil.toLoc("guide.valkyrielib.button.patreon"));
        this.twitter = new VLButtonIcon("twitter", 24, iy, 16, 16, VLGuiResources.LOGO_TWITTER_WHITE);
        this.addElement(this.twitter);
        this.twitter.addToolTip(LangUtil.toLoc("guide.valkyrielib.button.twitter"));
        this.twitter.setBg(VLGuiResources.METRO_TWITTER_BLUE);
        this.twitter.setBgMo(VLGuiResources.METRO_A_WHITE);
        this.twitter.setIconMo(VLGuiResources.LOGO_TWITTER_BLUE);
        this.discord = new VLButtonIcon("discord", 44, iy, 16, 16, VLGuiResources.LOGO_DISCORD_WHITE);
        this.addElement(this.discord);
        this.discord.setBg(VLGuiResources.METRO_DISCORD_BURPLE);
        this.discord.setIconMo(VLGuiResources.LOGO_DISCORD_BLUE);
        this.discord.setBgMo(VLGuiResources.METRO_A_WHITE);
        this.discord.addToolTip(LangUtil.toLoc("guide.valkyrielib.button.discord"));
        this.curseforge = new VLButtonIcon("curseforge", 64, iy, 16, 16, VLGuiResources.LOGO_CURSEFORGE);
        this.addElement(this.curseforge);
        this.curseforge.setBg(VLGuiResources.METRO_CURSEFORGE_GREEN);
        this.curseforge.setBgMo(VLGuiResources.METRO_CURSEFORGE_ORANGE);
        this.curseforge.setBgDisabled(VLGuiResources.METRO_A_GRAY);
        this.curseforge.addToolTip(LangUtil.toLoc("guide.valkyrielib.button.curseforge"));
        this.twitch = new VLButtonIcon("twitch", 84, iy, 16, 16, VLGuiResources.LOGO_TWITCH_WHITE);
        this.addElement(this.twitch);
        this.twitch.setBg(VLGuiResources.METRO_TWITCH_PURPLE);
        this.twitch.setBgMo(VLGuiResources.METRO_A_WHITE);
        this.twitch.setIconMo(VLGuiResources.LOGO_TWITCH_PURPLE);
        this.twitch.addToolTip(LangUtil.toLoc("guide.valkyrielib.button.twitch"));
        this.github = new VLButtonIcon("github", 104, iy, 16, 16, VLGuiResources.LOGO_GITHUB_WHITE);
        this.addElement(this.github);
        this.github.setBg(VLGuiResources.METRO_A_BLACK);
        this.github.setBgMo(VLGuiResources.METRO_A_WHITE);
        this.github.setIconMo(VLGuiResources.LOGO_GITHUB_BLACK);
        this.github.addToolTip(LangUtil.toLoc("guide.valkyrielib.button.github"));
        int hx = guiWidth / 2 - 8;
        this.home = new VLButtonIcon("home", hx, iy, 16, 16, VLGuiResources.METRO_HOME_WHITE);
        this.addElement(this.home);
        this.home.addToolTip(LangUtil.toLoc("gui.valkyrielib.home"));
        this.home.setBg(VLGuiResources.METRO_DISCORD_GRAY);
        this.home.setBgMo(VLGuiResources.METRO_A_LIGHT_BLUE);
        int px = hx - 20;
        this.prev = new VLButtonIcon("prev", px, iy, 16, 16, VLGuiResources.METRO_PREV_WHITE);
        this.addElement(this.prev);
        this.prev.addToolTip(LangUtil.toLoc("gui.valkyrielib.prev"));
        this.prev.setBg(VLGuiResources.METRO_DISCORD_GRAY);
        this.prev.setBgMo(VLGuiResources.METRO_A_LIGHT_BLUE);
        int nx = hx + 20;
        this.next = new VLButtonIcon("next", nx, iy, 16, 16, VLGuiResources.METRO_NEXT_WHITE);
        this.addElement(this.next);
        this.next.addToolTip(LangUtil.toLoc("gui.valkyrielib.next"));
        this.next.setBg(VLGuiResources.METRO_DISCORD_GRAY);
        this.next.setBgMo(VLGuiResources.METRO_A_LIGHT_BLUE);
        this.guideIndex = new VLElementIndex("mainindex"){

            @Override
            public void init() {
            }

            @Override
            public void onElementResize(VLElement ele) {
            }
        };
        this.addElement(this.guideIndex);
        int xScroll = guiWidth - 4;
        this.up = new VLButtonIcon("up", xScroll - 8, iy, 8, 8, VLGuiResources.METRO_UP_WHITE);
        this.addElement(this.up);
        this.up.addToolTip(LangUtil.toLoc("gui.valkyrielib.scrollup"));
        this.up.setBg(VLGuiResources.METRO_DISCORD_GRAY);
        this.up.setBgMo(VLGuiResources.METRO_A_LIGHT_BLUE);
        this.down = new VLButtonIcon("down", xScroll - 8, iy + 8, 8, 8, VLGuiResources.METRO_DOWN_WHITE);
        this.addElement(this.down);
        this.down.addToolTip(LangUtil.toLoc("gui.valkyrielib.scrolldown"));
        this.down.setBg(VLGuiResources.METRO_DISCORD_GRAY);
        this.down.setBgMo(VLGuiResources.METRO_A_LIGHT_BLUE);
        this.mainMenu = new MainMenu(this, "mainmenu", 376, 184);
        this.guideIndex.addIndex(this.mainMenu);
        this.guideIndex.setIndex("mainmenu");
        this.mainMenu.setXPosOffset(4);
        this.mainMenu.setYPosOffset(4);
        Collections.sort(GUIDE_ENTRIES);
        for (ModGuideEntry cl : GUIDE_ENTRIES) {
            ModGuide mg = cl.getModGuide();
            mg.setGuidePageSize(this.mainMenu.getXSize(), this.mainMenu.getYSize());
            this.addModGuide(mg);
        }
    }

    @Override
    public void onCloseExecution() {
        GuiHandler.getInstance().returnToLast();
    }

    public void loadFromHeld() {
        ItemStack held = this.player.func_184586_b(EnumHand.MAIN_HAND);
        if (!(held.func_77973_b() instanceof ItemGuide)) {
            held = this.player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (!(held.func_77973_b() instanceof ItemGuide)) {
            return;
        }
        NBTTagCompound nbt = held.func_77978_p();
        if (nbt == null) {
            return;
        }
        NBTTagCompound data = nbt.func_74775_l("guide_data");
        this.readFromNBT(data);
    }

    public void loadFromString(String mod, String page, int yScroll) {
        String nbt = "{mainindex:{x_scroll:0,y_scroll:" + yScroll + ",index:" + mod + "," + mod + ":{index:{index:" + page + "}}}}";
        try {
            NBTTagCompound data = JsonToNBT.func_180713_a((String)nbt);
            this.readFromNBT(data);
        }
        catch (NBTException e) {
            e.printStackTrace();
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        ValkyrieLib.DISPATCHER.sendToServer(new PacketSaveGuide(this, this.player));
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.cmg == null) {
            VLElement t = this.guideIndex.getCurrentIndex();
            this.cmg = t instanceof ModGuide ? (ModGuide)t : null;
        } else if (this.guideIndex.getCurrentIndex() == this.mainMenu) {
            this.cmg = null;
        }
        if (this.cmg != null) {
            this.next.setEnabled(this.cmg.hasNext());
            this.prev.setEnabled(this.cmg.hasPrev());
        } else if (this.guideIndex.getCurrentIndex() == this.mainMenu) {
            this.next.setEnabled(false);
            this.prev.setEnabled(false);
        }
    }

    @Override
    public void mouseClicked(VLElement ele, int mx, int my, int mouseButton) {
        if (mouseButton != 0) {
            return;
        }
        if (this.patreon == ele) {
            NetworkUtil.openLink("https://www.patreon.com/ValkyrieofNight");
        } else if (this.twitter == ele) {
            NetworkUtil.openLink("https://twitter.com/ValkyrieofNight");
        } else if (this.discord == ele) {
            NetworkUtil.openLink("https://discord.gg/5qzseB3");
        } else if (this.curseforge == ele) {
            NetworkUtil.openLink("https://www.curseforge.com/members/ValkyrieofNight/projects");
        } else if (this.twitch == ele) {
            NetworkUtil.openLink("https://www.twitch.tv/valkyrieofnight");
        } else if (this.github == ele) {
            NetworkUtil.openLink("https://github.com/ValkyrieofNight");
        }
        if (this.prev == ele) {
            ModGuide mg;
            if (this.guideIndex.getCurrentIndex() != null && this.guideIndex.getCurrentIndex() instanceof ModGuide && (mg = (ModGuide)this.guideIndex.getCurrentIndex()).hasPrev()) {
                mg.prev();
            }
        } else if (this.home == ele) {
            ModGuide mg;
            if (this.guideIndex.getCurrentIndex() != null && this.guideIndex.getCurrentIndex() instanceof ModGuide && (mg = (ModGuide)this.guideIndex.getCurrentIndex()).home()) {
                this.guideIndex.setIndex(this.mainMenu.getID());
            }
        } else if (this.next == ele) {
            ModGuide mg;
            if (this.guideIndex.getCurrentIndex() != null && this.guideIndex.getCurrentIndex() instanceof ModGuide && (mg = (ModGuide)this.guideIndex.getCurrentIndex()).hasNext()) {
                mg.next();
            }
        } else if (this.up == ele) {
            if (this.guideIndex.getCurrentIndex() != null && this.guideIndex.getCurrentIndex() instanceof ModGuide) {
                ModGuide mg = (ModGuide)this.guideIndex.getCurrentIndex();
                mg.addYScroll(this.field_146295_m / 3);
            }
        } else if (this.down == ele) {
            if (this.guideIndex.getCurrentIndex() != null && this.guideIndex.getCurrentIndex() instanceof ModGuide) {
                ModGuide mg = (ModGuide)this.guideIndex.getCurrentIndex();
                mg.addYScroll(-this.field_146295_m / 3);
            }
        } else if (ele instanceof ButtonMetro) {
            this.setGuide(ele.getID());
        }
    }

    protected void setGuide(String guide) {
        VLElement g = this.guideIndex.getIndex(guide);
        if (g instanceof ModGuide) {
            ModGuide mg = (ModGuide)g;
            this.guideIndex.setIndex(guide);
        }
    }

    @Override
    public void mouseScrolled(VLElement ele, int mx, int my, int scroll) {
    }

    @Override
    public void keyTyped(VLElement ele, char character, int keyCode) {
    }

    public void addMainMenuButton(ButtonMetro button) {
        button.setPos(4 + this.grid.getCurrentXOffset(), 4 + this.grid.getCurrentYOffset());
        this.grid.next();
        this.mainMenu.addElement(button);
        this.mainMenu.setScrollMin(0, 0);
        this.mainMenu.setScrollMax(0, 2000);
    }

    public void addSupportPage() {
    }

    public void addModGuide(ModGuide modGuide) {
        if (modGuide == null) {
            return;
        }
        this.guideIndex.addIndex(modGuide);
        modGuide.setXPosOffset(4);
        modGuide.setYPosOffset(4);
        modGuide.setXSize(this.mainMenu.getXSize());
        modGuide.setYSize(this.mainMenu.getYSize());
        ButtonMetro but = modGuide.getButton();
        this.addMainMenuButton(but);
    }

    protected class MainMenu
    extends VLContScissorPane {
        GuiGuide gui;

        public MainMenu(GuiGuide gui, String elementID, int xSize, int ySize) {
            super(elementID, xSize, ySize);
            this.gui = gui;
        }

        @Override
        public void mouseClicked(VLElement ele, int mx, int my, int mouseButton) {
            this.gui.mouseClicked(ele, mx, my, mouseButton);
        }

        @Override
        public void addElements() {
        }
    }
}

