/*
 * Decompiled with CFR 0.152.
 */
package shnupbups.tinkersaether.proxy;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import shnupbups.tinkersaether.TinkersAether;
import shnupbups.tinkersaether.config.TAConfig;
import shnupbups.tinkersaether.entities.EntityDart;
import shnupbups.tinkersaether.modules.ModuleTools;
import shnupbups.tinkersaether.proxy.CommonProxy;
import shnupbups.tinkersaether.render.RenderDart;
import slimeknights.tconstruct.common.ModelRegisterUtil;
import slimeknights.tconstruct.library.TinkerRegistryClient;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.ToolBuildGuiInfo;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.ToolCore;

public class ClientProxy
extends CommonProxy {
    @Override
    public void registerItemRenderer(Item item, int meta, String id) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("tinkersaether:" + id, "inventory"));
    }

    @Override
    public void setRenderInfo(Material mat, int color) {
        mat.setRenderInfo(color);
    }

    @Override
    public void setRenderInfo(Material mat, int lo, int mid, int hi) {
        mat.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.MultiColor(lo, mid, hi));
    }

    @Override
    public void registerFluidModels(Fluid fluid) {
        if (fluid == null) {
            return;
        }
        Block block = fluid.getBlock();
        if (block != null) {
            Item item = Item.func_150898_a((Block)block);
            FluidStateMapper mapper = new FluidStateMapper(fluid);
            if (item != Items.field_190931_a) {
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
            }
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
        }
    }

    @Override
    public void registerModels() {
        super.registerModels();
        if (TAConfig.darts) {
            RenderingRegistry.registerEntityRenderingHandler(EntityDart.class, RenderDart::new);
        }
        TinkersAether.logger.info("Aether Tools Module - Models Registered");
    }

    @Override
    public void registerToolModel(ToolCore tc) {
        ModelRegisterUtil.registerToolModel((ToolCore)tc);
    }

    @Override
    public void registerModifierModel(IModifier mod, ResourceLocation rl) {
        ModelRegisterUtil.registerModifierModel((IModifier)mod, (ResourceLocation)rl);
    }

    @Override
    public <T extends Item> void registerToolPartModel(T part) {
        ModelRegisterUtil.registerPartModel(part);
    }

    @Override
    public void initToolGuis() {
        if (TAConfig.darts) {
            if (ModuleTools.dartShooter != null) {
                ToolBuildGuiInfo dartShooterInfo = new ToolBuildGuiInfo((TinkersItem)ModuleTools.dartShooter);
                dartShooterInfo.addSlotPosition(23, 32);
                dartShooterInfo.addSlotPosition(41, 50);
                TinkerRegistryClient.addToolBuilding((ToolBuildGuiInfo)dartShooterInfo);
            }
            if (ModuleTools.dart != null) {
                ToolBuildGuiInfo dartInfo = new ToolBuildGuiInfo((TinkersItem)ModuleTools.dart);
                dartInfo.addSlotPosition(32, 41);
                dartInfo.addSlotPosition(14, 23);
                dartInfo.addSlotPosition(50, 59);
                TinkerRegistryClient.addToolBuilding((ToolBuildGuiInfo)dartInfo);
            }
        }
    }

    public static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final Fluid fluid;
        public final ModelResourceLocation location;

        public FluidStateMapper(Fluid fluid) {
            this.fluid = fluid;
            this.location = new ModelResourceLocation(new ResourceLocation("tinkersaether", "fluid_block"), fluid.getName());
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            return this.location;
        }

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            return this.location;
        }
    }
}

