/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import thaumicenergistics.network.packets.PacketAssemblerGUIUpdate;
import thaumicenergistics.network.packets.PacketAssemblerGUIUpdateRequest;
import thaumicenergistics.network.packets.PacketCraftRequest;
import thaumicenergistics.network.packets.PacketEssentiaFilter;
import thaumicenergistics.network.packets.PacketEssentiaFilterAction;
import thaumicenergistics.network.packets.PacketGhostEssentia;
import thaumicenergistics.network.packets.PacketInvHeldUpdate;
import thaumicenergistics.network.packets.PacketIsArcaneUpdate;
import thaumicenergistics.network.packets.PacketJEIRecipe;
import thaumicenergistics.network.packets.PacketMEEssentiaUpdate;
import thaumicenergistics.network.packets.PacketMEItemUpdate;
import thaumicenergistics.network.packets.PacketOpenGUI;
import thaumicenergistics.network.packets.PacketPlaySound;
import thaumicenergistics.network.packets.PacketSettingChange;
import thaumicenergistics.network.packets.PacketSubscribe;
import thaumicenergistics.network.packets.PacketUIAction;
import thaumicenergistics.network.packets.PacketVisUpdate;
import thaumicenergistics.util.ThELog;

public class PacketHandler {
    public static SimpleNetworkWrapper INSTANCE = null;
    private static int PACKETID = 0;

    public static int nextID() {
        return PACKETID++;
    }

    public static void register() {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("thaumicenergistics");
        INSTANCE.registerMessage(PacketEssentiaFilter.Handler.class, PacketEssentiaFilter.class, PacketHandler.nextID(), Side.CLIENT);
        INSTANCE.registerMessage(PacketMEEssentiaUpdate.Handler.class, PacketMEEssentiaUpdate.class, PacketHandler.nextID(), Side.CLIENT);
        INSTANCE.registerMessage(PacketMEItemUpdate.Handler.class, PacketMEItemUpdate.class, PacketHandler.nextID(), Side.CLIENT);
        INSTANCE.registerMessage(PacketInvHeldUpdate.Handler.class, PacketInvHeldUpdate.class, PacketHandler.nextID(), Side.CLIENT);
        INSTANCE.registerMessage(PacketVisUpdate.Handler.class, PacketVisUpdate.class, PacketHandler.nextID(), Side.CLIENT);
        INSTANCE.registerMessage(PacketSettingChange.HandlerClient.class, PacketSettingChange.class, PacketHandler.nextID(), Side.CLIENT);
        INSTANCE.registerMessage(PacketIsArcaneUpdate.Handler.class, PacketIsArcaneUpdate.class, PacketHandler.nextID(), Side.CLIENT);
        INSTANCE.registerMessage(PacketPlaySound.Handler.class, PacketPlaySound.class, PacketHandler.nextID(), Side.CLIENT);
        INSTANCE.registerMessage(PacketAssemblerGUIUpdate.Handler.class, PacketAssemblerGUIUpdate.class, PacketHandler.nextID(), Side.CLIENT);
        INSTANCE.registerMessage(PacketUIAction.Handler.class, PacketUIAction.class, PacketHandler.nextID(), Side.SERVER);
        INSTANCE.registerMessage(PacketSettingChange.HandlerServer.class, PacketSettingChange.class, PacketHandler.nextID(), Side.SERVER);
        INSTANCE.registerMessage(PacketJEIRecipe.Handler.class, PacketJEIRecipe.class, PacketHandler.nextID(), Side.SERVER);
        INSTANCE.registerMessage(PacketOpenGUI.Handler.class, PacketOpenGUI.class, PacketHandler.nextID(), Side.SERVER);
        INSTANCE.registerMessage(PacketCraftRequest.Handler.class, PacketCraftRequest.class, PacketHandler.nextID(), Side.SERVER);
        INSTANCE.registerMessage(PacketSubscribe.Handler.class, PacketSubscribe.class, PacketHandler.nextID(), Side.SERVER);
        INSTANCE.registerMessage(PacketEssentiaFilterAction.Handler.class, PacketEssentiaFilterAction.class, PacketHandler.nextID(), Side.SERVER);
        INSTANCE.registerMessage(PacketAssemblerGUIUpdateRequest.Handler.class, PacketAssemblerGUIUpdateRequest.class, PacketHandler.nextID(), Side.SERVER);
        INSTANCE.registerMessage(PacketGhostEssentia.Handler.class, PacketGhostEssentia.class, PacketHandler.nextID(), Side.SERVER);
    }

    public static void sendToPlayer(EntityPlayerMP player, IMessage message) {
        if (!(message instanceof PacketVisUpdate)) {
            // empty if block
        }
        INSTANCE.sendTo(message, player);
    }

    public static void sendToServer(IMessage message) {
        if (!(message instanceof PacketVisUpdate)) {
            ByteBuf buf = Unpooled.buffer();
            message.toBytes(buf);
            ThELog.trace("sendToServer readableBytes {} | read {} | write {} | message {}", buf.readableBytes(), buf.readerIndex(), buf.writerIndex(), message.getClass().getSimpleName());
        }
        INSTANCE.sendToServer(message);
    }

    public static void sendToAll(IMessage message) {
        if (!(message instanceof PacketVisUpdate)) {
            ByteBuf buf = Unpooled.buffer();
            message.toBytes(buf);
            ThELog.trace("sendToAll readableBytes {} | read {} | write {} | message {}", buf.readableBytes(), buf.readerIndex(), buf.writerIndex(), message.getClass().getSimpleName());
        }
        INSTANCE.sendToAll(message);
    }
}

