/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.rftools.api.screens.FormatStyle;
import mcjty.rftools.api.screens.IModuleGuiBuilder;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class NbtSanitizerModuleGuiBuilder
implements IModuleGuiBuilder {
    private final Map<String, Set<String>> enumKeys = new HashMap<String, Set<String>>();
    private final Set<String> stringKeys = new HashSet<String>();
    private final Map<String, Integer> boundedIntegerKeys = new HashMap<String, Integer>();
    private final Set<String> integerKeys = new HashSet<String>();
    private boolean hasModeKeys = false;
    private final Set<String> booleanKeys = new HashSet<String>();
    private final Set<String> itemKeys = new HashSet<String>();
    private final World world;
    @Nullable
    private final NBTTagCompound oldCompound;
    private static final Set<String> FORMAT_STRINGS = ImmutableSet.copyOf((Object[])Arrays.stream(FormatStyle.values()).map(FormatStyle::getName).toArray(String[]::new));

    public NbtSanitizerModuleGuiBuilder(World world, @Nullable NBTTagCompound oldCompound) {
        this.world = world;
        this.oldCompound = oldCompound;
    }

    public NBTTagCompound sanitizeNbt(NBTTagCompound fromClient) {
        String key;
        NBTTagCompound newCompound = this.oldCompound != null ? this.oldCompound.func_74737_b() : new NBTTagCompound();
        for (Map.Entry<String, Set<String>> entry : this.enumKeys.entrySet()) {
            key = entry.getKey();
            if (!fromClient.func_150297_b(key, 8)) continue;
            String value = fromClient.func_74779_i(key);
            if (!entry.getValue().contains(value)) continue;
            newCompound.func_74778_a(key, value);
        }
        for (String string : this.stringKeys) {
            if (!fromClient.func_150297_b(string, 8)) continue;
            newCompound.func_74778_a(string, fromClient.func_74779_i(string));
        }
        for (Map.Entry entry : this.boundedIntegerKeys.entrySet()) {
            int value;
            key = (String)entry.getKey();
            if (!fromClient.func_150297_b(key, 3) || (value = fromClient.func_74762_e(key)) < 0 || value >= (Integer)entry.getValue()) continue;
            newCompound.func_74768_a(key, value);
        }
        for (String string : this.integerKeys) {
            if (!fromClient.func_150297_b(string, 3)) continue;
            newCompound.func_74768_a(string, fromClient.func_74762_e(string));
        }
        if (this.hasModeKeys && fromClient.func_150297_b("showdiff", 1) && fromClient.func_150297_b("showpct", 1) && fromClient.func_150297_b("hidetext", 1)) {
            boolean showdiff = fromClient.func_74767_n("showdiff");
            boolean bl = fromClient.func_74767_n("showpct");
            boolean hidetext = fromClient.func_74767_n("hidetext");
            if (!(showdiff && bl || showdiff && hidetext || bl && hidetext)) {
                newCompound.func_74757_a("showdiff", showdiff);
                newCompound.func_74757_a("showpct", bl);
                newCompound.func_74757_a("hidetext", hidetext);
            }
        }
        for (String string : this.booleanKeys) {
            if (!fromClient.func_150297_b(string, 1)) continue;
            newCompound.func_74757_a(string, fromClient.func_74767_n(string));
        }
        for (String string : this.itemKeys) {
            if (fromClient.func_150297_b(string, 10)) {
                NBTTagCompound tag = new NBTTagCompound();
                new ItemStack(fromClient.func_74775_l(string)).func_77955_b(tag);
                newCompound.func_74782_a(string, (NBTBase)tag);
                continue;
            }
            newCompound.func_82580_o(string);
        }
        return newCompound;
    }

    @Override
    public NBTTagCompound getCurrentData() {
        return this.oldCompound.func_74737_b();
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public IModuleGuiBuilder choices(String tagname, String tooltip, String ... choices) {
        this.enumKeys.put(tagname, (Set<String>)ImmutableSet.copyOf((Object[])choices));
        return this;
    }

    @Override
    public IModuleGuiBuilder format(String tagname) {
        this.enumKeys.put(tagname, FORMAT_STRINGS);
        return this;
    }

    @Override
    public IModuleGuiBuilder text(String tagname, String ... tooltip) {
        this.stringKeys.add(tagname);
        return this;
    }

    @Override
    public IModuleGuiBuilder choices(String tagname, IModuleGuiBuilder.Choice ... choices) {
        this.boundedIntegerKeys.put(tagname, choices.length);
        return this;
    }

    @Override
    public IModuleGuiBuilder integer(String tagname, String ... tooltip) {
        this.integerKeys.add(tagname);
        return this;
    }

    @Override
    public IModuleGuiBuilder color(String tagname, String ... tooltip) {
        this.integerKeys.add(tagname);
        return this;
    }

    @Override
    public IModuleGuiBuilder mode(String componentName) {
        this.hasModeKeys = true;
        return this;
    }

    @Override
    public IModuleGuiBuilder toggle(String tagname, String label, String ... tooltip) {
        this.booleanKeys.add(tagname);
        return this;
    }

    @Override
    public IModuleGuiBuilder toggleNegative(String tagname, String label, String ... tooltip) {
        this.booleanKeys.add(tagname);
        return this;
    }

    @Override
    public IModuleGuiBuilder ghostStack(String tagname) {
        this.itemKeys.add(tagname);
        return this;
    }

    @Override
    public IModuleGuiBuilder label(String text) {
        return this;
    }

    @Override
    public IModuleGuiBuilder leftLabel(String text) {
        return this;
    }

    @Override
    public IModuleGuiBuilder block(String tagname) {
        return this;
    }

    @Override
    public IModuleGuiBuilder nl() {
        return this;
    }
}

