/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machines.cluster;

import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileCreativeCluster
extends TileEntity
implements IEnergyProvider,
IEnergyStorage,
ITickable {
    public int transferRate = 100000;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("XferRate", this.transferRate);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.transferRate = tag.func_74762_e("XferRate");
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (EnumFacing dir : EnumFacing.values()) {
            IEnergyReceiver receiver;
            BlockPos targetBlock = this.func_174877_v().func_177971_a(dir.func_176730_m());
            TileEntity tile = this.field_145850_b.func_175625_s(targetBlock);
            if (tile == null) continue;
            if (tile instanceof IEnergyReceiver) {
                receiver = (IEnergyReceiver)tile;
                if (!receiver.canConnectEnergy(dir.func_176734_d())) continue;
                receiver.receiveEnergy(dir.func_176734_d(), this.transferRate, false);
                continue;
            }
            if (!tile.hasCapability(CapabilityEnergy.ENERGY, dir.func_176734_d()) || !(receiver = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, dir.func_176734_d())).canReceive()) continue;
            receiver.receiveEnergy(this.transferRate, false);
        }
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return maxExtract;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.getMaxEnergyStored(from);
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return 10000000;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean canExtract() {
        return this.canConnectEnergy(null);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.extractEnergy(null, maxExtract, simulate);
    }

    public boolean canReceive() {
        return false;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.getEnergyStored(null);
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(null);
    }
}

