/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.world.data;

import epicsquid.mysticalworld.world.StructureGenerator;
import epicsquid.mysticalworld.world.data.StructureSaveData;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class DataHelper {
    public static StructureSaveData getStructureData(World world) {
        StructureSaveData saveData = (StructureSaveData)world.func_175693_T().func_75742_a(StructureSaveData.class, "MysticalWorld-StructureSaveData");
        if (saveData == null) {
            saveData = new StructureSaveData();
            world.func_175693_T().func_75745_a("MysticalWorld-StructureSaveData", (WorldSavedData)saveData);
        }
        return saveData;
    }

    public static List<BlockPos> getGeneratorMap(StructureGenerator generator, World world) {
        return DataHelper.getGeneratorMap(generator.getRegistryName(), world);
    }

    public static List<BlockPos> getGeneratorMap(ResourceLocation location, World world) {
        StructureSaveData saveData = DataHelper.getStructureData(world);
        return saveData.getGeneratorMap(location);
    }

    public static int distance(BlockPos pos1, BlockPos pos2) {
        int d1 = pos1.func_177958_n() - pos2.func_177958_n();
        int d2 = pos1.func_177952_p() - pos2.func_177952_p();
        return Math.abs(d1 * d1 + d2 * d2);
    }

    public static boolean testBlockPos(ResourceLocation location, BlockPos pos, int maxDistance, World world) {
        List<BlockPos> map = DataHelper.getGeneratorMap(location, world);
        for (BlockPos otherPos : map) {
            int dist = DataHelper.distance(pos, otherPos);
            if (dist >= maxDistance) continue;
            return false;
        }
        return true;
    }

    public static void putBlockPos(ResourceLocation location, BlockPos pos, World world) {
        List<BlockPos> map = DataHelper.getGeneratorMap(location, world);
        map.add(pos);
    }

    public static void save(World world) {
        StructureSaveData saveData = DataHelper.getStructureData(world);
        saveData.func_76185_a();
        world.func_175693_T().func_75744_a();
    }
}

