/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.util;

import java.util.Iterator;
import net.minecraft.util.math.Vec3d;

public class VecUtil {
    public static Iterable<Vec3d> pointsBetween(Vec3d start, Vec3d stop) {
        return VecUtil.pointsBetween(start, stop, -1);
    }

    public static Iterable<Vec3d> pointsBetween(Vec3d start, Vec3d stop, int maxLength) {
        return new VecIterable(start, stop, maxLength);
    }

    public static Iterable<Vec3d> pointsFrom(Vec3d start, Vec3d vec) {
        return VecUtil.pointsBetween(start, start.func_178787_e(vec), (int)vec.func_72433_c());
    }

    protected static class VecIterable
    implements Iterable<Vec3d> {
        private Vec3d start;
        private Vec3d size;

        public VecIterable(Vec3d start, Vec3d stop, int maxLength) {
            this.start = start;
            Vec3d line = stop.func_178788_d(start);
            this.size = maxLength != -1 ? line.func_186678_a(line.func_72433_c() / (double)maxLength) : line;
        }

        @Override
        public Iterator<Vec3d> iterator() {
            return new VecIterator();
        }

        protected class VecIterator
        implements Iterator<Vec3d> {
            private double progress = 0.0;

            protected VecIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.progress < 1.0;
            }

            @Override
            public Vec3d next() {
                this.progress += 1.0 / VecIterable.this.size.func_72433_c();
                return VecIterable.this.start.func_178787_e(VecIterable.this.size.func_186678_a(this.progress));
            }
        }
    }
}

